/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BacklogDebugger
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BacklogDebugger.class);
    private long fallbackTimeout = 300L;
    private final CamelContext camelContext;
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    private final CamelLogger logger = new CamelLogger(LOG, this.loggingLevel);
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final AtomicLong debugCounter = new AtomicLong();
    private final Debugger debugger;
    private final ConcurrentMap<String, NodeBreakpoint> breakpoints = new ConcurrentHashMap<String, NodeBreakpoint>();
    private final ConcurrentMap<String, SuspendedExchange> suspendedBreakpoints = new ConcurrentHashMap<String, SuspendedExchange>();
    private final ConcurrentMap<String, BacklogTracerEventMessage> suspendedBreakpointMessages = new ConcurrentHashMap<String, BacklogTracerEventMessage>();
    private volatile String singleStepExchangeId;
    private int bodyMaxChars = 131072;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;

    private BacklogDebugger(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.debugger = new DefaultDebugger(camelContext);
    }

    public static BacklogDebugger createDebugger(CamelContext context) {
        return new BacklogDebugger(context);
    }

    public static BacklogDebugger getBacklogDebugger(CamelContext context) {
        return context.hasService(BacklogDebugger.class);
    }

    public String getLoggingLevel() {
        return this.loggingLevel.name();
    }

    public void setLoggingLevel(String level) {
        this.loggingLevel = LoggingLevel.valueOf(level);
        this.logger.setLevel(this.loggingLevel);
    }

    public void enableDebugger() {
        this.logger.log("Enabling debugger");
        try {
            ServiceHelper.startService((Object)this.debugger);
            this.enabled.set(true);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    public void disableDebugger() {
        this.logger.log("Disabling debugger");
        try {
            this.enabled.set(false);
            ServiceHelper.stopService((Object)this.debugger);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearBreakpoints();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean hasBreakpoint(String nodeId) {
        return this.breakpoints.containsKey(nodeId);
    }

    public boolean isSingleStepMode() {
        return this.singleStepExchangeId != null;
    }

    public void addBreakpoint(String nodeId) {
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint == null) {
            this.logger.log("Adding breakpoint " + nodeId);
            breakpoint = new NodeBreakpoint(nodeId, null);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else {
            breakpoint.setCondition(null);
        }
    }

    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        Predicate condition = this.camelContext.resolveLanguage(language).createPredicate(predicate);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint == null) {
            this.logger.log("Adding conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint = new NodeBreakpoint(nodeId, condition);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else if (breakpoint.getCondition() == null) {
            this.logger.log("Updating to conditional breakpoint " + nodeId + " [" + predicate + "]");
            this.debugger.removeBreakpoint(breakpoint);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint(breakpoint, breakpoint);
        } else if (breakpoint.getCondition() != null) {
            this.logger.log("Updating conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint.setCondition(condition);
        }
    }

    public void removeBreakpoint(String nodeId) {
        this.logger.log("Removing breakpoint " + nodeId);
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.remove(nodeId);
        if (breakpoint != null) {
            this.debugger.removeBreakpoint(breakpoint);
        }
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    public void removeAllBreakpoints() {
        this.singleStepExchangeId = null;
        for (String nodeId : this.getSuspendedBreakpointNodeIds()) {
            this.removeBreakpoint(nodeId);
        }
    }

    public Set<String> getBreakpoints() {
        return new LinkedHashSet<String>(this.breakpoints.keySet());
    }

    public void resumeBreakpoint(String nodeId) {
        this.resumeBreakpoint(nodeId, false);
    }

    private void resumeBreakpoint(String nodeId, boolean stepMode) {
        this.logger.log("Resume breakpoint " + nodeId);
        if (!stepMode && this.singleStepExchangeId != null) {
            this.debugger.stopSingleStepExchange(this.singleStepExchangeId);
            this.singleStepExchangeId = null;
        }
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                Class<?> oldType = se.getExchange().getMessage().getBody() != null ? se.getExchange().getMessage().getBody().getClass() : null;
                this.setMessageBodyOnBreakpoint(nodeId, body, oldType);
            }
        }
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body, Class<?> type) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                this.logger.log("Breakpoint at node " + nodeId + " is updating message body on exchangeId: " + se.getExchange().getExchangeId() + " with new body: " + body);
                if (type != null) {
                    se.getExchange().getMessage().setBody(body, type);
                } else {
                    se.getExchange().getMessage().setBody(body);
                }
            }
        }
    }

    public void removeMessageBodyOnBreakpoint(String nodeId) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing message body on exchangeId: " + se.getExchange().getExchangeId());
            se.getExchange().getMessage().setBody(null);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(headerName) != null ? se.getExchange().getMessage().getHeader(headerName).getClass() : null;
            this.setMessageHeaderOnBreakpoint(nodeId, headerName, value, oldType);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating message header on exchangeId: " + se.getExchange().getExchangeId() + " with header: " + headerName + " and value: " + value);
            if (type != null) {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().getMessage().setHeader(headerName, convertedValue);
            } else {
                se.getExchange().getMessage().setHeader(headerName, value);
            }
        }
    }

    public long getFallbackTimeout() {
        return this.fallbackTimeout;
    }

    public void setFallbackTimeout(long fallbackTimeout) {
        this.fallbackTimeout = fallbackTimeout;
    }

    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing message header on exchangeId: " + se.getExchange().getExchangeId() + " with header: " + headerName);
            se.getExchange().getMessage().removeHeader(headerName);
        }
    }

    public void resumeAll() {
        this.logger.log("Resume all");
        this.singleStepExchangeId = null;
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    public void stepBreakpoint(String nodeId) {
        if (this.isSingleStepMode()) {
            this.logger.log("stepBreakpoint " + nodeId + " is already in single step mode, so stepping instead.");
            this.step();
        }
        this.logger.log("Step breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (msg != null && breakpoint != null) {
            this.singleStepExchangeId = msg.getExchangeId();
            if (this.debugger.startSingleStepExchange(this.singleStepExchangeId, new StepBreakpoint())) {
                this.resumeBreakpoint(nodeId, true);
            }
        }
    }

    public void step() {
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    public Set<String> getSuspendedBreakpointNodeIds() {
        return new LinkedHashSet<String>(this.suspendedBreakpoints.keySet());
    }

    public Exchange getSuspendedExchange(String id) {
        SuspendedExchange suspendedExchange = (SuspendedExchange)this.suspendedBreakpoints.get(id);
        return suspendedExchange != null ? suspendedExchange.getExchange() : null;
    }

    public void disableBreakpoint(String nodeId) {
        this.logger.log("Disable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint != null) {
            breakpoint.suspend();
        }
    }

    public void enableBreakpoint(String nodeId) {
        this.logger.log("Enable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)this.breakpoints.get(nodeId);
        if (breakpoint != null) {
            breakpoint.activate();
        }
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        this.logger.log("Dump trace message from breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        if (msg != null) {
            return msg.toXml(0);
        }
        return null;
    }

    public long getDebugCounter() {
        return this.debugCounter.get();
    }

    public void resetDebugCounter() {
        this.logger.log("Reset debug counter");
        this.debugCounter.set(0L);
    }

    public boolean beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
        return this.debugger.beforeProcess(exchange, processor, definition);
    }

    public boolean afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
        return false;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        if (this.enabled.get()) {
            this.disableDebugger();
        }
        this.clearBreakpoints();
    }

    private void clearBreakpoints() {
        this.breakpoints.clear();
        for (SuspendedExchange se : this.suspendedBreakpoints.values()) {
            se.getLatch().countDown();
        }
        this.suspendedBreakpoints.clear();
        this.suspendedBreakpointMessages.clear();
    }

    private final class StepBreakpoint
    extends BreakpointSupport
    implements Condition {
        private StepBreakpoint() {
        }

        @Override
        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId(definition);
            String exchangeId = exchange.getExchangeId();
            String messageAsXml = MessageHelper.dumpAsXml(exchange.getIn(), true, 2, BacklogDebugger.this.isBodyIncludeStreams(), BacklogDebugger.this.isBodyIncludeFiles(), BacklogDebugger.this.getBodyMaxChars());
            long uid = BacklogDebugger.this.debugCounter.incrementAndGet();
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(uid, timestamp, routeId, toNode, exchangeId, messageAsXml);
            BacklogDebugger.this.suspendedBreakpointMessages.put(toNode, msg);
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            BacklogDebugger.this.suspendedBreakpoints.put(toNode, se);
            BacklogDebugger.this.logger.log("StepBreakpoint at node " + toNode + " is waiting to continue for exchangeId: " + exchange.getExchangeId());
            try {
                boolean hit = se.getLatch().await(BacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                if (!hit) {
                    BacklogDebugger.this.logger.log("StepBreakpoint at node " + toNode + " timed out and is continued exchangeId: " + exchange.getExchangeId(), LoggingLevel.WARN);
                } else {
                    BacklogDebugger.this.logger.log("StepBreakpoint at node " + toNode + " is continued exchangeId: " + exchange.getExchangeId());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition) {
            return true;
        }

        @Override
        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return event instanceof CamelEvent.ExchangeCompletedEvent;
        }

        @Override
        public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
            if (event instanceof CamelEvent.ExchangeCompletedEvent) {
                String completedId = event.getExchange().getExchangeId();
                if (BacklogDebugger.this.singleStepExchangeId != null && BacklogDebugger.this.singleStepExchangeId.equals(completedId)) {
                    BacklogDebugger.this.logger.log("ExchangeId: " + completedId + " is completed, so exiting single step mode.");
                    BacklogDebugger.this.singleStepExchangeId = null;
                }
            }
        }
    }

    private final class NodeBreakpoint
    extends BreakpointSupport
    implements Condition {
        private final String nodeId;
        private Predicate condition;

        private NodeBreakpoint(String nodeId, Predicate condition) {
            this.nodeId = nodeId;
            this.condition = condition;
        }

        public Predicate getCondition() {
            return this.condition;
        }

        public void setCondition(Predicate predicate) {
            this.condition = predicate;
        }

        @Override
        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId(definition);
            String exchangeId = exchange.getExchangeId();
            String messageAsXml = MessageHelper.dumpAsXml(exchange.getIn(), true, 2, BacklogDebugger.this.isBodyIncludeStreams(), BacklogDebugger.this.isBodyIncludeFiles(), BacklogDebugger.this.getBodyMaxChars());
            long uid = BacklogDebugger.this.debugCounter.incrementAndGet();
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(uid, timestamp, routeId, toNode, exchangeId, messageAsXml);
            BacklogDebugger.this.suspendedBreakpointMessages.put(this.nodeId, msg);
            SuspendedExchange se = (SuspendedExchange)BacklogDebugger.this.suspendedBreakpoints.get(this.nodeId);
            if (se != null) {
                BacklogDebugger.this.logger.log("NodeBreakpoint at node " + toNode + " is waiting to continue for exchangeId: " + exchangeId);
                try {
                    boolean hit = se.getLatch().await(BacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                    if (!hit) {
                        BacklogDebugger.this.logger.log("NodeBreakpoint at node " + toNode + " timed out and is continued exchangeId: " + exchangeId, LoggingLevel.WARN);
                    } else {
                        BacklogDebugger.this.logger.log("NodeBreakpoint at node " + toNode + " is continued exchangeId: " + exchangeId);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition) {
            if (!this.nodeId.equals(definition.getId())) {
                return false;
            }
            if (this.condition != null && !this.condition.matches(exchange)) {
                return false;
            }
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            boolean existing = BacklogDebugger.this.suspendedBreakpoints.putIfAbsent(this.nodeId, se) != null;
            return !existing;
        }

        @Override
        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return false;
        }
    }

    private static final class SuspendedExchange {
        private final Exchange exchange;
        private final CountDownLatch latch;

        private SuspendedExchange(Exchange exchange, CountDownLatch latch) {
            this.exchange = exchange;
            this.latch = latch;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

