/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.NamedNode;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.Service;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;

public class DefaultRoute
extends ServiceSupport
implements Route {
    private final CamelContext camelContext;
    private NamedNode route;
    private final String routeId;
    private final String routeDescription;
    private final List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>(0);
    private ManagementInterceptStrategy managementInterceptStrategy;
    private Boolean trace;
    private Boolean backlogTrace;
    private Boolean debug;
    private Boolean messageHistory;
    private Boolean logMask;
    private Boolean logExhaustedMessageBody;
    private Boolean streamCache;
    private Long delay;
    private Boolean autoStartup = Boolean.TRUE;
    private final List<RoutePolicy> routePolicyList = new ArrayList<RoutePolicy>();
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;
    private final Map<String, Processor> onCompletions = new HashMap<String, Processor>();
    private final Map<String, Processor> onExceptions = new HashMap<String, Processor>();
    private ErrorHandlerFactory errorHandlerFactory;
    private final ConcurrentMap<ErrorHandlerFactory, Set<NamedNode>> errorHandlers = new ConcurrentHashMap<ErrorHandlerFactory, Set<NamedNode>>();
    private final Endpoint endpoint;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<Service> services = new ArrayList<Service>();
    private long startDate;
    private RouteError routeError;
    private Integer startupOrder;
    private RouteController routeController;
    private Processor processor;
    private Consumer consumer;

    public DefaultRoute(CamelContext camelContext, NamedNode route, String routeId, String routeDescription, Endpoint endpoint) {
        this.camelContext = camelContext;
        this.route = route;
        this.routeId = routeId;
        this.routeDescription = routeDescription;
        this.endpoint = endpoint;
    }

    @Override
    public String getId() {
        return this.routeId;
    }

    @Override
    public String getGroup() {
        return (String)this.properties.get("group");
    }

    @Override
    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration(delta);
    }

    @Override
    public long getUptimeMillis() {
        if (this.startDate == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.startDate;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getDescription() {
        Object value = this.properties.get("description");
        return value != null ? (String)value : null;
    }

    @Override
    public void initializeServices() throws Exception {
        this.gatherServices(this.services);
    }

    @Override
    public List<Service> getServices() {
        return this.services;
    }

    @Override
    public void addService(Service service) {
        if (!this.services.contains(service)) {
            this.services.add(service);
        }
    }

    @Override
    public void warmUp() {
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    protected void doStart() throws Exception {
        this.startDate = System.currentTimeMillis();
    }

    @Override
    protected void doStop() throws Exception {
        this.startDate = 0L;
    }

    @Override
    protected void doShutdown() throws Exception {
        this.services.clear();
    }

    @Override
    public RouteError getLastError() {
        return this.routeError;
    }

    @Override
    public void setLastError(RouteError routeError) {
        this.routeError = routeError;
    }

    @Override
    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    @Override
    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    @Override
    public RouteController getRouteController() {
        return this.routeController;
    }

    @Override
    public void setRouteController(RouteController routeController) {
        this.routeController = routeController;
    }

    @Override
    public Boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public NamedNode getRoute() {
        return this.route;
    }

    @Override
    public void clearRouteModel() {
        this.route = null;
        this.errorHandlerFactory = null;
        this.errorHandlers.clear();
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public String getRouteDescription() {
        return this.routeDescription;
    }

    @Override
    public List<Processor> getEventDrivenProcessors() {
        return this.eventDrivenProcessors;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    @Override
    public void setManagementInterceptStrategy(ManagementInterceptStrategy interceptStrategy) {
        this.managementInterceptStrategy = interceptStrategy;
    }

    @Override
    public ManagementInterceptStrategy getManagementInterceptStrategy() {
        return this.managementInterceptStrategy;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        if (this.trace != null) {
            return this.trace;
        }
        return this.camelContext.isTracing();
    }

    @Override
    public String getTracingPattern() {
        return this.camelContext.getTracingPattern();
    }

    @Override
    public void setTracingPattern(String tracePattern) {
        this.camelContext.setTracingPattern(tracePattern);
    }

    @Override
    public void setBacklogTracing(Boolean backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    @Override
    public Boolean isBacklogTracing() {
        if (this.backlogTrace != null) {
            return this.backlogTrace;
        }
        return this.camelContext.isBacklogTracing();
    }

    @Override
    public void setDebugging(Boolean debugging) {
        this.debug = debugging;
    }

    @Override
    public Boolean isDebugging() {
        if (this.debug != null) {
            return this.debug;
        }
        return this.camelContext.isDebugging();
    }

    @Override
    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public Boolean isMessageHistory() {
        if (this.messageHistory != null) {
            return this.messageHistory;
        }
        return this.camelContext.isMessageHistory();
    }

    @Override
    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    @Override
    public Boolean isLogMask() {
        if (this.logMask != null) {
            return this.logMask;
        }
        return this.camelContext.isLogMask();
    }

    @Override
    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    @Override
    public Boolean isLogExhaustedMessageBody() {
        if (this.logExhaustedMessageBody != null) {
            return this.logExhaustedMessageBody;
        }
        return this.camelContext.isLogExhaustedMessageBody();
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        if (this.streamCache != null) {
            return this.streamCache;
        }
        return this.camelContext.isStreamCaching();
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public Long getDelayer() {
        if (this.delay != null) {
            return this.delay;
        }
        return this.camelContext.getDelayer();
    }

    @Override
    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    @Override
    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.camelContext.setAllowUseOriginalMessage(allowUseOriginalMessage);
    }

    @Override
    public Boolean isAllowUseOriginalMessage() {
        return this.camelContext.isAllowUseOriginalMessage();
    }

    @Override
    public Boolean isCaseInsensitiveHeaders() {
        return this.camelContext.isCaseInsensitiveHeaders();
    }

    @Override
    public void setCaseInsensitiveHeaders(Boolean caseInsensitiveHeaders) {
        this.camelContext.setCaseInsensitiveHeaders(caseInsensitiveHeaders);
    }

    @Override
    public Boolean isAutowiredEnabled() {
        return this.camelContext.isAutowiredEnabled();
    }

    @Override
    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.camelContext.setAutowiredEnabled(autowiredEnabled);
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        if (this.shutdownRoute != null) {
            return this.shutdownRoute;
        }
        return this.camelContext.getShutdownRoute();
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        if (this.shutdownRunningTask != null) {
            return this.shutdownRunningTask;
        }
        return this.camelContext.getShutdownRunningTask();
    }

    @Override
    public List<RoutePolicy> getRoutePolicyList() {
        return this.routePolicyList;
    }

    @Override
    public Collection<Processor> getOnCompletions() {
        return this.onCompletions.values();
    }

    @Override
    public void setOnCompletion(String onCompletionId, Processor processor) {
        this.onCompletions.put(onCompletionId, processor);
    }

    @Override
    public Collection<Processor> getOnExceptions() {
        return this.onExceptions.values();
    }

    @Override
    public Processor getOnException(String onExceptionId) {
        return this.onExceptions.get(onExceptionId);
    }

    @Override
    public void setOnException(String onExceptionId, Processor processor) {
        this.onExceptions.put(onExceptionId, processor);
    }

    @Override
    public Set<NamedNode> getErrorHandlers(ErrorHandlerFactory factory) {
        return this.errorHandlers.computeIfAbsent(factory, f -> new LinkedHashSet());
    }

    @Override
    public void addErrorHandler(ErrorHandlerFactory factory, NamedNode onException) {
        this.errorHandlers.computeIfAbsent(factory, f -> new LinkedHashSet()).add(onException);
    }

    @Override
    public void addErrorHandlerFactoryReference(ErrorHandlerFactory source, ErrorHandlerFactory target) {
        Set<NamedNode> previous;
        Set list = this.errorHandlers.computeIfAbsent(source, f -> new LinkedHashSet());
        if (list != (previous = this.errorHandlers.put(target, list)) && ObjectHelper.isNotEmpty(previous) && ObjectHelper.isNotEmpty(list)) {
            throw new IllegalStateException("Multiple references with different handlers");
        }
    }

    public String toString() {
        return "Route[" + this.getEndpoint() + " -> " + this.processor + "]";
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    protected void gatherServices(List<Service> services) throws Exception {
        this.gatherRootServices(services);
        ArrayList<Service> children = new ArrayList<Service>();
        for (Service service : services) {
            Set<Service> extra = ServiceHelper.getChildServices(service);
            children.addAll(extra);
        }
        for (Service extra : children) {
            if (services.contains(extra)) continue;
            services.add(extra);
        }
    }

    protected void gatherRootServices(List<Service> services) throws Exception {
        Endpoint endpoint = this.getEndpoint();
        this.consumer = endpoint.createConsumer(this.processor);
        if (this.consumer != null) {
            services.add(this.consumer);
            if (this.consumer instanceof RouteAware) {
                ((RouteAware)((Object)this.consumer)).setRoute(this);
            }
            if (this.consumer instanceof RouteIdAware) {
                ((RouteIdAware)((Object)this.consumer)).setRouteId(this.getId());
            }
        }
        if (this.processor instanceof Service) {
            services.add((Service)((Object)this.processor));
        }
        for (Processor p : this.onCompletions.values()) {
            if (!(this.processor instanceof Service)) continue;
            services.add((Service)((Object)p));
        }
        for (Processor p : this.onExceptions.values()) {
            if (!(this.processor instanceof Service)) continue;
            services.add((Service)((Object)p));
        }
    }

    @Override
    public Navigate<Processor> navigate() {
        Processor answer = this.getProcessor();
        if (answer instanceof Navigate) {
            Object first;
            Navigate nav = (Navigate)((Object)answer);
            if (nav.next().size() == 1 && (first = nav.next().get(0)) instanceof Navigate) {
                return (Navigate)first;
            }
            return (Navigate)((Object)answer);
        }
        return null;
    }

    @Override
    public List<Processor> filter(String pattern) {
        ArrayList<Processor> match = new ArrayList<Processor>();
        this.doFilter(pattern, this.navigate(), match);
        return match;
    }

    private void doFilter(String pattern, Navigate<Processor> nav, List<Processor> match) {
        List<Processor> list = nav.next();
        if (list != null) {
            for (Processor proc : list) {
                String id = null;
                if (proc instanceof IdAware) {
                    id = ((IdAware)((Object)proc)).getId();
                }
                if (PatternHelper.matchPattern(id, pattern)) {
                    match.add(proc);
                }
                if (!(proc instanceof Navigate)) continue;
                Navigate child = (Navigate)((Object)proc);
                this.doFilter(pattern, child, match);
            }
        }
    }

    @Override
    public Consumer getConsumer() {
        return this.consumer;
    }

    @Override
    public boolean supportsSuspension() {
        return this.consumer instanceof Suspendable && this.consumer instanceof SuspendableService;
    }
}

