/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedStartupListener;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.impl.engine.DefaultRouteController;
import org.apache.camel.impl.engine.DefaultRouteError;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSupervisingRouteController
extends DefaultRouteController
implements SupervisingRouteController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSupervisingRouteController.class);
    private final Object lock = new Object();
    private final AtomicBoolean contextStarted = new AtomicBoolean();
    private final AtomicInteger routeCount = new AtomicInteger();
    private final Set<RouteHolder> routes = new TreeSet<RouteHolder>();
    private final Set<String> nonSupervisedRoutes = new HashSet<String>();
    private final RouteManager routeManager = new RouteManager();
    private volatile CamelContextStartupListener listener;
    private volatile BackOffTimer timer;
    private volatile ScheduledExecutorService executorService;
    private volatile BackOff backOff;
    private String includeRoutes;
    private String excludeRoutes;
    private int threadPoolSize = 1;
    private long initialDelay;
    private long backOffDelay = 2000L;
    private long backOffMaxDelay;
    private long backOffMaxElapsedTime;
    private long backOffMaxAttempts;
    private double backOffMultiplier = 1.0;
    private boolean unhealthyOnExhausted;

    @Override
    public String getIncludeRoutes() {
        return this.includeRoutes;
    }

    @Override
    public void setIncludeRoutes(String includeRoutes) {
        this.includeRoutes = includeRoutes;
    }

    @Override
    public String getExcludeRoutes() {
        return this.excludeRoutes;
    }

    @Override
    public void setExcludeRoutes(String excludeRoutes) {
        this.excludeRoutes = excludeRoutes;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Override
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Override
    public long getBackOffDelay() {
        return this.backOffDelay;
    }

    @Override
    public void setBackOffDelay(long backOffDelay) {
        this.backOffDelay = backOffDelay;
    }

    @Override
    public long getBackOffMaxDelay() {
        return this.backOffMaxDelay;
    }

    @Override
    public void setBackOffMaxDelay(long backOffMaxDelay) {
        this.backOffMaxDelay = backOffMaxDelay;
    }

    @Override
    public long getBackOffMaxElapsedTime() {
        return this.backOffMaxElapsedTime;
    }

    @Override
    public void setBackOffMaxElapsedTime(long backOffMaxElapsedTime) {
        this.backOffMaxElapsedTime = backOffMaxElapsedTime;
    }

    @Override
    public long getBackOffMaxAttempts() {
        return this.backOffMaxAttempts;
    }

    @Override
    public void setBackOffMaxAttempts(long backOffMaxAttempts) {
        this.backOffMaxAttempts = backOffMaxAttempts;
    }

    @Override
    public double getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    @Override
    public void setBackOffMultiplier(double backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    @Override
    public boolean isUnhealthyOnExhausted() {
        return this.unhealthyOnExhausted;
    }

    @Override
    public void setUnhealthyOnExhausted(boolean unhealthyOnExhausted) {
        this.unhealthyOnExhausted = unhealthyOnExhausted;
    }

    protected BackOff getBackOff(String id) {
        return this.backOff;
    }

    @Override
    protected void doInit() throws Exception {
        this.listener = new CamelContextStartupListener();
        CamelContext context = this.getCamelContext();
        context.setAutoStartup(false);
        context.addRoutePolicyFactory(new ManagedRoutePolicyFactory());
        context.addStartupListener(this.listener);
    }

    @Override
    protected void doStart() throws Exception {
        this.backOff = new BackOff(Duration.ofMillis(this.backOffDelay), this.backOffMaxDelay > 0L ? Duration.ofMillis(this.backOffMaxDelay) : null, this.backOffMaxElapsedTime > 0L ? Duration.ofMillis(this.backOffMaxElapsedTime) : null, this.backOffMaxAttempts > 0L ? this.backOffMaxAttempts : Long.MAX_VALUE, this.backOffMultiplier);
        CamelContext context = this.getCamelContext();
        this.executorService = this.threadPoolSize == 1 ? context.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "SupervisingRouteController") : context.getExecutorServiceManager().newScheduledThreadPool((Object)this, "SupervisingRouteController", this.threadPoolSize);
        this.timer = new BackOffTimer(this.executorService);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.getCamelContext() != null && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
            this.timer = null;
        }
    }

    @Override
    public void startRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.startRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, r -> super.startRoute(routeId));
        }
    }

    @Override
    public void stopRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, r -> super.stopRoute(routeId));
        }
    }

    @Override
    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, r -> super.stopRoute(r.getId(), timeout, timeUnit));
        }
    }

    @Override
    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            return super.stopRoute(routeId, timeout, timeUnit, abortAfterTimeout);
        }
        AtomicBoolean result = new AtomicBoolean();
        this.doStopRoute(route.get(), true, r -> result.set(super.stopRoute(r.getId(), timeout, timeUnit, abortAfterTimeout)));
        return result.get();
    }

    @Override
    public void suspendRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, r -> super.suspendRoute(r.getId()));
        }
    }

    @Override
    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, r -> super.suspendRoute(r.getId(), timeout, timeUnit));
        }
    }

    @Override
    public void resumeRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.resumeRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, r -> super.startRoute(routeId));
        }
    }

    @Override
    public Collection<Route> getControlledRoutes() {
        return this.routes.stream().map(RouteHolder::get).collect(Collectors.toList());
    }

    @Override
    public Collection<Route> getRestartingRoutes() {
        return this.routeManager.routes.keySet().stream().map(RouteHolder::get).collect(Collectors.toList());
    }

    @Override
    public Collection<Route> getExhaustedRoutes() {
        return this.routeManager.exhausted.keySet().stream().map(RouteHolder::get).collect(Collectors.toList());
    }

    @Override
    public Set<String> getNonControlledRouteIds() {
        return Collections.unmodifiableSet(this.nonSupervisedRoutes);
    }

    @Override
    public BackOffTimer.Task getRestartingRouteState(String routeId) {
        return this.routeManager.getBackOffContext(routeId).orElse(null);
    }

    @Override
    public Throwable getRestartException(String routeId) {
        return (Throwable)this.routeManager.exceptions.get(routeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (checker) {
                this.routeManager.release(route);
            }
            LOG.debug("Route {} has been requested to stop", (Object)route.getId());
            route.get().setRouteController(null);
            consumer.accept(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            route.get().setRouteController(this);
            try {
                if (checker) {
                    this.routeManager.release(route);
                }
                consumer.accept(route);
            }
            catch (Exception e) {
                if (checker) {
                    this.routeManager.start(route);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNonSupervisedRoutes() throws Exception {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Stopped).filter(r -> !this.isSupervised(((RouteHolder)r).route)).map(RouteHolder::getId).collect(Collectors.toList());
        }
        for (String route : routeList) {
            try {
                LOG.debug("Starting non-supervised route {}", (Object)route);
                super.startRoute(route);
            }
            catch (Exception e) {
                throw new FailedToStartRouteException(route, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSupervisedRoutes() {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Stopped).filter(r -> this.isSupervised(((RouteHolder)r).route)).map(RouteHolder::getId).collect(Collectors.toList());
        }
        LOG.debug("Starting {} supervised routes", (Object)routeList.size());
        for (String route : routeList) {
            try {
                this.startRoute(route);
            }
            catch (Exception exception) {}
        }
        if (this.getCamelContext().getStartupSummaryLevel() != StartupSummaryLevel.Off && this.getCamelContext().getStartupSummaryLevel() != StartupSummaryLevel.Oneline) {
            this.logRouteStartupSummary();
        }
    }

    private void logRouteStartupSummary() {
        String uri;
        String status;
        String id;
        int started = 0;
        int total = 0;
        int restarting = 0;
        int exhausted = 0;
        ArrayList<String> lines = new ArrayList<String>();
        for (RouteHolder route : this.routes) {
            id = route.getId();
            status = this.getRouteStatus(id).name();
            if (!ServiceStatus.Started.name().equals(status)) continue;
            ++total;
            ++started;
            uri = route.get().getEndpoint().getEndpointBaseUri();
            uri = URISupport.sanitizeUri(uri);
            lines.add(String.format("\t%s %s (%s)", status, id, uri));
        }
        for (RouteHolder route : this.routeManager.routes.keySet()) {
            ++total;
            ++restarting;
            id = route.getId();
            status = "Restarting";
            uri = route.get().getEndpoint().getEndpointBaseUri();
            uri = URISupport.sanitizeUri(uri);
            BackOff backOff = this.getBackOff(id);
            lines.add(String.format("\t%s %s (%s) with %s", status, id, uri, backOff));
        }
        for (RouteHolder route : this.routeManager.exhausted.keySet()) {
            ++total;
            ++exhausted;
            id = route.getId();
            status = "Exhausted";
            uri = route.get().getEndpoint().getEndpointBaseUri();
            uri = URISupport.sanitizeUri(uri);
            lines.add(String.format("\t%s %s (%s)", status, id, uri));
        }
        if (restarting == 0 && exhausted == 0) {
            LOG.info("Routes startup summary (total:{} started:{})", (Object)total, (Object)started);
        } else {
            LOG.info("Routes startup summary (total:{} started:{} restarting:{} exhausted:{})", new Object[]{total, started, restarting, exhausted});
        }
        if (this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Default || this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Verbose) {
            for (String line : lines) {
                LOG.info(line);
            }
        }
    }

    private boolean isSupervised(Route route) {
        return !this.nonSupervisedRoutes.contains(route.getId());
    }

    private class CamelContextStartupListener
    implements ExtendedStartupListener {
        private CamelContextStartupListener() {
        }

        @Override
        public void onCamelContextStarting(CamelContext context, boolean alreadyStarted) throws Exception {
        }

        @Override
        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        }

        @Override
        public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            if (alreadyStarted) {
                this.onCamelContextStarted();
            }
        }

        private void onCamelContextStarted() throws Exception {
            if (DefaultSupervisingRouteController.this.contextStarted.compareAndSet(false, true)) {
                DefaultSupervisingRouteController.this.startNonSupervisedRoutes();
                if (DefaultSupervisingRouteController.this.initialDelay > 0L) {
                    LOG.debug("Supervised routes will be started in {} millis", (Object)DefaultSupervisingRouteController.this.initialDelay);
                    DefaultSupervisingRouteController.this.executorService.schedule(() -> DefaultSupervisingRouteController.this.startSupervisedRoutes(), DefaultSupervisingRouteController.this.initialDelay, TimeUnit.MILLISECONDS);
                } else {
                    DefaultSupervisingRouteController.this.startSupervisedRoutes();
                }
            }
        }
    }

    private class ManagedRoutePolicy
    extends RoutePolicySupport
    implements NonManagedService {
        private ManagedRoutePolicy() {
        }

        private void startRoute(RouteHolder holder) {
            try {
                DefaultSupervisingRouteController.this.doStartRoute(holder, true, r -> DefaultSupervisingRouteController.super.startRoute(r.getId()));
            }
            catch (Exception e) {
                throw new RuntimeCamelException(e);
            }
        }

        @Override
        public void onInit(Route route) {
            if (!route.isAutoStartup().booleanValue()) {
                LOG.info("Route: {} will not be supervised (Reason: has explicit auto-startup flag set to false)", (Object)route.getId());
                return;
            }
            if (DefaultSupervisingRouteController.this.excludeRoutes != null) {
                for (String part : DefaultSupervisingRouteController.this.excludeRoutes.split(",")) {
                    boolean exclude;
                    String id = route.getRouteId();
                    String uri = route.getEndpoint().getEndpointUri();
                    boolean bl = exclude = PatternHelper.matchPattern(id, part) || PatternHelper.matchPattern(uri, part);
                    if (!exclude) continue;
                    LOG.debug("Route: {} excluded from being supervised", (Object)route.getId());
                    RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
                    if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                        DefaultSupervisingRouteController.this.nonSupervisedRoutes.add(route.getId());
                        holder.get().setRouteController(DefaultSupervisingRouteController.this);
                        holder.get().setAutoStartup(true);
                    }
                    return;
                }
            }
            if (DefaultSupervisingRouteController.this.includeRoutes != null) {
                boolean include = false;
                for (String part : DefaultSupervisingRouteController.this.includeRoutes.split(",")) {
                    String id = route.getRouteId();
                    String uri = route.getEndpoint().getEndpointUri();
                    boolean bl = include = PatternHelper.matchPattern(id, part) || PatternHelper.matchPattern(uri, part);
                    if (include) break;
                }
                if (!include) {
                    LOG.debug("Route: {} excluded from being supervised", (Object)route.getId());
                    RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
                    if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                        DefaultSupervisingRouteController.this.nonSupervisedRoutes.add(route.getId());
                        holder.get().setRouteController(DefaultSupervisingRouteController.this);
                        holder.get().setAutoStartup(true);
                    }
                    return;
                }
            }
            RouteHolder holder = new RouteHolder(route, DefaultSupervisingRouteController.this.routeCount.incrementAndGet());
            if (DefaultSupervisingRouteController.this.routes.add(holder)) {
                holder.get().setRouteController(DefaultSupervisingRouteController.this);
                holder.get().setAutoStartup(false);
                if (DefaultSupervisingRouteController.this.contextStarted.get()) {
                    LOG.debug("Context is already started: attempt to start route {}", (Object)route.getId());
                    if (DefaultSupervisingRouteController.this.initialDelay > 0L) {
                        LOG.debug("Route {} will be started in {} millis", (Object)holder.getId(), (Object)DefaultSupervisingRouteController.this.initialDelay);
                        DefaultSupervisingRouteController.this.executorService.schedule(() -> this.startRoute(holder), DefaultSupervisingRouteController.this.initialDelay, TimeUnit.MILLISECONDS);
                    } else {
                        this.startRoute(holder);
                    }
                } else {
                    LOG.debug("CamelContext is not yet started. Deferring staring route: {}", (Object)holder.getId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemove(Route route) {
            Object object = this.lock;
            synchronized (object) {
                DefaultSupervisingRouteController.this.routes.removeIf(r -> ObjectHelper.equal(r.get(), route) || ObjectHelper.equal(r.getId(), route.getId()));
            }
        }
    }

    private class ManagedRoutePolicyFactory
    implements RoutePolicyFactory {
        private final RoutePolicy policy;

        private ManagedRoutePolicyFactory() {
            this.policy = new ManagedRoutePolicy();
        }

        @Override
        public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
            return this.policy;
        }
    }

    private static class RouteHolder
    implements HasId,
    Comparable<RouteHolder> {
        private final int order;
        private final Route route;

        RouteHolder(Route route, int order) {
            this.route = route;
            this.order = order;
        }

        @Override
        public String getId() {
            return this.route.getId();
        }

        public Route get() {
            return this.route;
        }

        public ServiceStatus getStatus() {
            return this.route.getCamelContext().getRouteController().getRouteStatus(this.getId());
        }

        int getInitializationOrder() {
            return this.order;
        }

        public int getStartupOrder() {
            Integer order = this.route.getStartupOrder();
            if (order == null) {
                order = Integer.MAX_VALUE;
            }
            return order;
        }

        @Override
        public int compareTo(RouteHolder o) {
            int answer = Integer.compare(this.getStartupOrder(), o.getStartupOrder());
            if (answer == 0) {
                answer = Integer.compare(this.getInitializationOrder(), o.getInitializationOrder());
            }
            return answer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.route.equals(((RouteHolder)o).route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }
    }

    private class RouteManager {
        private final Logger logger = LoggerFactory.getLogger(RouteManager.class);
        private final ConcurrentMap<RouteHolder, BackOffTimer.Task> routes = new ConcurrentHashMap<RouteHolder, BackOffTimer.Task>();
        private final ConcurrentMap<RouteHolder, BackOffTimer.Task> exhausted = new ConcurrentHashMap<RouteHolder, BackOffTimer.Task>();
        private final ConcurrentMap<String, Throwable> exceptions = new ConcurrentHashMap<String, Throwable>();

        RouteManager() {
        }

        void start(RouteHolder route) {
            route.get().setRouteController(DefaultSupervisingRouteController.this);
            this.routes.computeIfAbsent(route, r -> {
                BackOff backOff = DefaultSupervisingRouteController.this.getBackOff(r.getId());
                this.logger.debug("Supervising route: {} with back-off: {}", (Object)r.getId(), (Object)backOff);
                BackOffTimer.Task task = DefaultSupervisingRouteController.this.timer.schedule(backOff, context -> {
                    BackOffTimer.Task state = this.getBackOffContext(r.getId()).orElse(null);
                    long attempt = state != null ? state.getCurrentAttempts() : 0L;
                    try {
                        this.logger.info("Restarting route: {} attempt: {}", (Object)r.getId(), (Object)attempt);
                        DefaultSupervisingRouteController.this.doStartRoute(r, false, rx -> DefaultSupervisingRouteController.super.startRoute(rx.getId()));
                        this.logger.info("Route: {} started after {} attempts", (Object)r.getId(), (Object)attempt);
                        return false;
                    }
                    catch (Exception e) {
                        this.exceptions.put(r.getId(), e);
                        String cause = e.getClass().getName() + ": " + e.getMessage();
                        this.logger.info("Failed restarting route: {} attempt: {} due: {} (stacktrace in debug log level)", new Object[]{r.getId(), attempt, cause});
                        this.logger.debug("    Error restarting route caused by: " + e.getMessage(), (Throwable)e);
                        return true;
                    }
                });
                task.whenComplete((backOffTask, throwable) -> {
                    if (backOffTask == null || backOffTask.getStatus() != BackOffTimer.Task.Status.Active) {
                        Object object = DefaultSupervisingRouteController.this.lock;
                        synchronized (object) {
                            boolean stopped;
                            ServiceStatus status = route.getStatus();
                            boolean bl = stopped = status.isStopped() || status.isStopping();
                            if (backOffTask != null && backOffTask.getStatus() == BackOffTimer.Task.Status.Exhausted && stopped) {
                                Throwable t;
                                LOG.warn("Restarting route: {} is exhausted after {} attempts. No more attempts will be made and the route is no longer supervised by this route controller and remains as stopped.", (Object)route.getId(), (Object)(backOffTask.getCurrentAttempts() - 1L));
                                r.get().setRouteController(null);
                                ((DefaultSupervisingRouteController)DefaultSupervisingRouteController.this).routeManager.exhausted.put((RouteHolder)r, task);
                                if (DefaultSupervisingRouteController.this.unhealthyOnExhausted && (t = DefaultSupervisingRouteController.this.getRestartException(route.getId())) != null) {
                                    DefaultRouteError.set(DefaultSupervisingRouteController.this.getCamelContext(), r.getId(), RouteError.Phase.START, t, true);
                                }
                            }
                        }
                    }
                    this.routes.remove(r);
                });
                return task;
            });
        }

        boolean release(RouteHolder route) {
            this.exceptions.remove(route.getId());
            BackOffTimer.Task task = (BackOffTimer.Task)this.routes.remove(route);
            if (task != null) {
                LOG.debug("Cancelling restart task for route: {}", (Object)route.getId());
                task.cancel();
            }
            return task != null;
        }

        public Optional<BackOffTimer.Task> getBackOffContext(String id) {
            Optional<BackOffTimer.Task> answer = this.routes.entrySet().stream().filter(e -> ObjectHelper.equal(((RouteHolder)e.getKey()).getId(), id)).findFirst().map(Map.Entry::getValue);
            if (!answer.isPresent()) {
                answer = this.exhausted.entrySet().stream().filter(e -> ObjectHelper.equal(((RouteHolder)e.getKey()).getId(), id)).findFirst().map(Map.Entry::getValue);
            }
            return answer;
        }
    }
}

