/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Route;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Tracer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracer
extends ServiceSupport
implements CamelContextAware,
Tracer {
    private static final String TRACING_OUTPUT = "%-4.4s [%-12.12s] [%-33.33s]";
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.camel.Tracing");
    private CamelContext camelContext;
    private boolean enabled = true;
    private long traceCounter;
    private ExchangeFormatter exchangeFormatter;
    private String tracePattern;
    private transient String[] patterns;
    private boolean traceBeforeAndAfterRoute = true;

    public DefaultTracer() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        formatter.setShowExchangeId(true);
        formatter.setShowExchangePattern(false);
        formatter.setMultiline(false);
        formatter.setShowHeaders(false);
        formatter.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
        this.setExchangeFormatter(formatter);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void traceBeforeNode(NamedNode node, Exchange exchange) {
        if (this.shouldTrace(node)) {
            ++this.traceCounter;
            String routeId = ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
            String label = URISupport.sanitizeUri(StringHelper.limitLength(node.getLabel(), 50));
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(TRACING_OUTPUT, "   ", routeId, label));
            sb.append(" ");
            String data = this.exchangeFormatter.format(exchange);
            sb.append(data);
            String out = sb.toString();
            this.dumpTrace(out);
        }
    }

    @Override
    public void traceAfterNode(NamedNode node, Exchange exchange) {
    }

    @Override
    public void traceBeforeRoute(NamedRoute route, Exchange exchange) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getEndpointUrl();
        String label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(uri, 50) + "]");
        boolean original = route.getRouteId().equals(exchange.getFromRouteId());
        String arrow = original ? "*-->" : "--->";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(TRACING_OUTPUT, arrow, route.getRouteId(), label));
        sb.append(" ");
        String data = this.exchangeFormatter.format(exchange);
        sb.append(data);
        String out = sb.toString();
        this.dumpTrace(out);
    }

    @Override
    public void traceAfterRoute(Route route, Exchange exchange) {
        if (!this.traceBeforeAndAfterRoute) {
            return;
        }
        String uri = route.getConsumer().getEndpoint().getEndpointUri();
        String label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(uri, 50) + "]");
        boolean original = route.getId().equals(exchange.getFromRouteId());
        String arrow = original ? "*<--" : "<---";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(TRACING_OUTPUT, arrow, route.getId(), label));
        sb.append(" ");
        String data = this.exchangeFormatter.format(exchange);
        sb.append(data);
        String out = sb.toString();
        this.dumpTrace(out);
    }

    @Override
    public boolean shouldTrace(NamedNode definition) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Should trace evaluated {} -> pattern: {}", (Object)definition.getId(), (Object)pattern);
        }
        return pattern;
    }

    @Override
    public long getTraceCounter() {
        return this.traceCounter;
    }

    @Override
    public void resetTraceCounter() {
        this.traceCounter = 0L;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getTracePattern() {
        return this.tracePattern;
    }

    @Override
    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    @Override
    public boolean isTraceBeforeAndAfterRoute() {
        return this.traceBeforeAndAfterRoute;
    }

    @Override
    public void setTraceBeforeAndAfterRoute(boolean traceBeforeAndAfterRoute) {
        this.traceBeforeAndAfterRoute = traceBeforeAndAfterRoute;
    }

    @Override
    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    @Override
    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    protected void dumpTrace(String out) {
        LOG.info(out);
    }

    protected boolean shouldTracePattern(NamedNode definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (PatternHelper.matchPattern(id, pattern)) {
                return true;
            }
            String routeId = CamelContextHelper.getRouteId(definition);
            if (routeId == null || Objects.equals(routeId, id) || !PatternHelper.matchPattern(routeId, pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

