/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.PooledExchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationVetoable;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.annotations.EagerClassloaded;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.support.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EagerClassloaded
public class DefaultUnitOfWork
implements UnitOfWork {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUnitOfWork.class);
    final InflightRepository inflightRepository;
    final boolean allowUseOriginalMessage;
    final boolean useBreadcrumb;
    private final ExtendedCamelContext context;
    private final Deque<Route> routes = new ArrayDeque<Route>(8);
    private Logger log = LOG;
    private Exchange exchange;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private Set<Object> transactedBy;

    public DefaultUnitOfWork(Exchange exchange) {
        this(exchange, exchange.getContext().getInflightRepository(), exchange.getContext().isAllowUseOriginalMessage(), exchange.getContext().isUseBreadcrumb());
    }

    protected DefaultUnitOfWork(Exchange exchange, Logger logger, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this(exchange, inflightRepository, allowUseOriginalMessage, useBreadcrumb);
        this.log = logger;
    }

    public DefaultUnitOfWork(Exchange exchange, InflightRepository inflightRepository, boolean allowUseOriginalMessage, boolean useBreadcrumb) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
        this.useBreadcrumb = useBreadcrumb;
        this.context = (ExtendedCamelContext)exchange.getContext();
        this.inflightRepository = inflightRepository;
        this.doOnPrepare(exchange);
    }

    public static void onClassloaded(Logger log) {
        log.trace("Loaded DefaultUnitOfWork");
    }

    UnitOfWork newInstance(Exchange exchange) {
        return new DefaultUnitOfWork(exchange, this.inflightRepository, this.allowUseOriginalMessage, this.useBreadcrumb);
    }

    @Override
    public boolean onPrepare(Exchange exchange) {
        if (this.exchange == null) {
            this.doOnPrepare(exchange);
            return true;
        }
        return false;
    }

    private void doOnPrepare(Exchange exchange) {
        String breadcrumbId;
        this.exchange = exchange;
        if (this.allowUseOriginalMessage) {
            if (exchange.getIn().getClass().getName().equals("org.apache.camel.component.jms.JmsMessage")) {
                this.originalInMessage = new DefaultMessage(this.context);
                this.originalInMessage.setBody(exchange.getIn().getBody());
                this.originalInMessage.getHeaders().putAll(exchange.getIn().getHeaders());
            } else {
                this.originalInMessage = exchange.getIn().copy();
            }
            if (this.originalInMessage instanceof MessageSupport) {
                ((MessageSupport)this.originalInMessage).setExchange(exchange);
            }
        }
        if (this.useBreadcrumb && (breadcrumbId = exchange.getIn().getHeader("breadcrumbId", String.class)) == null) {
            breadcrumbId = exchange.getExchangeId();
            exchange.getIn().setHeader("breadcrumbId", breadcrumbId);
        }
        if (this.context.isEventNotificationApplicable()) {
            try {
                EventHelper.notifyExchangeCreated(this.context, exchange);
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
            }
        }
        this.inflightRepository.add(exchange);
    }

    @Override
    public void reset() {
        this.exchange = null;
        this.routes.clear();
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        this.originalInMessage = null;
        if (this.transactedBy != null) {
            this.transactedBy.clear();
        }
    }

    @Override
    public void setParentUnitOfWork(UnitOfWork parentUnitOfWork) {
    }

    @Override
    public UnitOfWork createChildUnitOfWork(Exchange childExchange) {
        UnitOfWork answer = this.newInstance(childExchange);
        answer.setParentUnitOfWork(this);
        return answer;
    }

    @Override
    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>(8);
        }
        this.log.trace("Adding synchronization {}", (Object)synchronization);
        this.synchronizations.add(synchronization);
    }

    @Override
    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    @Override
    public synchronized boolean containsSynchronization(Synchronization synchronization) {
        return this.synchronizations != null && this.synchronizations.contains(synchronization);
    }

    @Override
    public void handoverSynchronization(Exchange target) {
        this.handoverSynchronization(target, null);
    }

    @Override
    public void handoverSynchronization(Exchange target, Predicate<Synchronization> filter) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        Iterator<Synchronization> it = this.synchronizations.iterator();
        while (it.hasNext()) {
            Synchronization synchronization = it.next();
            boolean handover = true;
            if (synchronization instanceof SynchronizationVetoable) {
                SynchronizationVetoable veto = (SynchronizationVetoable)synchronization;
                handover = veto.allowHandover();
            }
            if (handover && (filter == null || filter.test(synchronization))) {
                this.log.trace("Handover synchronization {} to: {}", (Object)synchronization, (Object)target);
                target.adapt(ExtendedExchange.class).addOnCompletion(synchronization);
                it.remove();
                continue;
            }
            this.log.trace("Handover not allow for synchronization {}", (Object)synchronization);
        }
    }

    @Override
    public void done(Exchange exchange) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork done for ExchangeId: {} with {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        boolean failed = exchange.isFailed();
        UnitOfWorkHelper.doneSynchronizations(exchange, this.synchronizations, this.log);
        this.inflightRepository.remove(exchange);
        if (this.context.isEventNotificationApplicable()) {
            try {
                if (failed) {
                    EventHelper.notifyExchangeFailed(exchange.getContext(), exchange);
                } else {
                    EventHelper.notifyExchangeDone(exchange.getContext(), exchange);
                }
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during event notification. This exception will be ignored.", e);
            }
        }
        if (exchange instanceof PooledExchange) {
            try {
                ((PooledExchange)exchange).done(false);
            }
            catch (Throwable e) {
                this.log.warn("Exception occurred during exchange done. This exception will be ignored.", e);
            }
        }
    }

    @Override
    public void beforeRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork beforeRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.beforeRouteSynchronizations(route, exchange, this.synchronizations, this.log);
        }
    }

    @Override
    public void afterRoute(Exchange exchange, Route route) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("UnitOfWork afterRoute: {} for ExchangeId: {} with {}", new Object[]{route.getId(), exchange.getExchangeId(), exchange});
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            UnitOfWorkHelper.afterRouteSynchronizations(route, exchange, this.synchronizations, this.log);
        }
    }

    @Override
    public Message getOriginalInMessage() {
        if (this.originalInMessage == null && !this.context.isAllowUseOriginalMessage().booleanValue()) {
            throw new IllegalStateException("AllowUseOriginalMessage is disabled. Cannot access the original message.");
        }
        return this.originalInMessage;
    }

    @Override
    public boolean isTransacted() {
        return this.transactedBy != null && !this.transactedBy.isEmpty();
    }

    @Override
    public boolean isTransactedBy(Object key) {
        return this.transactedBy != null && this.getTransactedBy().contains(key);
    }

    @Override
    public void beginTransactedBy(Object key) {
        this.exchange.adapt(ExtendedExchange.class).setTransacted(true);
        this.getTransactedBy().add(key);
    }

    @Override
    public void endTransactedBy(Object key) {
        this.getTransactedBy().remove(key);
        boolean transacted = this.isTransacted();
        this.exchange.adapt(ExtendedExchange.class).setTransacted(transacted);
    }

    @Override
    public Route getRoute() {
        return this.routes.peek();
    }

    @Override
    public void pushRoute(Route route) {
        this.routes.push(route);
    }

    @Override
    public Route popRoute() {
        return this.routes.poll();
    }

    @Override
    public boolean isBeforeAfterProcess() {
        return false;
    }

    @Override
    public AsyncCallback beforeProcess(Processor processor, Exchange exchange, AsyncCallback callback) {
        return callback;
    }

    @Override
    public void afterProcess(Processor processor, Exchange exchange, AsyncCallback callback, boolean doneSync) {
    }

    private Set<Object> getTransactedBy() {
        if (this.transactedBy == null) {
            this.transactedBy = new HashSet<Object>(4);
        }
        return this.transactedBy;
    }

    public String toString() {
        return "DefaultUnitOfWork";
    }
}

