/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,transformation")
@XmlRootElement(name="enrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EnrichDefinition
extends ExpressionNode {
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    private String aggregationStrategyMethodName;
    @XmlAttribute(name="strategyMethodAllowNull")
    private String aggregationStrategyMethodAllowNull;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String aggregateOnException;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String shareUnitOfWork;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String cacheSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String ignoreInvalidEndpoint;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String allowOptimisedComponents;

    public EnrichDefinition() {
        this((AggregationStrategy)null);
    }

    public EnrichDefinition(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        return "Enrich[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "enrich";
    }

    @Override
    public String getLabel() {
        return "enrich[" + this.getExpression() + "]";
    }

    public EnrichDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public EnrichDefinition aggregationStrategy(Supplier<AggregationStrategy> aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy.get());
        return this;
    }

    public EnrichDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public EnrichDefinition aggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.setAggregationStrategyMethodName(aggregationStrategyMethodName);
        return this;
    }

    public EnrichDefinition aggregationStrategyMethodAllowNull(boolean aggregationStrategyMethodAllowNull) {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(aggregationStrategyMethodAllowNull));
        return this;
    }

    public EnrichDefinition aggregateOnException(boolean aggregateOnException) {
        this.setAggregateOnException(Boolean.toString(aggregateOnException));
        return this;
    }

    public EnrichDefinition shareUnitOfWork() {
        this.setShareUnitOfWork(Boolean.toString(true));
        return this;
    }

    public EnrichDefinition cacheSize(int cacheSize) {
        this.setCacheSize(Integer.toString(cacheSize));
        return this;
    }

    public EnrichDefinition cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public EnrichDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(Boolean.toString(true));
        return this;
    }

    public EnrichDefinition allowOptimisedComponents(boolean allowOptimisedComponents) {
        return this.allowOptimisedComponents(Boolean.toString(allowOptimisedComponents));
    }

    public EnrichDefinition allowOptimisedComponents(String allowOptimisedComponents) {
        this.setAllowOptimisedComponents(allowOptimisedComponents);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(String aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public String getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(String shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(String ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public String getAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(String allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }
}

