/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.StreamResequencer;
import org.apache.camel.processor.resequencer.DefaultExchangeComparator;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.util.ObjectHelper;

public class ResequenceReifier
extends ProcessorReifier<ResequenceDefinition> {
    public ResequenceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ResequenceDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        ResequencerConfig resequencer = ((ResequenceDefinition)this.definition).getResequencerConfig();
        StreamResequencerConfig stream = ((ResequenceDefinition)this.definition).getStreamConfig();
        BatchResequencerConfig batch = ((ResequenceDefinition)this.definition).getBatchConfig();
        if (resequencer instanceof StreamResequencerConfig) {
            stream = (StreamResequencerConfig)resequencer;
        } else if (resequencer instanceof BatchResequencerConfig) {
            batch = (BatchResequencerConfig)resequencer;
        }
        if (stream != null) {
            return this.createStreamResequencer(stream);
        }
        if (batch == null) {
            batch = BatchResequencerConfig.getDefault();
        }
        return this.createBatchResequencer(batch);
    }

    protected Resequencer createBatchResequencer(BatchResequencerConfig config) throws Exception {
        Long dur;
        Processor processor = this.createChildProcessor(true);
        Expression expression = this.createExpression(((ResequenceDefinition)this.definition).getExpression());
        InternalProcessor target = this.camelContext.adapt(ExtendedCamelContext.class).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, processor, this.route);
        ObjectHelper.notNull(config, "config", this);
        ObjectHelper.notNull(expression, "expression", this);
        boolean isReverse = this.parseBoolean(config.getReverse(), false);
        boolean isAllowDuplicates = this.parseBoolean(config.getAllowDuplicates(), false);
        Resequencer resequencer = new Resequencer(this.camelContext, target, expression, isAllowDuplicates, isReverse);
        Integer num = this.parseInt(config.getBatchSize());
        if (num != null) {
            resequencer.setBatchSize(num);
        }
        if ((dur = this.parseDuration(config.getBatchTimeout())) != null) {
            resequencer.setBatchTimeout(dur);
        }
        resequencer.setReverse(isReverse);
        resequencer.setAllowDuplicates(isAllowDuplicates);
        if (config.getIgnoreInvalidExchanges() != null) {
            resequencer.setIgnoreInvalidExchanges(this.parseBoolean(config.getIgnoreInvalidExchanges(), false));
        }
        return resequencer;
    }

    protected StreamResequencer createStreamResequencer(StreamResequencerConfig config) throws Exception {
        Integer num;
        ExpressionResultComparator comparator;
        Processor processor = this.createChildProcessor(true);
        Expression expression = this.createExpression(((ResequenceDefinition)this.definition).getExpression());
        InternalProcessor target = this.camelContext.adapt(ExtendedCamelContext.class).getInternalProcessorFactory().addUnitOfWorkProcessorAdvice(this.camelContext, processor, this.route);
        ObjectHelper.notNull(config, "config", this);
        ObjectHelper.notNull(expression, "expression", this);
        if (config.getComparatorRef() != null) {
            comparator = this.mandatoryLookup(config.getComparatorRef(), ExpressionResultComparator.class);
        } else {
            comparator = config.getComparator();
            if (comparator == null) {
                comparator = new DefaultExchangeComparator();
            }
        }
        comparator.setExpression(expression);
        StreamResequencer resequencer = new StreamResequencer(this.camelContext, target, comparator, expression);
        Long dur = this.parseDuration(config.getTimeout());
        if (dur != null) {
            resequencer.setTimeout(dur);
        }
        if ((dur = this.parseDuration(config.getDeliveryAttemptInterval())) != null) {
            resequencer.setDeliveryAttemptInterval(dur);
        }
        if ((num = this.parseInt(config.getCapacity())) != null) {
            resequencer.setCapacity(num);
        }
        resequencer.setRejectOld(this.parseBoolean(config.getRejectOld(), false));
        if (config.getIgnoreInvalidExchanges() != null) {
            resequencer.setIgnoreInvalidExchanges(this.parseBoolean(config.getIgnoreInvalidExchanges(), false));
        }
        return resequencer;
    }
}

