/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.errorhandler.DeadLetterChannelProperties;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.errorhandler.DeadLetterChannel;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.ObjectHelper;

public class DeadLetterChannelReifier
extends DefaultErrorHandlerReifier<DeadLetterChannelProperties> {
    public DeadLetterChannelReifier(Route route, ErrorHandlerFactory definition) {
        super(route, definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        ObjectHelper.notNull(((DeadLetterChannelProperties)this.definition).getDeadLetterUri(), "deadLetterUri", this);
        RedeliveryPolicy redeliveryPolicy = ((DeadLetterChannelProperties)this.definition).hasRedeliveryPolicy() ? ((DeadLetterChannelProperties)this.definition).getRedeliveryPolicy() : ((DeadLetterChannelProperties)this.definition).getDefaultRedeliveryPolicy();
        CamelLogger logger = ((DeadLetterChannelProperties)this.definition).hasLogger() ? ((DeadLetterChannelProperties)this.definition).getLogger() : null;
        Processor deadLetterProcessor = this.createDeadLetterChannelProcessor(((DeadLetterChannelProperties)this.definition).getDeadLetterUri());
        DeadLetterChannel answer = new DeadLetterChannel(this.camelContext, processor, logger, this.getBean(Processor.class, ((DeadLetterChannelProperties)this.definition).getOnRedelivery(), ((DeadLetterChannelProperties)this.definition).getOnRedeliveryRef()), redeliveryPolicy, deadLetterProcessor, ((DeadLetterChannelProperties)this.definition).getDeadLetterUri(), ((DeadLetterChannelProperties)this.definition).isDeadLetterHandleNewException(), ((DeadLetterChannelProperties)this.definition).isUseOriginalMessage(), ((DeadLetterChannelProperties)this.definition).isUseOriginalBody(), ((DeadLetterChannelProperties)this.definition).getRetryWhilePolicy(this.camelContext), this.getExecutorService(((DeadLetterChannelProperties)this.definition).getExecutorService(), ((DeadLetterChannelProperties)this.definition).getExecutorServiceRef()), this.getBean(Processor.class, ((DeadLetterChannelProperties)this.definition).getOnPrepareFailure(), ((DeadLetterChannelProperties)this.definition).getOnPrepareFailureRef()), this.getBean(Processor.class, ((DeadLetterChannelProperties)this.definition).getOnExceptionOccurred(), ((DeadLetterChannelProperties)this.definition).getOnExceptionOccurredRef()));
        this.configure(answer);
        return answer;
    }

    private Processor createDeadLetterChannelProcessor(String uri) {
        SendProcessor child = new SendProcessor(this.camelContext.getEndpoint(uri), ExchangePattern.InOnly);
        return new FatalFallbackErrorHandler(child, true);
    }
}

