/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.DatasonnetExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.language.CSimpleExpressionReifier;
import org.apache.camel.reifier.language.DatasonnetExpressionReifier;
import org.apache.camel.reifier.language.JoorExpressionReifier;
import org.apache.camel.reifier.language.JsonPathExpressionReifier;
import org.apache.camel.reifier.language.MethodCallExpressionReifier;
import org.apache.camel.reifier.language.SimpleExpressionReifier;
import org.apache.camel.reifier.language.TokenizerExpressionReifier;
import org.apache.camel.reifier.language.XMLTokenizerExpressionReifier;
import org.apache.camel.reifier.language.XPathExpressionReifier;
import org.apache.camel.reifier.language.XQueryExpressionReifier;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.util.ObjectHelper;

public class ExpressionReifier<T extends ExpressionDefinition>
extends AbstractReifier {
    private static final Pattern SINGLE_TO_DOUBLE = Pattern.compile("'(\\{\\{.*?}})'");
    private static final Map<Class<?>, BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>>> EXPRESSIONS = new HashMap(0);
    protected final T definition;

    public ExpressionReifier(CamelContext camelContext, T definition) {
        super(camelContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>> creator) {
        if (EXPRESSIONS.isEmpty()) {
            ReifierStrategy.addReifierClearer(ExpressionReifier::clearReifiers);
        }
        EXPRESSIONS.put(processorClass, creator);
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionSubElementDefinition definition) {
        return ExpressionReifier.reifier(camelContext, definition.getExpressionType());
    }

    public static ExpressionReifier<? extends ExpressionDefinition> reifier(CamelContext camelContext, ExpressionDefinition definition) {
        BiFunction<CamelContext, ExpressionDefinition, ExpressionReifier<? extends ExpressionDefinition>> reifier;
        ExpressionReifier<ExpressionDefinition> answer = null;
        if (!EXPRESSIONS.isEmpty() && (reifier = EXPRESSIONS.get(definition.getClass())) != null) {
            answer = reifier.apply(camelContext, definition);
        }
        if (answer == null) {
            answer = ExpressionReifier.coreReifier(camelContext, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + definition);
        }
        return answer;
    }

    private static ExpressionReifier<? extends ExpressionDefinition> coreReifier(CamelContext camelContext, ExpressionDefinition definition) {
        if (definition instanceof ConstantExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof CSimpleExpression) {
            return new CSimpleExpressionReifier(camelContext, definition);
        }
        if (definition instanceof DatasonnetExpression) {
            return new DatasonnetExpressionReifier(camelContext, definition);
        }
        if (definition instanceof ExchangePropertyExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof GroovyExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof HeaderExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof Hl7TerserExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof JoorExpression) {
            return new JoorExpressionReifier(camelContext, definition);
        }
        if (definition instanceof JsonPathExpression) {
            return new JsonPathExpressionReifier(camelContext, definition);
        }
        if (definition instanceof LanguageExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof MethodCallExpression) {
            return new MethodCallExpressionReifier(camelContext, definition);
        }
        if (definition instanceof MvelExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof OgnlExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof RefExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof SimpleExpression) {
            return new SimpleExpressionReifier(camelContext, definition);
        }
        if (definition instanceof SpELExpression) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        if (definition instanceof TokenizerExpression) {
            return new TokenizerExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XMLTokenizerExpression) {
            return new XMLTokenizerExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XPathExpression) {
            return new XPathExpressionReifier(camelContext, definition);
        }
        if (definition instanceof XQueryExpression) {
            return new XQueryExpressionReifier(camelContext, definition);
        }
        if (definition instanceof ExpressionDefinition) {
            return new ExpressionReifier<ExpressionDefinition>(camelContext, definition);
        }
        return null;
    }

    public static void clearReifiers() {
        EXPRESSIONS.clear();
    }

    public boolean isResolveOptionalExternalScriptEnabled() {
        return true;
    }

    public Expression createExpression() {
        Expression expression = ((ExpressionDefinition)this.definition).getExpressionValue();
        if (expression == null) {
            this.prepareExpression();
            if (((ExpressionDefinition)this.definition).getExpressionType() != null) {
                expression = ExpressionReifier.reifier(this.camelContext, ((ExpressionDefinition)this.definition).getExpressionType()).createExpression();
            } else {
                ObjectHelper.notNull(((ExpressionDefinition)this.definition).getLanguage(), "language");
                Language language = this.camelContext.resolveLanguage(((ExpressionDefinition)this.definition).getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(((ExpressionDefinition)this.definition).getLanguage());
                }
                String exp = this.parseString(((ExpressionDefinition)this.definition).getExpression());
                boolean isTrim = this.parseBoolean(((ExpressionDefinition)this.definition).getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                if (this.isResolveOptionalExternalScriptEnabled()) {
                    exp = ScriptHelper.resolveOptionalExternalScript(this.camelContext, exp);
                }
                this.configureLanguage(language);
                expression = this.createExpression(language, exp);
                this.configureExpression(expression);
            }
        }
        CamelContextAware.trySetCamelContext(expression, this.camelContext);
        expression.init(this.camelContext);
        return expression;
    }

    public Predicate createPredicate() {
        Predicate predicate = ((ExpressionDefinition)this.definition).getPredicate();
        if (predicate == null) {
            this.prepareExpression();
            if (((ExpressionDefinition)this.definition).getExpressionType() != null) {
                predicate = ExpressionReifier.reifier(this.camelContext, ((ExpressionDefinition)this.definition).getExpressionType()).createPredicate();
            } else if (((ExpressionDefinition)this.definition).getExpressionValue() != null) {
                predicate = new ExpressionToPredicateAdapter(((ExpressionDefinition)this.definition).getExpressionValue());
            } else if (((ExpressionDefinition)this.definition).getExpression() != null) {
                ObjectHelper.notNull(((ExpressionDefinition)this.definition).getLanguage(), "language");
                Language language = this.camelContext.resolveLanguage(((ExpressionDefinition)this.definition).getLanguage());
                if (language == null) {
                    throw new NoSuchLanguageException(((ExpressionDefinition)this.definition).getLanguage());
                }
                String exp = this.parseString(((ExpressionDefinition)this.definition).getExpression());
                boolean isTrim = this.parseBoolean(((ExpressionDefinition)this.definition).getTrim(), true);
                if (exp != null && isTrim) {
                    exp = exp.trim();
                }
                exp = ScriptHelper.resolveOptionalExternalScript(this.camelContext, exp);
                this.configureLanguage(language);
                predicate = this.createPredicate(language, exp);
                this.configurePredicate(predicate);
            }
        }
        CamelContextAware.trySetCamelContext(predicate, this.camelContext);
        predicate.initPredicate(this.camelContext);
        return predicate;
    }

    protected Expression createExpression(Language language, String exp) {
        return language.createExpression(exp);
    }

    protected Predicate createPredicate(Language language, String exp) {
        return language.createPredicate(exp);
    }

    protected void configureLanguage(Language language) {
    }

    protected void configurePredicate(Predicate predicate) {
        if (predicate instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)((Object)predicate)).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void configureExpression(Expression expression) {
        if (expression instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)((Object)expression)).afterPropertiesConfigured(this.camelContext);
        }
    }

    protected void prepareExpression() {
        String text = ((ExpressionDefinition)this.definition).getExpression();
        if (text != null && text.contains("{{")) {
            boolean changed = false;
            Matcher matcher = SINGLE_TO_DOUBLE.matcher(text);
            while (matcher.find()) {
                String group = matcher.group(1);
                String resolved = this.camelContext.resolvePropertyPlaceholders(group);
                if (resolved == null || resolved.indexOf(39) == -1) continue;
                text = matcher.replaceFirst("\"$1\"");
                matcher.reset(text);
                changed = true;
            }
            if (changed) {
                ((ExpressionDefinition)this.definition).setExpression(text);
            }
        }
    }

    @Deprecated
    protected void setProperties(Object target, Map<String, Object> properties) {
        properties.entrySet().removeIf(e -> e.getValue() == null);
        PropertyConfigurer configurer = null;
        if (target instanceof PropertyConfigurerAware) {
            configurer = ((PropertyConfigurerAware)target).getPropertyConfigurer(target);
        } else if (target instanceof PropertyConfigurer) {
            configurer = (PropertyConfigurer)target;
        }
        PropertyBindingSupport.build().withConfigurer(configurer).withIgnoreCase(true).bind(this.camelContext, target, properties);
    }
}

