/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.0.0", label="dataformat,transformation,csv", title="Bindy")
@XmlRootElement(name="bindy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BindyDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> clazz;
    @XmlAttribute(required=true)
    @Metadata(required=true, javaType="org.apache.camel.model.dataformat.BindyType", enums="Csv,Fixed,KeyValue")
    private String type;
    @XmlAttribute
    private String classType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String allowEmptyStream;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String unwrapSingleInstance;
    @XmlAttribute
    @Metadata(label="advanced")
    private String locale;

    public BindyDataFormat() {
        super("bindy");
    }

    private BindyDataFormat(Builder builder) {
        this();
        this.clazz = builder.clazz;
        this.type = builder.type;
        this.classType = builder.classType;
        this.allowEmptyStream = builder.allowEmptyStream;
        this.unwrapSingleInstance = builder.unwrapSingleInstance;
        this.locale = builder.locale;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassTypeAsString() {
        return this.classType;
    }

    @Override
    public String getDataFormatName() {
        if ("Csv".equals(this.type)) {
            return "bindyCsv";
        }
        if ("Fixed".equals(this.type)) {
            return "bindyFixed";
        }
        return "bindyKvp";
    }

    public void setClassTypeAsString(String classType) {
        this.classType = classType;
    }

    public void setClassType(String classType) {
        this.setClassTypeAsString(classType);
    }

    public void setClassType(Class<?> classType) {
        this.clazz = classType;
    }

    public Class<?> getClassType() {
        return this.clazz;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getUnwrapSingleInstance() {
        return this.unwrapSingleInstance;
    }

    public void setUnwrapSingleInstance(String unwrapSingleInstance) {
        this.unwrapSingleInstance = unwrapSingleInstance;
    }

    public String getAllowEmptyStream() {
        return this.allowEmptyStream;
    }

    public void setAllowEmptyStream(String allowEmptyStream) {
        this.allowEmptyStream = allowEmptyStream;
    }

    public BindyDataFormat csv() {
        return this.type(BindyType.Csv);
    }

    public BindyDataFormat fixed() {
        return this.type(BindyType.Fixed);
    }

    public BindyDataFormat keyValue() {
        return this.type(BindyType.KeyValue);
    }

    public BindyDataFormat type(BindyType type) {
        return this.type(type.name());
    }

    public BindyDataFormat type(String type) {
        this.type = type;
        return this;
    }

    public BindyDataFormat classType(Class<?> classType) {
        this.clazz = classType;
        return this;
    }

    public BindyDataFormat classType(String classType) {
        this.classType = classType;
        return this;
    }

    public BindyDataFormat locale(Locale locale) {
        return this.locale((String)(locale.getCountry().isEmpty() ? locale.getLanguage() : locale.getLanguage() + "-" + locale.getCountry()));
    }

    public BindyDataFormat locale(String locale) {
        this.locale = locale;
        return this;
    }

    public BindyDataFormat unwrapSingleInstance(boolean unwrapSingleInstance) {
        return this.unwrapSingleInstance(Boolean.toString(unwrapSingleInstance));
    }

    public BindyDataFormat unwrapSingleInstance(String unwrapSingleInstance) {
        this.unwrapSingleInstance = unwrapSingleInstance;
        return this;
    }

    public BindyDataFormat allowEmptyStream(boolean allowEmptyStream) {
        return this.allowEmptyStream(Boolean.toString(allowEmptyStream));
    }

    public BindyDataFormat allowEmptyStream(String allowEmptyStream) {
        this.allowEmptyStream = allowEmptyStream;
        return this;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<BindyDataFormat> {
        private Class<?> clazz;
        private String type;
        private String classType;
        private String allowEmptyStream;
        private String unwrapSingleInstance;
        private String locale;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder type(BindyType type) {
            return this.type(type.name());
        }

        public Builder classType(String classType) {
            this.classType = classType;
            return this;
        }

        public Builder classType(Class<?> classType) {
            this.clazz = classType;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder unwrapSingleInstance(String unwrapSingleInstance) {
            this.unwrapSingleInstance = unwrapSingleInstance;
            return this;
        }

        public Builder unwrapSingleInstance(boolean unwrapSingleInstance) {
            this.unwrapSingleInstance = Boolean.toString(unwrapSingleInstance);
            return this;
        }

        public Builder allowEmptyStream(String allowEmptyStream) {
            this.allowEmptyStream = allowEmptyStream;
            return this;
        }

        public Builder allowEmptyStream(boolean allowEmptyStream) {
            this.allowEmptyStream = Boolean.toString(allowEmptyStream);
            return this;
        }

        @Override
        public BindyDataFormat end() {
            return new BindyDataFormat(this);
        }
    }
}

