/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.FhirDataformat;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class FhirDataFormatReifier<T extends FhirDataformat>
extends DataFormatReifier<T> {
    public FhirDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (FhirDataformat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        Set set;
        properties.put("fhirVersion", ((FhirDataformat)this.definition).getFhirVersion());
        properties.put("fhirContext", this.asRef(((FhirDataformat)this.definition).getFhirContext()));
        properties.put("serverBaseUrl", ((FhirDataformat)this.definition).getServerBaseUrl());
        properties.put("forceResourceId", this.asRef(((FhirDataformat)this.definition).getForceResourceId()));
        properties.put("preferTypesNames", ((FhirDataformat)this.definition).getPreferTypes());
        properties.put("parserOptions", this.asRef(((FhirDataformat)this.definition).getParserOptions()));
        properties.put("parserErrorHandler", this.asRef(((FhirDataformat)this.definition).getParserErrorHandler()));
        properties.put("encodeElementsAppliesToChildResourcesOnly", ((FhirDataformat)this.definition).getEncodeElementsAppliesToChildResourcesOnly());
        properties.put("omitResourceId", ((FhirDataformat)this.definition).getOmitResourceId());
        properties.put("prettyPrint", ((FhirDataformat)this.definition).getPrettyPrint());
        properties.put("suppressNarratives", ((FhirDataformat)this.definition).getSuppressNarratives());
        properties.put("summaryMode", ((FhirDataformat)this.definition).getSummaryMode());
        properties.put("overrideResourceIdWithBundleEntryFullUrl", ((FhirDataformat)this.definition).getOverrideResourceIdWithBundleEntryFullUrl());
        properties.put("stripVersionsFromReferences", ((FhirDataformat)this.definition).getStripVersionsFromReferences());
        if (((FhirDataformat)this.definition).getDontStripVersionsFromReferencesAtPaths() != null) {
            List list = Arrays.stream(((FhirDataformat)this.definition).getDontStripVersionsFromReferencesAtPaths().split(",")).collect(Collectors.toList());
            properties.put("dontStripVersionsFromReferencesAtPaths", list);
        }
        if (((FhirDataformat)this.definition).getDontEncodeElements() != null) {
            set = Arrays.stream(((FhirDataformat)this.definition).getDontEncodeElements().split(",")).collect(Collectors.toSet());
            properties.put("dontEncodeElements", set);
        }
        if (((FhirDataformat)this.definition).getEncodeElements() != null) {
            set = Arrays.stream(((FhirDataformat)this.definition).getEncodeElements().split(",")).collect(Collectors.toSet());
            properties.put("encodeElements", set);
        }
    }
}

