/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.DataFormatBuilderFactory;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.LanguageBuilderFactory;
import org.apache.camel.builder.RouteBuilderLifecycleStrategy;
import org.apache.camel.builder.TransformerBuilder;
import org.apache.camel.builder.ValidatorBuilder;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRoutesDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.OnCamelContextEvent;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder,
Ordered,
ResourceAware {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private Resource resource;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final List<RouteBuilderLifecycleStrategy> lifecycleInterceptors = new ArrayList<RouteBuilderLifecycleStrategy>();
    private final List<TransformerBuilder> transformerBuilders = new ArrayList<TransformerBuilder>();
    private final List<ValidatorBuilder> validatorBuilders = new ArrayList<ValidatorBuilder>();
    private RestsDefinition restCollection = new RestsDefinition();
    private RestConfigurationDefinition restConfiguration;
    private RoutesDefinition routeCollection = new RoutesDefinition();
    private RouteTemplatesDefinition routeTemplateCollection = new RouteTemplatesDefinition();
    private TemplatedRoutesDefinition templatedRouteCollection = new TemplatedRoutesDefinition();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public static void addRoutes(CamelContext context, final LambdaRouteBuilder rbc) throws Exception {
        context.addRoutes(new RouteBuilder(context){

            @Override
            public void configure() throws Exception {
                rbc.accept(this);
            }
        });
    }

    public static RouteBuilder loadRoutesBuilder(final Resource resource, final ThrowingBiConsumer<Reader, RouteBuilder, Exception> consumer) {
        return new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                CamelContextAware.trySetCamelContext(resource, this.getContext());
                try (Reader reader = resource.getReader();){
                    consumer.accept(reader, this);
                }
            }
        };
    }

    public static RouteBuilder loadRoutesBuilder(final ThrowingConsumer<RouteBuilder, Exception> consumer) {
        return new RouteBuilder(){

            @Override
            public void configure() throws Exception {
                consumer.accept(this);
            }
        };
    }

    @Override
    public int getOrder() {
        return 2147482647;
    }

    public String toString() {
        return this.getRouteCollection().toString();
    }

    public abstract void configure() throws Exception;

    public void configuration() throws Exception {
    }

    public void bindToRegistry(String id, Object bean) {
        this.getContext().getRegistry().bind(id, bean);
    }

    public void bindToRegistry(String id, Class<?> type, Object bean) {
        this.getContext().getRegistry().bind(id, type, bean);
    }

    public DataFormatBuilderFactory dataFormat() {
        return new DataFormatBuilderFactory();
    }

    public LanguageBuilderFactory expression() {
        return new LanguageBuilderFactory();
    }

    public RestConfigurationDefinition restConfiguration() {
        if (this.restConfiguration == null) {
            this.restConfiguration = new RestConfigurationDefinition();
        }
        return this.restConfiguration;
    }

    public RouteTemplateDefinition routeTemplate(String id) {
        this.getRouteTemplateCollection().setCamelContext(this.getContext());
        RouteTemplateDefinition answer = this.getRouteTemplateCollection().routeTemplate(id);
        this.configureRouteTemplate(answer);
        return answer;
    }

    public TemplatedRouteDefinition templatedRoute(String routeTemplateId) {
        this.getTemplatedRouteCollection().setCamelContext(this.getContext());
        TemplatedRouteDefinition answer = this.getTemplatedRouteCollection().templatedRoute(routeTemplateId);
        this.configureTemplatedRoute(answer);
        return answer;
    }

    public RestDefinition rest() {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest();
        this.configureRest(answer);
        return answer;
    }

    public RestDefinition rest(String path) {
        this.getRestCollection().setCamelContext(this.getContext());
        RestDefinition answer = this.getRestCollection().rest(path);
        this.configureRest(answer);
        return answer;
    }

    public TransformerBuilder transformer() {
        TransformerBuilder tdb = new TransformerBuilder();
        this.transformerBuilders.add(tdb);
        return tdb;
    }

    public ValidatorBuilder validator() {
        ValidatorBuilder vb = new ValidatorBuilder();
        this.validatorBuilders.add(vb);
        return vb;
    }

    public RouteDefinition from(String uri) {
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        RouteDefinition answer = this.getRouteCollection().from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        RouteDefinition answer = this.getRouteCollection().from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        RouteDefinition answer = this.getRouteCollection().from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(EndpointConsumerBuilder endpointDefinition) {
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        RouteDefinition answer = this.getRouteCollection().from(endpointDefinition);
        this.configureRoute(answer);
        return answer;
    }

    public void errorHandler(ErrorHandlerFactory errorHandlerFactory) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        this.setErrorHandlerFactory(errorHandlerFactory);
    }

    public void errorHandler(String ref) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        this.setErrorHandlerFactory(new RefErrorHandlerDefinition(ref));
    }

    public <T> T propertyInject(String key, Class<T> type) throws Exception {
        StringHelper.notEmpty(key, "key");
        ObjectHelper.notNull(type, "Class type");
        PropertiesComponent pc = this.getContext().getPropertiesComponent();
        Optional<String> value = pc.resolveProperty(key);
        if (value.isPresent()) {
            return this.getContext().getTypeConverter().mandatoryConvertTo(type, value.get());
        }
        return null;
    }

    public String property(String key) {
        return "{{" + key + "}}";
    }

    public InterceptDefinition intercept() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exception) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().onException(exception);
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class<? extends Throwable> ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class<? extends Throwable>)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        return this.getRouteCollection().onCompletion();
    }

    @Override
    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes(context);
        this.configureRests(context);
        this.populateRests();
        this.populateTransformers();
        this.populateValidators();
        this.populateRouteTemplates();
        for (RouteDefinition route : this.routeCollection.getRoutes()) {
            this.routeCollection.prepareRoute(route);
        }
        this.populateRoutes();
        if (this instanceof OnCamelContextEvent) {
            context.addLifecycleStrategy(LifecycleStrategySupport.adapt((OnCamelContextEvent)((Object)this)));
        }
    }

    @Override
    public void addTemplatedRoutesToCamelContext(CamelContext context) throws Exception {
        this.populateTemplatedRoutes(context);
    }

    @Override
    public Set<String> updateRoutesToCamelContext(CamelContext context) throws Exception {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        this.configureRoutes(context);
        this.configureRests(context);
        this.populateRests();
        this.populateTransformers();
        this.populateValidators();
        this.populateRouteTemplates();
        for (RouteDefinition route : this.routeCollection.getRoutes()) {
            this.routeCollection.prepareRoute(route);
        }
        this.populateOrUpdateRoutes();
        if (this instanceof OnCamelContextEvent) {
            context.addLifecycleStrategy(LifecycleStrategySupport.adapt((OnCamelContextEvent)((Object)this)));
        }
        for (RouteDefinition route : this.routeCollection.getRoutes()) {
            String id = route.getRouteId();
            answer.add(id);
        }
        return answer;
    }

    public RoutesDefinition configureRoutes(CamelContext context) throws Exception {
        this.setCamelContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public RestsDefinition configureRests(CamelContext context) throws Exception {
        this.setCamelContext(context);
        this.restCollection.setCamelContext(context);
        return this.restCollection;
    }

    @Override
    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        super.setErrorHandlerFactory(errorHandlerFactory);
        this.getRouteCollection().setErrorHandlerFactory(this.getErrorHandlerFactory());
        this.getRouteTemplateCollection().setErrorHandlerFactory(this.getErrorHandlerFactory());
    }

    public void addLifecycleInterceptor(RouteBuilderLifecycleStrategy interceptor) {
        this.lifecycleInterceptors.add(interceptor);
    }

    public void removeLifecycleInterceptor(RouteBuilderLifecycleStrategy interceptor) {
        this.lifecycleInterceptors.remove(interceptor);
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            CamelContext camelContext = this.getContext();
            if (camelContext.adapt(ExtendedCamelContext.class).getErrorHandlerFactory() != null) {
                this.setErrorHandlerFactory(camelContext.adapt(ExtendedCamelContext.class).getErrorHandlerFactory());
            }
            ArrayList<RouteBuilderLifecycleStrategy> strategies = new ArrayList<RouteBuilderLifecycleStrategy>(this.lifecycleInterceptors);
            strategies.addAll(camelContext.getRegistry().findByType(RouteBuilderLifecycleStrategy.class));
            strategies.sort(Comparator.comparing(Ordered::getOrder));
            for (RouteBuilderLifecycleStrategy interceptor : strategies) {
                interceptor.beforeConfigure(this);
            }
            this.configure();
            this.getRouteCollection().setResource(this.getResource());
            for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
                this.getRouteCollection().prepareRoute(route);
            }
            for (RouteBuilderLifecycleStrategy interceptor : strategies) {
                interceptor.afterConfigure(this);
            }
        }
    }

    protected void populateTemplatedRoutes() throws Exception {
        this.populateTemplatedRoutes(this.notNullCamelContext());
    }

    private void populateTemplatedRoutes(CamelContext camelContext) throws Exception {
        this.getTemplatedRouteCollection().setCamelContext(camelContext);
        camelContext.getExtension(Model.class).addRouteFromTemplatedRoutes(this.getTemplatedRouteCollection().getTemplatedRoutes());
    }

    private CamelContext notNullCamelContext() {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        return camelContext;
    }

    protected void populateRouteTemplates() throws Exception {
        CamelContext camelContext = this.notNullCamelContext();
        this.getRouteTemplateCollection().setCamelContext(camelContext);
        camelContext.getExtension(Model.class).addRouteTemplateDefinitions(this.getRouteTemplateCollection().getRouteTemplates());
    }

    protected void populateRoutes() throws Exception {
        CamelContext camelContext = this.notNullCamelContext();
        this.getRouteCollection().setCamelContext(camelContext);
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        camelContext.getExtension(Model.class).addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    protected void populateOrUpdateRoutes() throws Exception {
        CamelContext camelContext = this.notNullCamelContext();
        this.getRouteCollection().setCamelContext(camelContext);
        if (this.resource != null) {
            this.getRouteCollection().setResource(this.resource);
        }
        for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
            camelContext.getRouteController().stopRoute(route.getRouteId());
            camelContext.removeRoute(route.getRouteId());
        }
        camelContext.getExtension(Model.class).addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    protected void populateRests() throws Exception {
        CamelContext camelContext = this.notNullCamelContext();
        this.getRestCollection().setCamelContext(camelContext);
        if (this.restConfiguration != null) {
            this.restConfiguration.asRestConfiguration(this.getContext(), camelContext.getRestConfiguration());
        }
        camelContext.getExtension(Model.class).addRestDefinitions(this.getRestCollection().getRests(), false);
        RestConfiguration config = camelContext.getRestConfiguration();
        if (config.getApiContextPath() != null) {
            boolean hasRestApi = false;
            for (RouteDefinition route : camelContext.getExtension(Model.class).getRouteDefinitions()) {
                FromDefinition from = route.getInput();
                if (from.getEndpointUri() == null || !from.getEndpointUri().startsWith("rest-api:")) continue;
                hasRestApi = true;
            }
            if (!hasRestApi) {
                RouteDefinition route = RestDefinition.asRouteApiDefinition(camelContext, config);
                this.log.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
                this.getRouteCollection().route(route);
            }
        }
        this.getRestCollection().getRests().forEach(rest -> rest.asRouteDefinition(this.getContext()).forEach(route -> this.getRouteCollection().route((RouteDefinition)route)));
    }

    protected void populateTransformers() {
        CamelContext camelContext = this.notNullCamelContext();
        for (TransformerBuilder tdb : this.transformerBuilders) {
            tdb.configure(camelContext);
        }
    }

    protected void populateValidators() {
        CamelContext camelContext = this.notNullCamelContext();
        for (ValidatorBuilder vb : this.validatorBuilders) {
            vb.configure(camelContext);
        }
    }

    public RestsDefinition getRestCollection() {
        return this.restCollection;
    }

    public void setRestCollection(RestsDefinition restCollection) {
        this.restCollection = restCollection;
    }

    public RestConfigurationDefinition getRestConfiguration() {
        return this.restConfiguration;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RouteTemplatesDefinition getRouteTemplateCollection() {
        return this.routeTemplateCollection;
    }

    public void setRouteTemplateCollection(RouteTemplatesDefinition routeTemplateCollection) {
        this.routeTemplateCollection = routeTemplateCollection;
    }

    public TemplatedRoutesDefinition getTemplatedRouteCollection() {
        return this.templatedRouteCollection;
    }

    public void setTemplatedRouteCollection(TemplatedRoutesDefinition templatedRouteCollection) {
        this.templatedRouteCollection = templatedRouteCollection;
    }

    protected void configureRest(RestDefinition rest) {
        CamelContextAware.trySetCamelContext(rest, this.getContext());
    }

    protected void configureRoute(RouteDefinition route) {
        CamelContextAware.trySetCamelContext(route, this.getContext());
    }

    protected void configureRouteTemplate(RouteTemplateDefinition routeTemplate) {
        CamelContextAware.trySetCamelContext(routeTemplate, this.getContext());
    }

    protected void configureTemplatedRoute(CamelContextAware templatedRoute) {
        CamelContextAware.trySetCamelContext(templatedRoute, this.getContext());
    }

    protected void configureRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        CamelContextAware.trySetCamelContext(routesConfiguration, this.getContext());
    }
}

