/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.support.DefaultMessage;

public class GenericFileMessage<T>
extends DefaultMessage {
    private GenericFile<T> file;

    public GenericFileMessage(CamelContext camelContext) {
        super(camelContext);
    }

    public GenericFileMessage(Exchange exchange, GenericFile<T> file) {
        super(exchange);
        this.file = file;
    }

    public GenericFileMessage(CamelContext camelContext, GenericFile<T> file) {
        super(camelContext);
        this.file = file;
    }

    @Override
    protected Object createBody() {
        return this.file != null ? this.file.getBody() : super.createBody();
    }

    public GenericFile<T> getGenericFile() {
        return this.file;
    }

    public void setGenericFile(GenericFile<T> file) {
        this.file = file;
    }

    @Override
    public GenericFileMessage<T> newInstance() {
        return new GenericFileMessage<T>(this.getCamelContext());
    }

    @Override
    public void copyFrom(Message that) {
        super.copyFrom(that);
        if (that instanceof GenericFileMessage) {
            this.setGenericFile(((GenericFileMessage)that).getGenericFile());
        }
    }

    @Override
    public String toString() {
        if (this.file != null) {
            return this.file.getFileName();
        }
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }
}

