/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="1.3.0", label="dataformat,transformation,xml,json", title="XStream")
@XmlRootElement(name="xstream")
@XmlAccessorType(value=XmlAccessType.NONE)
public class XStreamDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlAttribute
    private String permissions;
    @XmlAttribute
    private String encoding;
    @XmlAttribute
    @Metadata(label="advanced", javaType="com.thoughtworks.xstream.io.HierarchicalStreamDriver")
    private String driver;
    @XmlAttribute
    @Metadata(label="advanced", javaType="com.thoughtworks.xstream.io.HierarchicalStreamDriver")
    private String driverRef;
    @XmlAttribute
    @Metadata(label="advanced", enums="NO_REFERENCES,ID_REFERENCES,XPATH_RELATIVE_REFERENCES,XPATH_ABSOLUTE_REFERENCES,SINGLE_NODE_XPATH_RELATIVE_REFERENCES,SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES")
    private String mode;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;
    @XmlElement(name="converters")
    private List<PropertyDefinition> converters;
    @XmlElement(name="aliases")
    private List<PropertyDefinition> aliases;
    @XmlElement(name="omitFields")
    private List<PropertyDefinition> omitFields;
    @XmlElement(name="implicitCollections")
    private List<PropertyDefinition> implicitCollections;

    public XStreamDataFormat() {
        super("xstream");
    }

    public XStreamDataFormat(String encoding) {
        this();
        this.setEncoding(encoding);
    }

    private XStreamDataFormat(Builder builder) {
        this();
        this.permissions = builder.permissions;
        this.encoding = builder.encoding;
        this.driver = builder.driver;
        this.driverRef = builder.driverRef;
        this.mode = builder.mode;
        this.contentTypeHeader = builder.contentTypeHeader;
        this.converters = builder.converters;
        this.aliases = builder.aliases;
        this.omitFields = builder.omitFields;
        this.implicitCollections = builder.implicitCollections;
    }

    @Override
    public String getDataFormatName() {
        return "json".equals(this.driver) ? "xstreamJson" : "xstream";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriverRef() {
        return this.driverRef;
    }

    public void setDriverRef(String driverRef) {
        this.driverRef = driverRef;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<PropertyDefinition> getConverters() {
        return this.converters;
    }

    public Map<String, String> getConvertersAsMap() {
        if (this.converters == null || this.converters.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.converters) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public void setConverters(List<PropertyDefinition> converters) {
        this.converters = converters;
    }

    public void setConverters(Map<String, String> converters) {
        this.setConverters(XStreamDataFormat.toList(converters));
    }

    private static List<PropertyDefinition> toList(Map<String, String> map) {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>(map.size());
        map.forEach((k, v) -> result.add(new PropertyDefinition((String)k, (String)v)));
        return result;
    }

    public List<PropertyDefinition> getAliases() {
        return this.aliases;
    }

    public Map<String, String> getAliasesAsMap() {
        if (this.aliases == null || this.aliases.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.aliases) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public void setAliases(List<PropertyDefinition> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.setAliases(XStreamDataFormat.toList(aliases));
    }

    public List<PropertyDefinition> getOmitFields() {
        return this.omitFields;
    }

    public void setOmitFields(List<PropertyDefinition> omitFields) {
        this.omitFields = omitFields;
    }

    public void setOmitFields(Map<String, String> aliases) {
        this.setOmitFields(XStreamDataFormat.toList(aliases));
    }

    public Map<String, String> getOmitFieldsAsMap() {
        if (this.omitFields == null || this.omitFields.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.omitFields) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public List<PropertyDefinition> getImplicitCollections() {
        return this.implicitCollections;
    }

    public void setImplicitCollections(List<PropertyDefinition> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    public void setImplicitCollections(Map<String, String> implicitCollections) {
        this.setImplicitCollections(XStreamDataFormat.toList(implicitCollections));
    }

    public Map<String, String> getImplicitCollectionsAsMap() {
        if (this.implicitCollections == null || this.implicitCollections.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (PropertyDefinition def : this.implicitCollections) {
            answer.put(def.getKey(), def.getValue());
        }
        return answer;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(Class<?> ... type) {
        this.setPermissions(XStreamDataFormat.toString(type));
    }

    private static String toString(Class<?>[] type) {
        StringJoiner permissionsBuilder = new StringJoiner(",");
        for (Class<?> clazz : type) {
            permissionsBuilder.add("+");
            permissionsBuilder.add(clazz.getName());
        }
        return permissionsBuilder.toString();
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<XStreamDataFormat> {
        private String permissions;
        private String encoding;
        private String driver;
        private String driverRef;
        private String mode;
        private String contentTypeHeader;
        private List<PropertyDefinition> converters;
        private List<PropertyDefinition> aliases;
        private List<PropertyDefinition> omitFields;
        private List<PropertyDefinition> implicitCollections;

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder driverRef(String driverRef) {
            this.driverRef = driverRef;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder converters(List<PropertyDefinition> converters) {
            this.converters = converters;
            return this;
        }

        public Builder converters(Map<String, String> converters) {
            return this.converters(XStreamDataFormat.toList(converters));
        }

        public Builder aliases(List<PropertyDefinition> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder aliases(Map<String, String> aliases) {
            return this.aliases(XStreamDataFormat.toList(aliases));
        }

        public Builder omitFields(List<PropertyDefinition> omitFields) {
            this.omitFields = omitFields;
            return this;
        }

        public Builder omitFields(Map<String, String> aliases) {
            return this.omitFields(XStreamDataFormat.toList(aliases));
        }

        public Builder implicitCollections(List<PropertyDefinition> implicitCollections) {
            this.implicitCollections = implicitCollections;
            return this;
        }

        public Builder implicitCollections(Map<String, String> implicitCollections) {
            return this.implicitCollections(XStreamDataFormat.toList(implicitCollections));
        }

        public Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permissions(Class<?> ... type) {
            return this.permissions(XStreamDataFormat.toString(type));
        }

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        @Override
        public XStreamDataFormat end() {
            return new XStreamDataFormat(this);
        }
    }
}

