/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.util.EntityUtils;

public class HttpPollingConsumer
extends PollingConsumerSupport
implements ServicePoolAware {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.httpClient = endpoint.getHttpClient();
    }

    public Exchange receive() {
        return this.doReceive(-1);
    }

    public Exchange receive(long timeout) {
        return this.doReceive((int)timeout);
    }

    public Exchange receiveNoWait() {
        return this.doReceive(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Exchange doReceive(int timeout) {
        Exchange exchange;
        Exchange exchange2 = this.endpoint.createExchange();
        HttpRequestBase method = this.createMethod(exchange2);
        HttpClientContext httpClientContext = new HttpClientContext();
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).build();
            httpClientContext.setRequestConfig(requestConfig);
        }
        HttpEntity responeEntity = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)method, httpClientContext);
            int responseCode = response.getStatusLine().getStatusCode();
            responeEntity = response.getEntity();
            Object body = HttpHelper.readResponseBodyFromInputStream(responeEntity.getContent(), exchange2);
            Message message = exchange2.getOut();
            message.setBody(body);
            Header[] headers = response.getAllHeaders();
            HeaderFilterStrategy strategy = this.endpoint.getHeaderFilterStrategy();
            for (Header header : headers) {
                String name = header.getName();
                if (name.toLowerCase().equals("content-type")) {
                    name = "Content-Type";
                }
                String value = header.getValue();
                if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange2)) continue;
                message.setHeader(name, (Object)value);
            }
            message.setHeader("CamelHttpResponseCode", (Object)responseCode);
            if (response.getStatusLine() != null) {
                message.setHeader("CamelHttpResponseText", (Object)response.getStatusLine().getReasonPhrase());
            }
            exchange = exchange2;
            if (responeEntity == null) return exchange;
        }
        catch (IOException e) {
            try {
                throw new RuntimeCamelException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (responeEntity == null) throw throwable;
                try {
                    EntityUtils.consume(responeEntity);
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume(responeEntity);
            return exchange;
        }
        catch (IOException e) {
            // empty catch block
        }
        return exchange;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpRequestBase createMethod(Exchange exchange) {
        String uri = HttpHelper.createURL(exchange, this.endpoint);
        return new HttpGet(uri);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

