/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.GlobalCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Objects;

public final class EnvCredentials {
    public static final String AK_ENV_NAME = "HUAWEICLOUD_SDK_AK";
    public static final String SK_ENV_NAME = "HUAWEICLOUD_SDK_SK";
    public static final String PROJECT_ID_ENV_NAME = "HUAWEICLOUD_SDK_PROJECT_ID";
    public static final String DOMAIN_ID_ENV_NAME = "HUAWEICLOUD_SDK_DOMAIN_ID";
    public static final String IAM_ENDPOINT_ENV_NAME = "HUAWEICLOUD_SDK_IAM_ENDPOINT";
    public static final String BASIC_CREDENTIAL_TYPE = "BasicCredentials";
    public static final String GLOBAL_CREDENTIAL_TYPE = "GlobalCredentials";

    private EnvCredentials() {
    }

    public static ICredential loadCredentialFromEnv(String defaultType) {
        String ak = System.getenv(AK_ENV_NAME);
        String sk = System.getenv(SK_ENV_NAME);
        if (BASIC_CREDENTIAL_TYPE.equals(defaultType)) {
            BasicCredentials credentials = (BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(ak)).withSk(sk);
            String projectId = System.getenv(PROJECT_ID_ENV_NAME);
            if (Objects.nonNull(projectId) && !StringUtils.isEmpty(projectId)) {
                credentials.setProjectId(projectId);
            }
            credentials.setIamEndpoint(EnvCredentials.getIamEndpointEnvName());
            return credentials;
        }
        if (GLOBAL_CREDENTIAL_TYPE.equals(defaultType)) {
            GlobalCredentials credentials = (GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withAk(ak)).withSk(sk);
            String domainId = System.getenv(DOMAIN_ID_ENV_NAME);
            if (Objects.nonNull(domainId) && !StringUtils.isEmpty(domainId)) {
                return credentials.withDomainId(domainId);
            }
            credentials.setIamEndpoint(EnvCredentials.getIamEndpointEnvName());
            return credentials;
        }
        return null;
    }

    public static String getIamEndpointEnvName() {
        String iamEndpoint = System.getenv(IAM_ENDPOINT_ENV_NAME);
        if (Objects.isNull(iamEndpoint) || StringUtils.isEmpty(iamEndpoint)) {
            return null;
        }
        return iamEndpoint;
    }
}

