/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.smn;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.smn.v2.SmnClient;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequest;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageRequestBody;
import com.huaweicloud.sdk.smn.v2.model.PublishMessageResponse;
import java.util.HashMap;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.smn.SimpleNotificationEndpoint;
import org.apache.camel.component.huaweicloud.smn.SimpleNotificationUtils;
import org.apache.camel.component.huaweicloud.smn.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNotificationProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNotificationProducer.class);
    private SmnClient smnClient;

    public SimpleNotificationProducer(SimpleNotificationEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        block12: {
            block11: {
                String service;
                ClientConfigurations clientConfigurations = new ClientConfigurations();
                if (this.smnClient == null) {
                    this.validateAndInitializeSmnClient((SimpleNotificationEndpoint)super.getEndpoint(), clientConfigurations);
                }
                if (ObjectHelper.isEmpty(service = ((SimpleNotificationEndpoint)super.getEndpoint()).getSmnService())) break block11;
                switch (service) {
                    case "publishMessageService": {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Using message publishing service");
                        }
                        this.performPublishMessageServiceOperations((SimpleNotificationEndpoint)super.getEndpoint(), exchange, clientConfigurations);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Completed publishing message");
                            break;
                        }
                        break block12;
                    }
                    default: {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Unsupported service name {}", (Object)service);
                        }
                        throw new UnsupportedOperationException(String.format("service %s is not a supported service", service));
                    }
                }
                break block12;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Service name is null/empty");
            }
            throw new IllegalStateException("service name cannot be null/empty");
        }
    }

    private void performPublishMessageServiceOperations(SimpleNotificationEndpoint endpoint, Exchange exchange, ClientConfigurations clientConfigurations) {
        PublishMessageResponse response;
        this.validateServiceConfigurations(endpoint, exchange, clientConfigurations);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking operation name");
        }
        switch (clientConfigurations.getOperation()) {
            case "publishAsTextMessage": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Publishing as text message");
                }
                PublishMessageRequestBody apiBody = new PublishMessageRequestBody().withMessage(exchange.getMessage().getBody(String.class)).withSubject(clientConfigurations.getSubject()).withTimeToLive(String.valueOf(clientConfigurations.getMessageTtl()));
                response = this.smnClient.publishMessage(new PublishMessageRequest().withBody(apiBody).withTopicUrn(clientConfigurations.getTopicUrn()));
                break;
            }
            case "publishAsTemplatedMessage": {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Publishing as templated message");
                }
                PublishMessageRequestBody apiBody = new PublishMessageRequestBody().withMessage(exchange.getMessage().getBody(String.class)).withSubject(clientConfigurations.getSubject()).withTimeToLive(String.valueOf(clientConfigurations.getMessageTtl())).withMessageTemplateName((String)exchange.getProperty("CamelHwCloudSmnTemplateName")).withTags((HashMap)exchange.getProperty("CamelHwCloudSmnTemplateTags")).withTimeToLive(String.valueOf(clientConfigurations.getMessageTtl()));
                response = this.smnClient.publishMessage(new PublishMessageRequest().withBody(apiBody).withTopicUrn(clientConfigurations.getTopicUrn()));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("operation %s not supported in publishMessage service", clientConfigurations.getOperation()));
            }
        }
        this.setResponseParameters(exchange, response);
    }

    private void setResponseParameters(Exchange exchange, PublishMessageResponse response) {
        if (response == null) {
            return;
        }
        if (!ObjectHelper.isEmpty(response.getMessageId())) {
            exchange.setProperty("CamelHwCloudSmnMesssageId", (Object)response.getMessageId());
        }
        if (!ObjectHelper.isEmpty(response.getRequestId())) {
            exchange.setProperty("CamelHwCloudSmnRequestId", (Object)response.getRequestId());
        }
    }

    private void validateAndInitializeSmnClient(SimpleNotificationEndpoint simpleNotificationEndpoint, ClientConfigurations clientConfigurations) {
        if (simpleNotificationEndpoint.getSmnClient() != null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Instance of SmnClient was set on the endpoint. Skipping creation of SmnClient from endpoint parameters");
            }
            this.smnClient = simpleNotificationEndpoint.getSmnClient();
            return;
        }
        if (ObjectHelper.isEmpty(simpleNotificationEndpoint.getSecretKey()) && ObjectHelper.isEmpty(simpleNotificationEndpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("secret key (SK) not found");
            }
            throw new IllegalArgumentException("authentication parameter 'secret key (SK)' not found");
        }
        clientConfigurations.setSecretKey(simpleNotificationEndpoint.getSecretKey() != null ? simpleNotificationEndpoint.getSecretKey() : simpleNotificationEndpoint.getServiceKeys().getSecretKey());
        if (ObjectHelper.isEmpty(simpleNotificationEndpoint.getAccessKey()) && ObjectHelper.isEmpty(simpleNotificationEndpoint.getServiceKeys())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("access key (AK) not found");
            }
            throw new IllegalArgumentException("authentication parameter 'access key (AK)' not found");
        }
        clientConfigurations.setAccessKey(simpleNotificationEndpoint.getAccessKey() != null ? simpleNotificationEndpoint.getAccessKey() : simpleNotificationEndpoint.getServiceKeys().getAccessKey());
        if (ObjectHelper.isEmpty(simpleNotificationEndpoint.getProjectId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Project ID not found");
            }
            throw new IllegalArgumentException("project ID not found");
        }
        clientConfigurations.setProjectId(simpleNotificationEndpoint.getProjectId());
        if (StringUtils.isNotEmpty(simpleNotificationEndpoint.getEndpoint())) {
            clientConfigurations.setServiceEndpoint(simpleNotificationEndpoint.getEndpoint());
        } else {
            String endpointUrl = SimpleNotificationUtils.resolveSmnServiceEndpoint(simpleNotificationEndpoint.getRegion());
            if (endpointUrl == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Valid region not found");
                }
                throw new IllegalArgumentException("enter a valid region");
            }
            clientConfigurations.setServiceEndpoint(endpointUrl);
        }
        boolean ignoreSslVerification = simpleNotificationEndpoint.isIgnoreSslVerification();
        if (ignoreSslVerification) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("SSL verification is ignored. This is unsafe in production environment");
            }
            clientConfigurations.setIgnoreSslVerification(ignoreSslVerification);
        }
        if (simpleNotificationEndpoint.getProxyHost() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading http proxy configurations");
            }
            clientConfigurations.setProxyHost(simpleNotificationEndpoint.getProxyHost());
            clientConfigurations.setProxyPort(simpleNotificationEndpoint.getProxyPort());
            clientConfigurations.setProxyUser(simpleNotificationEndpoint.getProxyUser());
            clientConfigurations.setProxyPassword(simpleNotificationEndpoint.getProxyPassword());
        }
        this.smnClient = this.initializeClient(clientConfigurations);
    }

    private SmnClient initializeClient(ClientConfigurations clientConfigurations) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing Smn client");
        }
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig().withIgnoreSSLVerification(clientConfigurations.isIgnoreSslVerification());
        if (!StringUtils.isEmpty(clientConfigurations.getProxyHost())) {
            httpConfig.setProxyHost(clientConfigurations.getProxyHost());
            httpConfig.setProxyPort(clientConfigurations.getProxyPort());
            if (!StringUtils.isEmpty(clientConfigurations.getProxyUser())) {
                httpConfig.setProxyUsername(clientConfigurations.getProxyUser());
                httpConfig.setProxyPassword(clientConfigurations.getProxyPassword());
            }
        }
        BasicCredentials credentials = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(clientConfigurations.getAccessKey())).withSk(clientConfigurations.getSecretKey())).withProjectId(clientConfigurations.getProjectId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building Smn client");
        }
        SmnClient smnClient = SmnClient.newBuilder().withCredential(credentials).withHttpConfig(httpConfig).withEndpoint(clientConfigurations.getServiceEndpoint()).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully initialized Smn client");
        }
        return smnClient;
    }

    private void validateServiceConfigurations(SimpleNotificationEndpoint simpleNotificationEndpoint, Exchange exchange, ClientConfigurations clientConfigurations) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting exchange body");
        }
        if (ObjectHelper.isEmpty(exchange.getMessage().getBody()) && simpleNotificationEndpoint.getOperation().equals("publishAsTextMessage")) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty body. Cannot perform publish as text operation");
            }
            throw new IllegalArgumentException("exchange body cannot be null / empty");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting operation name");
        }
        if (ObjectHelper.isEmpty(exchange.getProperty("CamelHwCloudSmnOperation")) && ObjectHelper.isEmpty(simpleNotificationEndpoint.getOperation())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty operation name. Cannot proceed with Smn operations");
            }
            throw new IllegalArgumentException("operation name not found");
        }
        clientConfigurations.setOperation(exchange.getProperty("CamelHwCloudSmnOperation") != null ? (String)exchange.getProperty("CamelHwCloudSmnOperation") : simpleNotificationEndpoint.getOperation());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting topic name");
        }
        if (ObjectHelper.isEmpty(exchange.getProperty("CamelHwCloudSmnTopic"))) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Found null/empty topic name");
            }
            throw new IllegalArgumentException("topic name not found");
        }
        clientConfigurations.setTopicUrn(String.format("urn:smn:%s:%s:%s", simpleNotificationEndpoint.getRegion(), simpleNotificationEndpoint.getProjectId(), exchange.getProperty("CamelHwCloudSmnTopic")));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting notification subject value");
        }
        if (ObjectHelper.isEmpty(exchange.getProperty("CamelHwCloudSmnSubject"))) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("notification subject not found. defaulting to 'DEFAULT_SUBJECT'");
            }
            clientConfigurations.setSubject("DEFAULT_SUBJECT");
        } else {
            clientConfigurations.setSubject((String)exchange.getProperty("CamelHwCloudSmnSubject"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inspecting TTL");
        }
        if (ObjectHelper.isEmpty(exchange.getProperty("CamelHwCloudSmnMessageTtl"))) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("TTL not found. defaulting to default value {}", (Object)simpleNotificationEndpoint.getMessageTtl());
            }
            clientConfigurations.setMessageTtl(simpleNotificationEndpoint.getMessageTtl());
        } else {
            clientConfigurations.setMessageTtl((Integer)exchange.getProperty("CamelHwCloudSmnMessageTtl"));
        }
    }
}

