/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ConfigurationBackedDynamicPropertySupportImpl;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicDoubleProperty;
import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicProperty;
import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.PropertyWrapper;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPropertyFactory {
    private static DynamicPropertyFactory instance = new DynamicPropertyFactory();
    private static volatile DynamicPropertySupport config = null;
    private static volatile boolean initializedWithDefaultConfig = false;
    private static volatile boolean defaultConfigNotFound = false;
    private static final Logger logger = LoggerFactory.getLogger(DynamicPropertyFactory.class);
    public static final String URL_CONFIG_NAME = "archaius.dynamicPropertyFactory.URL_CONFIG";
    public static final String SYS_CONFIG_NAME = "archaius.dynamicPropertyFactory.SYS_CONFIG";
    public static final String ENABLE_JMX = "archaius.dynamicPropertyFactory.registerConfigWithJMX";
    public static final String THROW_MISSING_CONFIGURATION_SOURCE_EXCEPTION = "archaius.dynamicProperty.throwMissingConfigurationSourceException";
    private static volatile boolean throwMissingConfigurationSourceException = Boolean.getBoolean("archaius.dynamicProperty.throwMissingConfigurationSourceException");
    public static final String DISABLE_DEFAULT_SYS_CONFIG = "archaius.dynamicProperty.disableSystemConfig";
    public static final String DISABLE_DEFAULT_CONFIG = "archaius.dynamicProperty.disableDefaultConfig";

    private DynamicPropertyFactory() {
    }

    public static DynamicPropertyFactory initWithConfigurationSource(AbstractConfiguration abstractConfiguration) {
        if (ConfigurationManager.isConfigurationInstalled() && abstractConfiguration != ConfigurationManager.instance) {
            throw new IllegalStateException("ConfigurationManager is already initialized with configuration " + ConfigurationManager.getConfigInstance());
        }
        if (abstractConfiguration instanceof DynamicPropertySupport) {
            return DynamicPropertyFactory.initWithConfigurationSource((DynamicPropertySupport)((Object)abstractConfiguration));
        }
        return DynamicPropertyFactory.initWithConfigurationSource(new ConfigurationBackedDynamicPropertySupportImpl(abstractConfiguration));
    }

    public static boolean isInitializedWithDefaultConfig() {
        return initializedWithDefaultConfig;
    }

    public static Object getBackingConfigurationSource() {
        if (config instanceof ConfigurationBackedDynamicPropertySupportImpl) {
            return ((ConfigurationBackedDynamicPropertySupportImpl)config).getConfiguration();
        }
        return config;
    }

    public static void setThrowMissingConfigurationSourceException(boolean bl) {
        throwMissingConfigurationSourceException = bl;
    }

    public static boolean isThrowMissingConfigurationSourceException() {
        return throwMissingConfigurationSourceException;
    }

    public static synchronized DynamicPropertyFactory initWithConfigurationSource(DynamicPropertySupport dynamicPropertySupport) {
        if (dynamicPropertySupport == null) {
            throw new IllegalArgumentException("dynamicPropertySupport is null");
        }
        AbstractConfiguration abstractConfiguration = null;
        if (dynamicPropertySupport instanceof AbstractConfiguration) {
            abstractConfiguration = (AbstractConfiguration)((Object)dynamicPropertySupport);
        } else if (dynamicPropertySupport instanceof ConfigurationBackedDynamicPropertySupportImpl) {
            abstractConfiguration = ((ConfigurationBackedDynamicPropertySupportImpl)dynamicPropertySupport).getConfiguration();
        }
        if (initializedWithDefaultConfig) {
            config = null;
        } else if (config != null && config != dynamicPropertySupport) {
            throw new IllegalStateException("DynamicPropertyFactory is already initialized with a diffrerent configuration source: " + config);
        }
        if (ConfigurationManager.isConfigurationInstalled() && abstractConfiguration != null && abstractConfiguration != ConfigurationManager.instance) {
            throw new IllegalStateException("ConfigurationManager is already initialized with configuration " + ConfigurationManager.getConfigInstance());
        }
        if (abstractConfiguration != null && abstractConfiguration != ConfigurationManager.instance) {
            ConfigurationManager.setDirect(abstractConfiguration);
        }
        DynamicPropertyFactory.setDirect(dynamicPropertySupport);
        return instance;
    }

    static void setDirect(DynamicPropertySupport dynamicPropertySupport) {
        config = dynamicPropertySupport;
        DynamicProperty.registerWithDynamicPropertySupport(dynamicPropertySupport);
        initializedWithDefaultConfig = false;
    }

    private static boolean shouldInstallDefaultConfig() {
        return !defaultConfigNotFound && !Boolean.getBoolean(DISABLE_DEFAULT_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicPropertyFactory getInstance() {
        if (config != null || !DynamicPropertyFactory.shouldInstallDefaultConfig()) return instance;
        Class<DynamicPropertyFactory> clazz = DynamicPropertyFactory.class;
        synchronized (DynamicPropertyFactory.class) {
            if (config != null) return instance;
            AbstractConfiguration abstractConfiguration = ConfigurationManager.getConfigInstance();
            DynamicPropertyFactory.initWithConfigurationSource(abstractConfiguration);
            initializedWithDefaultConfig = !ConfigurationManager.isConfigurationInstalled();
            logger.info("DynamicPropertyFactory is initialized with configuration sources: " + abstractConfiguration);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void checkAndWarn(String string) {
        if (config == null) {
            logger.warn("DynamicProperty " + string + " is created without a configuration source for callback.");
        }
    }

    public DynamicStringProperty getStringProperty(String string, String string2) {
        return this.getStringProperty(string, string2, null);
    }

    public DynamicStringProperty getStringProperty(String string, String string2, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicStringProperty dynamicStringProperty = new DynamicStringProperty(string, string2);
        DynamicPropertyFactory.addCallback(runnable, dynamicStringProperty);
        return dynamicStringProperty;
    }

    public DynamicIntProperty getIntProperty(String string, int n) {
        return this.getIntProperty(string, n, null);
    }

    public DynamicIntProperty getIntProperty(String string, int n, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicIntProperty dynamicIntProperty = new DynamicIntProperty(string, n);
        DynamicPropertyFactory.addCallback(runnable, dynamicIntProperty);
        return dynamicIntProperty;
    }

    public DynamicLongProperty getLongProperty(String string, long l) {
        return this.getLongProperty(string, l, null);
    }

    public DynamicLongProperty getLongProperty(String string, long l, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicLongProperty dynamicLongProperty = new DynamicLongProperty(string, l);
        DynamicPropertyFactory.addCallback(runnable, dynamicLongProperty);
        return dynamicLongProperty;
    }

    public DynamicBooleanProperty getBooleanProperty(String string, boolean bl) {
        return this.getBooleanProperty(string, bl, null);
    }

    public DynamicBooleanProperty getBooleanProperty(String string, boolean bl, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicBooleanProperty dynamicBooleanProperty = new DynamicBooleanProperty(string, bl);
        DynamicPropertyFactory.addCallback(runnable, dynamicBooleanProperty);
        return dynamicBooleanProperty;
    }

    public DynamicFloatProperty getFloatProperty(String string, float f) {
        return this.getFloatProperty(string, f, null);
    }

    public DynamicFloatProperty getFloatProperty(String string, float f, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicFloatProperty dynamicFloatProperty = new DynamicFloatProperty(string, f);
        DynamicPropertyFactory.addCallback(runnable, dynamicFloatProperty);
        return dynamicFloatProperty;
    }

    public DynamicDoubleProperty getDoubleProperty(String string, double d) {
        return this.getDoubleProperty(string, d, null);
    }

    public DynamicDoubleProperty getDoubleProperty(String string, double d, Runnable runnable) {
        DynamicPropertyFactory.checkAndWarn(string);
        DynamicDoubleProperty dynamicDoubleProperty = new DynamicDoubleProperty(string, d);
        DynamicPropertyFactory.addCallback(runnable, dynamicDoubleProperty);
        return dynamicDoubleProperty;
    }

    private static void addCallback(Runnable runnable, PropertyWrapper<?> propertyWrapper) {
        if (runnable != null) {
            propertyWrapper.prop.addCallback(runnable);
        }
    }
}

