/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ClasspathPropertiesConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.util.ConfigurationUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationProperties {
    private static final Logger logger = LoggerFactory.getLogger(WebApplicationProperties.class);
    static File appConfFolder = new File(".");
    static String baseConfigFileName = "config";
    static boolean loadLibraryProperties = true;
    static String libraryPropertiesResourceRelativePath = ClasspathPropertiesConfiguration.propertiesResourceRelativePath;

    public static void initialize(File file, String string, boolean bl, String string2) {
        appConfFolder = file;
        baseConfigFileName = string;
        loadLibraryProperties = bl;
        libraryPropertiesResourceRelativePath = string2;
        WebApplicationProperties.initialize();
    }

    public static void initialize() {
        try {
            WebApplicationProperties.initApplicationProperties();
        }
        catch (Exception exception) {
            logger.error("Unable to load Application Properties", (Throwable)exception);
            System.err.println("Unable to load Application Properties");
            exception.printStackTrace();
        }
        if (loadLibraryProperties) {
            try {
                WebApplicationProperties.initClasspathPropertiesConfiguration();
            }
            catch (Exception exception) {
                logger.error("Unable to load Library Properties", (Throwable)exception);
                System.err.println("Unable to load Library Properties");
                exception.printStackTrace();
            }
        }
        logger.debug("Properties loaded:" + WebApplicationProperties.getProperties());
    }

    protected static void initClasspathPropertiesConfiguration() {
        ClasspathPropertiesConfiguration.initialize();
    }

    protected static void initApplicationProperties() throws ConfigurationException, MalformedURLException {
        File file = new File(appConfFolder + "/" + baseConfigFileName + ".properties");
        File file2 = new File(appConfFolder + "/" + baseConfigFileName + WebApplicationProperties.getEnvironment() + ".properties");
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(file);
        PropertiesConfiguration propertiesConfiguration2 = new PropertiesConfiguration(file2);
        Properties properties = ConfigurationUtils.getProperties(propertiesConfiguration2);
        for (Object object : properties.keySet()) {
            propertiesConfiguration.setProperty("" + object, properties.getProperty("" + object));
        }
        String string = file.toURI().toURL().toString();
        System.setProperty("archaius.configurationSource.additionalUrls", string);
        ConfigurationManager.loadPropertiesFromConfiguration(propertiesConfiguration);
    }

    private static String getEnvironment() {
        String string = System.getProperty("env");
        return string;
    }

    public static File getAppConfFolder() {
        return appConfFolder;
    }

    public static void setAppConfFolder(File file, String string) {
        appConfFolder = file;
        baseConfigFileName = string;
    }

    public static boolean shouldLoadLibraryProperties() {
        return loadLibraryProperties;
    }

    public static void setLoadLibraryProperties(boolean bl) {
        loadLibraryProperties = bl;
    }

    public static String getLibraryPropertiesResourceRelativePath() {
        return libraryPropertiesResourceRelativePath;
    }

    public static void setLibraryPropertiesResourceRelativePath(String string) {
        libraryPropertiesResourceRelativePath = string;
    }

    public static Properties getProperties() {
        return ConfigurationUtils.getProperties(ConfigurationManager.getConfigInstance());
    }
}

