/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Action0;

public class Hystrix {
    private static final Logger logger = LoggerFactory.getLogger(Hystrix.class);
    private static ThreadLocal<ConcurrentStack<HystrixCommandKey>> currentCommand = new ThreadLocal<ConcurrentStack<HystrixCommandKey>>(){

        @Override
        protected ConcurrentStack<HystrixCommandKey> initialValue() {
            return new ConcurrentStack<HystrixCommandKey>();
        }
    };

    public static void reset() {
        HystrixThreadPool.Factory.shutdown();
        Hystrix._reset();
    }

    public static void reset(long time, TimeUnit unit) {
        HystrixThreadPool.Factory.shutdown(time, unit);
        Hystrix._reset();
    }

    private static void _reset() {
        HystrixCommandMetrics.reset();
        HystrixThreadPoolMetrics.reset();
        HystrixCollapserMetrics.reset();
        HystrixCollapser.reset();
        HystrixCircuitBreaker.Factory.reset();
        HystrixPlugins.reset();
        HystrixPropertiesFactory.reset();
        currentCommand.set(new ConcurrentStack());
    }

    public static HystrixCommandKey getCurrentThreadExecutingCommand() {
        if (currentCommand == null) {
            return null;
        }
        return currentCommand.get().peek();
    }

    static Action0 startCurrentThreadExecutingCommand(HystrixCommandKey key) {
        final ConcurrentStack<HystrixCommandKey> list = currentCommand.get();
        try {
            list.push(key);
        }
        catch (Exception e) {
            logger.warn("Unable to record command starting", (Throwable)e);
        }
        return new Action0(){

            @Override
            public void call() {
                Hystrix.endCurrentThreadExecutingCommand(list);
            }
        };
    }

    static void endCurrentThreadExecutingCommand() {
        Hystrix.endCurrentThreadExecutingCommand(currentCommand.get());
    }

    private static void endCurrentThreadExecutingCommand(ConcurrentStack<HystrixCommandKey> list) {
        try {
            if (!list.isEmpty()) {
                list.pop();
            }
        }
        catch (NoSuchElementException e) {
            logger.debug("No command found to end.", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Unable to end command.", (Throwable)e);
        }
    }

    static int getCommandCount() {
        return currentCommand.get().size();
    }

    private static class ConcurrentStack<E> {
        AtomicReference<Node<E>> top = new AtomicReference();

        private ConcurrentStack() {
        }

        public void push(E item) {
            Node<E> oldHead;
            Node<E> newHead = new Node<E>(item);
            do {
                oldHead = this.top.get();
                newHead.next = oldHead;
            } while (!this.top.compareAndSet(oldHead, newHead));
        }

        public E pop() {
            Node newHead;
            Node<E> oldHead;
            do {
                if ((oldHead = this.top.get()) != null) continue;
                return null;
            } while (!this.top.compareAndSet(oldHead, newHead = oldHead.next));
            return oldHead.item;
        }

        public boolean isEmpty() {
            return this.top.get() == null;
        }

        public int size() {
            int currentSize = 0;
            Node<E> current = this.top.get();
            while (current != null) {
                ++currentSize;
                current = current.next;
            }
            return currentSize;
        }

        public E peek() {
            Node<E> eNode = this.top.get();
            if (eNode == null) {
                return null;
            }
            return eNode.item;
        }

        private class Node<E> {
            public final E item;
            public Node<E> next;

            public Node(E item) {
                this.item = item;
            }
        }
    }
}

