/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import com.netflix.hystrix.collapser.RequestBatch;
import com.netflix.hystrix.collapser.RequestCollapser;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.subjects.ReplaySubject;

class CollapsedRequestSubject<T, R>
implements HystrixCollapser.CollapsedRequest<T, R> {
    private final R argument;
    private AtomicBoolean valueSet = new AtomicBoolean(false);
    private final ReplaySubject<T> subject = ReplaySubject.create();
    private final Observable<T> subjectWithAccounting;
    private volatile int outstandingSubscriptions = 0;

    public CollapsedRequestSubject(final R arg, final RequestBatch<?, T, R> containingBatch) {
        this.argument = arg == RequestCollapser.NULL_SENTINEL ? null : arg;
        this.subjectWithAccounting = this.subject.doOnSubscribe(new Action0(){

            @Override
            public void call() {
                CollapsedRequestSubject.this.outstandingSubscriptions++;
            }
        }).doOnUnsubscribe(new Action0(){

            @Override
            public void call() {
                CollapsedRequestSubject.this.outstandingSubscriptions--;
                if (CollapsedRequestSubject.this.outstandingSubscriptions == 0) {
                    containingBatch.remove(arg);
                }
            }
        });
    }

    public CollapsedRequestSubject(R arg) {
        this.subjectWithAccounting = this.subject;
        this.argument = arg;
    }

    @Override
    public R getArgument() {
        return this.argument;
    }

    @Override
    public void setResponse(T response) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so response can not be set : " + response);
        }
        this.subject.onNext(response);
        this.valueSet.set(true);
        this.subject.onCompleted();
    }

    @Override
    public void emitResponse(T response) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so response can not be set : " + response);
        }
        this.subject.onNext(response);
        this.valueSet.set(true);
    }

    @Override
    public void setComplete() {
        if (!this.isTerminated()) {
            this.subject.onCompleted();
        }
    }

    public void setExceptionIfResponseNotReceived(Exception e) {
        if (!this.valueSet.get() && !this.isTerminated()) {
            this.subject.onError(e);
        }
    }

    public Exception setExceptionIfResponseNotReceived(Exception e, String exceptionMessage) {
        Exception exception = e;
        if (!this.valueSet.get() && !this.isTerminated()) {
            if (e == null) {
                exception = new IllegalStateException(exceptionMessage);
            }
            this.setExceptionIfResponseNotReceived(exception);
        }
        return exception;
    }

    @Override
    public void setException(Exception e) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Response has already terminated so exception can not be set", e);
        }
        this.subject.onError(e);
    }

    private boolean isTerminated() {
        return this.subject.hasCompleted() || this.subject.hasThrowable();
    }

    public Observable<T> toObservable() {
        return this.subjectWithAccounting;
    }
}

