/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.requests.stream;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixRequestEvents;
import com.netflix.hystrix.metric.HystrixRequestEventsStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import rx.Observable;

@Deprecated
public class HystrixRequestEventsJsonStream {
    private static final JsonFactory jsonFactory = new JsonFactory();

    public Observable<HystrixRequestEvents> getStream() {
        return HystrixRequestEventsStream.getInstance().observe();
    }

    public static String convertRequestsToJson(Collection<HystrixRequestEvents> requests) throws IOException {
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = jsonFactory.createGenerator(jsonString);
        json.writeStartArray();
        for (HystrixRequestEvents request : requests) {
            HystrixRequestEventsJsonStream.writeRequestAsJson(json, request);
        }
        json.writeEndArray();
        json.close();
        return jsonString.getBuffer().toString();
    }

    public static String convertRequestToJson(HystrixRequestEvents request) throws IOException {
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = jsonFactory.createGenerator(jsonString);
        HystrixRequestEventsJsonStream.writeRequestAsJson(json, request);
        json.close();
        return jsonString.getBuffer().toString();
    }

    private static void writeRequestAsJson(JsonGenerator json, HystrixRequestEvents request) throws IOException {
        json.writeStartArray();
        for (Map.Entry<HystrixRequestEvents.ExecutionSignature, List<Integer>> entry : request.getExecutionsMappedToLatencies().entrySet()) {
            HystrixRequestEventsJsonStream.convertExecutionToJson(json, entry.getKey(), entry.getValue());
        }
        json.writeEndArray();
    }

    private static void convertExecutionToJson(JsonGenerator json, HystrixRequestEvents.ExecutionSignature executionSignature, List<Integer> latencies) throws IOException {
        json.writeStartObject();
        json.writeStringField("name", executionSignature.getCommandName());
        json.writeArrayFieldStart("events");
        ExecutionResult.EventCounts eventCounts = executionSignature.getEventCounts();
        for (HystrixEventType eventType : HystrixEventType.values()) {
            if (eventType == HystrixEventType.COLLAPSED || !eventCounts.contains(eventType)) continue;
            int eventCount = eventCounts.getCount(eventType);
            if (eventCount > 1) {
                json.writeStartObject();
                json.writeStringField("name", eventType.name());
                json.writeNumberField("count", eventCount);
                json.writeEndObject();
                continue;
            }
            json.writeString(eventType.name());
        }
        json.writeEndArray();
        json.writeArrayFieldStart("latencies");
        for (int latency : latencies) {
            json.writeNumber(latency);
        }
        json.writeEndArray();
        if (executionSignature.getCachedCount() > 0) {
            json.writeNumberField("cached", executionSignature.getCachedCount());
        }
        if (executionSignature.getEventCounts().contains(HystrixEventType.COLLAPSED)) {
            json.writeObjectFieldStart("collapsed");
            json.writeStringField("name", executionSignature.getCollapserKey().name());
            json.writeNumberField("count", executionSignature.getCollapserBatchSize());
            json.writeEndObject();
        }
        json.writeEndObject();
    }
}

