/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.sample.stream;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.sample.HystrixCommandUtilization;
import com.netflix.hystrix.metric.sample.HystrixThreadPoolUtilization;
import com.netflix.hystrix.metric.sample.HystrixUtilization;
import com.netflix.hystrix.metric.sample.HystrixUtilizationStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@Deprecated
public class HystrixUtilizationJsonStream {
    private final Func1<Integer, Observable<HystrixUtilization>> streamGenerator;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final Func1<HystrixUtilization, String> convertToJsonFunc = new Func1<HystrixUtilization, String>(){

        @Override
        public String call(HystrixUtilization utilization) {
            try {
                return HystrixUtilizationJsonStream.convertToJson(utilization);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    };

    @Deprecated
    public HystrixUtilizationJsonStream() {
        this.streamGenerator = new Func1<Integer, Observable<HystrixUtilization>>(){

            @Override
            public Observable<HystrixUtilization> call(Integer delay) {
                return HystrixUtilizationStream.getInstance().observe();
            }
        };
    }

    @Deprecated
    public HystrixUtilizationJsonStream(Func1<Integer, Observable<HystrixUtilization>> streamGenerator) {
        this.streamGenerator = streamGenerator;
    }

    private static void writeCommandUtilizationJson(JsonGenerator json, HystrixCommandKey key, HystrixCommandUtilization utilization) throws IOException {
        json.writeObjectFieldStart(key.name());
        json.writeNumberField("activeCount", utilization.getConcurrentCommandCount());
        json.writeEndObject();
    }

    private static void writeThreadPoolUtilizationJson(JsonGenerator json, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolUtilization utilization) throws IOException {
        json.writeObjectFieldStart(threadPoolKey.name());
        json.writeNumberField("activeCount", utilization.getCurrentActiveCount());
        json.writeNumberField("queueSize", utilization.getCurrentQueueSize());
        json.writeNumberField("corePoolSize", utilization.getCurrentCorePoolSize());
        json.writeNumberField("poolSize", utilization.getCurrentPoolSize());
        json.writeEndObject();
    }

    protected static String convertToJson(HystrixUtilization utilization) throws IOException {
        StringWriter jsonString = new StringWriter();
        JsonGenerator json = jsonFactory.createGenerator(jsonString);
        json.writeStartObject();
        json.writeStringField("type", "HystrixUtilization");
        json.writeObjectFieldStart("commands");
        for (Map.Entry<HystrixCommandKey, HystrixCommandUtilization> entry : utilization.getCommandUtilizationMap().entrySet()) {
            HystrixCommandKey key = entry.getKey();
            HystrixCommandUtilization commandUtilization = entry.getValue();
            HystrixUtilizationJsonStream.writeCommandUtilizationJson(json, key, commandUtilization);
        }
        json.writeEndObject();
        json.writeObjectFieldStart("threadpools");
        for (Map.Entry<HystrixKey, Object> entry : utilization.getThreadPoolUtilizationMap().entrySet()) {
            HystrixThreadPoolKey threadPoolKey = (HystrixThreadPoolKey)entry.getKey();
            HystrixThreadPoolUtilization threadPoolUtilization = (HystrixThreadPoolUtilization)entry.getValue();
            HystrixUtilizationJsonStream.writeThreadPoolUtilizationJson(json, threadPoolKey, threadPoolUtilization);
        }
        json.writeEndObject();
        json.writeEndObject();
        json.close();
        return jsonString.getBuffer().toString();
    }

    @Deprecated
    public Observable<HystrixUtilization> observe(int delay) {
        return this.streamGenerator.call(delay);
    }

    public Observable<String> observeJson(int delay) {
        return this.streamGenerator.call(delay).map(convertToJsonFunc);
    }
}

