/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.metric.HystrixCommandExecutionStarted;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscription;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.subjects.BehaviorSubject;

public abstract class RollingConcurrencyStream {
    private AtomicReference<Subscription> rollingMaxSubscription = new AtomicReference<Object>(null);
    private final BehaviorSubject<Integer> rollingMax = BehaviorSubject.create(0);
    private final Observable<Integer> rollingMaxStream;
    private static final Func2<Integer, Integer, Integer> reduceToMax = new Func2<Integer, Integer, Integer>(){

        @Override
        public Integer call(Integer a, Integer b) {
            return Math.max(a, b);
        }
    };
    private static final Func1<Observable<Integer>, Observable<Integer>> reduceStreamToMax = new Func1<Observable<Integer>, Observable<Integer>>(){

        @Override
        public Observable<Integer> call(Observable<Integer> observedConcurrency) {
            return observedConcurrency.reduce(0, reduceToMax);
        }
    };
    private static final Func1<HystrixCommandExecutionStarted, Integer> getConcurrencyCountFromEvent = new Func1<HystrixCommandExecutionStarted, Integer>(){

        @Override
        public Integer call(HystrixCommandExecutionStarted event) {
            return event.getCurrentConcurrency();
        }
    };

    protected RollingConcurrencyStream(HystrixEventStream<HystrixCommandExecutionStarted> inputEventStream, int numBuckets, int bucketSizeInMs) {
        ArrayList<Integer> emptyRollingMaxBuckets = new ArrayList<Integer>();
        for (int i = 0; i < numBuckets; ++i) {
            emptyRollingMaxBuckets.add(0);
        }
        this.rollingMaxStream = inputEventStream.observe().map(getConcurrencyCountFromEvent).window((long)bucketSizeInMs, TimeUnit.MILLISECONDS).flatMap(reduceStreamToMax).startWith((Integer)((Object)emptyRollingMaxBuckets)).window(numBuckets, 1).flatMap(reduceStreamToMax).share().onBackpressureDrop();
    }

    public void startCachingStreamValuesIfUnstarted() {
        Subscription candidateSubscription;
        if (this.rollingMaxSubscription.get() == null && !this.rollingMaxSubscription.compareAndSet(null, candidateSubscription = this.observe().subscribe(this.rollingMax))) {
            candidateSubscription.unsubscribe();
        }
    }

    public long getLatestRollingMax() {
        this.startCachingStreamValuesIfUnstarted();
        if (this.rollingMax.hasValue()) {
            return this.rollingMax.getValue().intValue();
        }
        return 0L;
    }

    public Observable<Integer> observe() {
        return this.rollingMaxStream;
    }

    public void unsubscribe() {
        Subscription s = this.rollingMaxSubscription.get();
        if (s != null) {
            s.unsubscribe();
            this.rollingMaxSubscription.compareAndSet(s, null);
        }
    }
}

