/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.serial;

import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.sample.HystrixCommandUtilization;
import com.netflix.hystrix.metric.sample.HystrixThreadPoolUtilization;
import com.netflix.hystrix.metric.sample.HystrixUtilization;
import com.netflix.hystrix.serial.SerialHystrixMetric;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialHystrixUtilization
extends SerialHystrixMetric {
    private static final Logger logger = LoggerFactory.getLogger(SerialHystrixUtilization.class);

    @Deprecated
    public static byte[] toBytes(HystrixUtilization utilization) {
        throw new UnsupportedOperationException("Not implemented anymore.  Will be implemented in a new class shortly");
    }

    public static String toJsonString(HystrixUtilization utilization) {
        StringWriter jsonString = new StringWriter();
        try {
            JsonGenerator json = jsonFactory.createGenerator(jsonString);
            SerialHystrixUtilization.serializeUtilization(utilization, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return jsonString.getBuffer().toString();
    }

    private static void serializeUtilization(HystrixUtilization utilization, JsonGenerator json) {
        try {
            json.writeStartObject();
            json.writeStringField("type", "HystrixUtilization");
            json.writeObjectFieldStart("commands");
            for (Map.Entry<HystrixCommandKey, HystrixCommandUtilization> entry : utilization.getCommandUtilizationMap().entrySet()) {
                HystrixCommandKey key = entry.getKey();
                HystrixCommandUtilization commandUtilization = entry.getValue();
                SerialHystrixUtilization.writeCommandUtilizationJson(json, key, commandUtilization);
            }
            json.writeEndObject();
            json.writeObjectFieldStart("threadpools");
            for (Map.Entry<HystrixKey, Object> entry : utilization.getThreadPoolUtilizationMap().entrySet()) {
                HystrixThreadPoolKey threadPoolKey = (HystrixThreadPoolKey)entry.getKey();
                HystrixThreadPoolUtilization threadPoolUtilization = (HystrixThreadPoolUtilization)entry.getValue();
                SerialHystrixUtilization.writeThreadPoolUtilizationJson(json, threadPoolKey, threadPoolUtilization);
            }
            json.writeEndObject();
            json.writeEndObject();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static HystrixUtilization fromByteBuffer(ByteBuffer bb) {
        throw new UnsupportedOperationException("Not implemented anymore.  Will be implemented in a new class shortly");
    }

    private static void writeCommandUtilizationJson(JsonGenerator json, HystrixCommandKey key, HystrixCommandUtilization utilization) throws IOException {
        json.writeObjectFieldStart(key.name());
        json.writeNumberField("activeCount", utilization.getConcurrentCommandCount());
        json.writeEndObject();
    }

    private static void writeThreadPoolUtilizationJson(JsonGenerator json, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolUtilization utilization) throws IOException {
        json.writeObjectFieldStart(threadPoolKey.name());
        json.writeNumberField("activeCount", utilization.getCurrentActiveCount());
        json.writeNumberField("queueSize", utilization.getCurrentQueueSize());
        json.writeNumberField("corePoolSize", utilization.getCurrentCorePoolSize());
        json.writeNumberField("poolSize", utilization.getCurrentPoolSize());
        json.writeEndObject();
    }
}

