/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.processor;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.hystrix.processor.HystrixProcessorCommand;
import org.apache.camel.component.hystrix.processor.HystrixProcessorCommandFallbackViaNetwork;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Hystrix Processor")
public class HystrixProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixProcessor.class);
    private String id;
    private final HystrixCommandGroupKey groupKey;
    private final HystrixCommandKey commandKey;
    private final HystrixCommandKey fallbackCommandKey;
    private final HystrixCommand.Setter setter;
    private final HystrixCommand.Setter fallbackSetter;
    private final Processor processor;
    private final Processor fallback;
    private final boolean fallbackViaNetwork;

    public HystrixProcessor(HystrixCommandGroupKey groupKey, HystrixCommandKey commandKey, HystrixCommandKey fallbackCommandKey, HystrixCommand.Setter setter, HystrixCommand.Setter fallbackSetter, Processor processor, Processor fallback, boolean fallbackViaNetwork) {
        this.groupKey = groupKey;
        this.commandKey = commandKey;
        this.fallbackCommandKey = fallbackCommandKey;
        this.setter = setter;
        this.fallbackSetter = fallbackSetter;
        this.processor = processor;
        this.fallback = fallback;
        this.fallbackViaNetwork = fallbackViaNetwork;
    }

    @ManagedAttribute
    public String getHystrixCommandKey() {
        return this.commandKey.name();
    }

    @ManagedAttribute
    public String getHystrixFallbackCommandKey() {
        if (this.fallbackCommandKey != null) {
            return this.fallbackCommandKey.name();
        }
        return null;
    }

    @ManagedAttribute
    public String getHystrixGroupKey() {
        return this.groupKey.name();
    }

    @ManagedAttribute
    public boolean isFallbackViaNetwork() {
        return this.isFallbackViaNetwork();
    }

    @ManagedAttribute
    public int getHystrixTotalTimeMean() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getTotalTimeMean();
        }
        return 0;
    }

    @ManagedAttribute
    public int getHystrixExecutionTimeMean() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getExecutionTimeMean();
        }
        return 0;
    }

    @ManagedAttribute
    public int getHystrixCurrentConcurrentExecutionCount() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getCurrentConcurrentExecutionCount();
        }
        return 0;
    }

    @ManagedAttribute
    public long getHystrixTotalRequests() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getHealthCounts().getTotalRequests();
        }
        return 0L;
    }

    @ManagedAttribute
    public long getHystrixErrorCount() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getHealthCounts().getErrorCount();
        }
        return 0L;
    }

    @ManagedAttribute
    public int getHystrixErrorPercentage() {
        HystrixCommandMetrics metrics = HystrixCommandMetrics.getInstance(this.commandKey);
        if (metrics != null) {
            return metrics.getHealthCounts().getErrorPercentage();
        }
        return 0;
    }

    @ManagedAttribute
    public boolean isCircuitBreakerOpen() {
        HystrixCircuitBreaker cb = HystrixCircuitBreaker.Factory.getInstance(this.commandKey);
        if (cb != null) {
            return cb.isOpen();
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTraceLabel() {
        return "hystrix";
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add(this.processor);
        if (this.fallback != null) {
            answer.add(this.fallback);
        }
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.setProperty("TryRouteBlock", (Object)true);
        try {
            HystrixProcessorCommandFallbackViaNetwork fallbackCommand = null;
            if (this.fallbackViaNetwork) {
                fallbackCommand = new HystrixProcessorCommandFallbackViaNetwork(this.fallbackSetter, exchange, this.fallback);
            }
            HystrixProcessorCommand command = new HystrixProcessorCommand(this.setter, exchange, this.processor, this.fallback, fallbackCommand);
            command.execute();
            this.commandResponse(exchange, command);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        exchange.removeProperty("TryRouteBlock");
        callback.done(true);
        return true;
    }

    private void commandResponse(Exchange exchange, HystrixCommand command) {
        exchange.setProperty("CamelHystrixSuccessfulExecution", (Object)command.isSuccessfulExecution());
        exchange.setProperty("CamelHystrixResponseFromFallback", (Object)command.isResponseFromFallback());
        exchange.setProperty("CamelHystrixResponseShortCircuited", (Object)command.isResponseShortCircuited());
        exchange.setProperty("CamelHystrixResponseTimedOut", (Object)command.isResponseTimedOut());
        exchange.setProperty("CamelHystrixResponseRejected", (Object)command.isResponseRejected());
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

