/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.client;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.client.ClientConnection;
import org.apache.camel.component.iec60870.client.ClientEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public class ClientConsumer
extends DefaultConsumer {
    private final ClientConnection connection;
    private final ClientEndpoint endpoint;

    public ClientConsumer(ClientEndpoint endpoint, Processor processor, ClientConnection connection) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.connection = connection;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.connection.setListener(this.endpoint.getAddress(), this::updateValue);
    }

    @Override
    protected void doStop() throws Exception {
        this.connection.setListener(this.endpoint.getAddress(), null);
        super.doStop();
    }

    private void updateValue(ObjectAddress address, Value<?> value) {
        try {
            Exchange exchange = this.createExchange(true);
            this.configureMessage(exchange.getIn(), value);
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
        }
    }

    private void configureMessage(Message message, Value<?> value) {
        message.setBody(value);
        message.setHeader("CamelIec60870Value", value.getValue());
        message.setHeader("CamelIec60870Timestamp", value.getTimestamp());
        message.setHeader("CamelIec60870Quality", value.getQualityInformation());
        message.setHeader("CamelIec60870Overflow", value.isOverflow());
    }
}

