/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.iec60870.DiscardAckModule;
import org.apache.camel.component.iec60870.ObjectAddress;
import org.apache.camel.component.iec60870.server.ServerOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.Server;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModule;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.BackgroundModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.ChangeDataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.ChangeModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.model.WriteModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInstance {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInstance.class);
    private final ServerOptions options;
    private final DataModelImpl dataModel = new DataModelImpl();
    private Server server;
    private DataModule dataModule;
    private final InetSocketAddress address;
    private final Map<ObjectAddress, ServerObjectListener> listeners = new ConcurrentHashMap<ObjectAddress, ServerObjectListener>();

    public ServerInstance(String host, int port, ServerOptions options) throws UnknownHostException {
        this.options = options;
        this.address = new InetSocketAddress(InetAddress.getByName(host), port);
    }

    public void start() {
        this.dataModel.start();
        this.dataModule = new DataModule(this.options.getDataModuleOptions(), this.dataModel);
        this.server = new Server(this.address, this.options.getProtocolOptions(), Arrays.asList(this.dataModule, new DiscardAckModule()));
    }

    public void stop() {
        Exception e;
        LinkedList<Exception> ex = new LinkedList<Exception>();
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception e2) {
                ex.add(e2);
            }
            this.server = null;
        }
        if (this.dataModule != null) {
            try {
                this.dataModule.dispose();
            }
            catch (Exception e3) {
                ex.add(e3);
            }
            this.dataModule = null;
        }
        if ((e = (Exception)ex.pollFirst()) != null) {
            RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeCamelException(e);
            ex.forEach(re::addSuppressed);
            throw re;
        }
    }

    private WriteModel.Action prepareAction(WriteModel.Request<?> request) {
        ObjectAddress address = ObjectAddress.valueOf(request.getHeader().getAsduAddress(), request.getAddress());
        ServerObjectListener listener = this.listeners.get(address);
        if (listener == null) {
            return null;
        }
        return () -> listener.execute(request);
    }

    public void setListener(ObjectAddress address, ServerObjectListener listener) {
        Objects.requireNonNull(address);
        if (listener != null) {
            this.listeners.put(address, listener);
        } else {
            this.listeners.remove(address);
        }
    }

    public void notifyValue(ObjectAddress address, Value<?> value) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(value);
        this.dataModel.notifyDataChange(address.getASDUAddress(), address.getInformationObjectAddress(), value, true);
    }

    @FunctionalInterface
    public static interface ServerObjectListener {
        public CompletionStage<Void> execute(WriteModel.Request<?> var1);
    }

    private final class DataModelImpl
    extends ChangeDataModel {
        private DataModelImpl() {
            super("Camel/IEC60870/DataModel");
        }

        @Override
        protected ChangeModel createChangeModel() {
            if (ServerInstance.this.options.getBufferingPeriod() != null && ServerInstance.this.options.getBufferingPeriod() > 0) {
                LOG.info("Creating buffering change model: {} ms", (Object)ServerInstance.this.options.getBufferingPeriod());
                return this.makeBufferingChangeModel(ServerInstance.this.options.getBufferingPeriod().intValue());
            }
            LOG.info("Creating instant change model");
            return this.makeInstantChangeModel();
        }

        @Override
        protected WriteModel createWriteModel() {
            return new WriteModel(){

                @Override
                public WriteModel.Action prepareCommand(WriteModel.Request<Boolean> request) {
                    return ServerInstance.this.prepareAction(request);
                }

                @Override
                public WriteModel.Action prepareSetpointFloat(WriteModel.Request<Float> request) {
                    return ServerInstance.this.prepareAction(request);
                }

                @Override
                public WriteModel.Action prepareSetpointScaled(WriteModel.Request<Short> request) {
                    return ServerInstance.this.prepareAction(request);
                }
            };
        }

        @Override
        protected BackgroundModel createBackgroundModel() {
            if (ServerInstance.this.options.getBackgroundScanPeriod() > 0) {
                LOG.info("Creating background scan model: {} ms", (Object)ServerInstance.this.options.getBackgroundScanPeriod());
                return this.makeDefaultBackgroundModel();
            }
            LOG.info("Not creating background scan model");
            return null;
        }

        @Override
        public void notifyDataChange(ASDUAddress asduAddress, InformationObjectAddress informationObjectAddress, Value<?> value, boolean notify) {
            super.notifyDataChange(asduAddress, informationObjectAddress, value, notify);
        }
    }
}

