/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu;

import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.neoscada.protocol.iec60870.asdu.Dumpable;
import org.eclipse.neoscada.protocol.iec60870.asdu.DumperHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.scada.utils.ExceptionHelper;

public class Dumper {
    private final PrintWriter buffer;
    private final int level;

    public Dumper(PrintWriter buffer) {
        this(buffer, 0);
    }

    protected Dumper(PrintWriter buffer, int level) {
        this.buffer = buffer;
        this.level = level;
    }

    public void field(String fieldName, Object value) {
        this.indent(1);
        this.buffer.format("%s : ", fieldName);
        if (value instanceof Dumpable) {
            DumperHelper.dump((Dumpable)value, this.createChild());
        } else if (value instanceof Collection) {
            Collection col = (Collection)value;
            switch (col.size()) {
                case 0: {
                    this.buffer.print("<empty>");
                    break;
                }
                case 1: {
                    this.buffer.print(value);
                    break;
                }
                default: {
                    this.buffer.println("[");
                    for (Object o : col) {
                        this.indent(2);
                        this.buffer.println(o);
                    }
                    this.indent(1);
                    this.buffer.print("]");
                    break;
                }
            }
        } else {
            this.buffer.print(value);
        }
        this.buffer.println();
    }

    private void indent(int offset) {
        int i = 0;
        while (i < this.level + offset) {
            this.buffer.print("  ");
            ++i;
        }
    }

    public void start(Dumpable object) {
        this.indent(0);
        this.buffer.append(object.getClass().getName());
        ASDU asdu = object.getClass().getAnnotation(ASDU.class);
        if (asdu != null) {
            this.buffer.format("(%s=%s)", asdu.name(), asdu.id() & 0xFF);
        }
        this.buffer.println();
        this.indent(0);
        this.buffer.println("----- START ----");
    }

    public void end() {
        this.indent(0);
        this.buffer.print("-----  END  ----");
    }

    public Dumper createChild() {
        return new Dumper(this.buffer, this.level + 1);
    }

    protected void fields(Class<?> clazz, Object object, Set<Class<?>> classes) {
        if (clazz == null) {
            return;
        }
        if (classes.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        this.fields(clazz.getSuperclass(), object, classes);
        AnnotatedElement[] annotatedElementArray = clazz.getInterfaces();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = annotatedElementArray[n2];
            this.fields(iface, object, classes);
            ++n2;
        }
        annotatedElementArray = clazz.getDeclaredFields();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement field = annotatedElementArray[n2];
            if (!Modifier.isStatic(((Field)field).getModifiers())) {
                try {
                    boolean changed = false;
                    if (!((AccessibleObject)field).isAccessible()) {
                        changed = true;
                        ((Field)field).setAccessible(true);
                    }
                    try {
                        this.field(((Field)field).getName(), ((Field)field).get(object));
                    }
                    finally {
                        if (changed) {
                            ((Field)field).setAccessible(false);
                        }
                    }
                }
                catch (Exception e) {
                    this.field(((Field)field).getName(), String.format("<EXCEPTION: %s>", ExceptionHelper.getMessage(e)));
                }
            }
            ++n2;
        }
    }

    public void fields(Object object) {
        this.fields(object.getClass(), object, new HashSet());
    }
}

