/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CustomCause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;

public final class Causes {
    private static final Cause[] causes = new Cause[64];

    static {
        StandardCause[] standardCauseArray = StandardCause.values();
        int n = standardCauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardCause cause = standardCauseArray[n2];
            Causes.causes[cause.getValue()] = cause;
            ++n2;
        }
        int i = 14;
        while (i < 20) {
            Causes.causes[i] = new CustomCause(i);
            ++i;
        }
        i = 42;
        while (i < 44) {
            Causes.causes[i] = new CustomCause(i);
            ++i;
        }
        i = 49;
        while (i < 64) {
            Causes.causes[i] = new CustomCause(i);
            ++i;
        }
    }

    private Causes() {
    }

    public static Cause valueOf(int value) {
        return causes[value];
    }

    public static boolean isInterrogation(Cause cause) {
        short value = cause.getValue();
        return value >= StandardCause.STATION_REQUEST.getValue() && value <= StandardCause.GROUP_REQUEST_9.getValue();
    }
}

