/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.apci.APDUDecoder;
import org.eclipse.neoscada.protocol.iec60870.apci.APDUEncoder;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageChannel;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageManager;
import org.eclipse.neoscada.protocol.iec60870.server.ServerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final ServerBootstrap bootstrap;
    private final Channel channel;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerModule[] modules;
    private final ProtocolOptions options;
    private final MessageManager manager;

    public Server(short port, ProtocolOptions options, List<ServerModule> modules) {
        this(0xFFFF & port, options, modules);
    }

    public Server(int port, ProtocolOptions options, List<ServerModule> modules) {
        this(new InetSocketAddress(port), options, modules);
    }

    public Server(SocketAddress address, ProtocolOptions options, List<ServerModule> modules) {
        this.options = options;
        this.manager = new MessageManager(this.options);
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group(this.bossGroup, this.workerGroup);
        this.bootstrap.channel(NioServerSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_BACKLOG, 5);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, true);
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                Server.this.handleInitChannel(ch);
            }
        });
        this.modules = modules.toArray(new ServerModule[modules.size()]);
        for (ServerModule module : modules) {
            module.initializeServer(this, this.manager);
        }
        this.channel = this.bootstrap.bind(address).channel();
    }

    public Server(short port, List<ServerModule> modules) {
        this(0xFFFF & port, modules);
    }

    public Server(int port, List<ServerModule> modules) {
        this(port, new ProtocolOptions.Builder().build(), modules);
    }

    protected void handleInitChannel(SocketChannel ch) {
        ch.pipeline().addLast(new APDUDecoder());
        ch.pipeline().addLast(new APDUEncoder());
        if (Boolean.getBoolean("org.eclipse.scada.protocol.iec60870.trace")) {
            ch.pipeline().addLast(new LoggingHandler(LogLevel.TRACE));
        }
        MessageChannel messageChannel = new MessageChannel(this.options, this.manager);
        ch.pipeline().addLast(messageChannel);
        ServerModule[] serverModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            ServerModule module = serverModuleArray[n2];
            module.initializeChannel(ch, messageChannel);
            ++n2;
        }
        ch.pipeline().addLast(new ChannelDuplexHandler(){

            @Override
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                logger.warn("Close connection due to uncaught exception", cause);
                ctx.close();
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.channel.close();
        ServerModule[] serverModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            ServerModule module = serverModuleArray[n2];
            module.dispose();
            ++n2;
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }
}

