/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite;

import java.io.InputStream;
import java.net.URL;
import org.apache.camel.impl.DefaultComponent;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;

public abstract class AbstractIgniteComponent
extends DefaultComponent {
    private IgniteConfiguration igniteConfiguration;
    private Object configurationResource;
    private Ignite ignite;
    private IgniteLifecycleMode lifecycleMode = IgniteLifecycleMode.COMPONENT_MANAGED;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (this.lifecycleMode == IgniteLifecycleMode.USER_MANAGED) {
            return;
        }
        if (this.configurationResource != null) {
            if (this.configurationResource instanceof URL) {
                this.ignite = Ignition.start((URL)this.configurationResource);
                return;
            } else if (this.configurationResource instanceof InputStream) {
                this.ignite = Ignition.start((InputStream)this.configurationResource);
                return;
            } else {
                if (!(this.configurationResource instanceof String)) throw new IllegalStateException("An unsupported configuration resource was provided to the Ignite component. Supported types are: URL, InputStream, String.");
                this.ignite = Ignition.start((String)this.configurationResource);
            }
            return;
        } else {
            if (this.igniteConfiguration == null) throw new IllegalStateException("No configuration resource or IgniteConfiguration was provided to the Ignite component.");
            this.ignite = Ignition.start(this.igniteConfiguration);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.lifecycleMode == IgniteLifecycleMode.USER_MANAGED) {
            return;
        }
        if (this.ignite != null) {
            this.ignite.close();
        }
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public void setIgnite(Ignite ignite) {
        this.ignite = ignite;
        this.lifecycleMode = IgniteLifecycleMode.USER_MANAGED;
    }

    public Object getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(Object configurationResource) {
        this.configurationResource = configurationResource;
    }

    public IgniteConfiguration getIgniteConfiguration() {
        return this.igniteConfiguration;
    }

    public void setIgniteConfiguration(IgniteConfiguration igniteConfiguration) {
        this.igniteConfiguration = igniteConfiguration;
    }

    public static enum IgniteLifecycleMode {
        USER_MANAGED,
        COMPONENT_MANAGED;

    }
}

