/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ignite.set;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ignite.set.IgniteSetEndpoint;
import org.apache.camel.component.ignite.set.IgniteSetOperation;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.ignite.IgniteSet;

public class IgniteSetProducer
extends DefaultAsyncProducer {
    private IgniteSetEndpoint endpoint;
    private IgniteSet<Object> set;

    public IgniteSetProducer(IgniteSetEndpoint endpoint, IgniteSet<Object> set) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.set = set;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)out, (boolean)true);
        Object body = in.getBody();
        switch (this.setOperationFor(exchange)) {
            case ADD: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.set.addAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.set.add(body));
                break;
            }
            case CONTAINS: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.set.containsAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.set.contains(body));
                break;
            }
            case SIZE: {
                out.setBody((Object)this.set.size());
                break;
            }
            case REMOVE: {
                if (Collection.class.isAssignableFrom(body.getClass()) && !this.endpoint.isTreatCollectionsAsCacheObjects()) {
                    out.setBody((Object)this.set.removeAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.set.remove(body));
                break;
            }
            case CLEAR: {
                if (this.endpoint.isPropagateIncomingBodyIfNoReturnValue()) {
                    out.setBody(body);
                }
                this.set.clear();
                break;
            }
            case ITERATOR: {
                Iterator<Object> iterator = this.set.iterator();
                out.setBody(iterator);
                break;
            }
            case ARRAY: {
                out.setBody((Object)this.set.toArray());
                break;
            }
            case RETAIN_ALL: {
                if (Collection.class.isAssignableFrom(body.getClass())) {
                    out.setBody((Object)this.set.retainAll((Collection)body));
                    break;
                }
                out.setBody((Object)this.set.retainAll(Collections.singleton(body)));
                break;
            }
            default: {
                exchange.setException((Throwable)new UnsupportedOperationException("Operation not supported by Ignite Set producer."));
                return true;
            }
        }
        return true;
    }

    private IgniteSetOperation setOperationFor(Exchange exchange) {
        return (IgniteSetOperation)((Object)exchange.getIn().getHeader("CamelIgniteSetsOperation", (Object)this.endpoint.getOperation(), IgniteSetOperation.class));
    }
}

