/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.IgfsMetrics;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsOutputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathSummary;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.igfs.mapreduce.IgfsTask;
import org.apache.ignite.lang.IgniteAsyncSupport;
import org.apache.ignite.lang.IgniteAsyncSupported;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public interface IgniteFileSystem
extends IgniteAsyncSupport {
    public static final String IGFS_SCHEME = "igfs";

    public String name();

    public FileSystemConfiguration configuration();

    public IgfsPathSummary summary(IgfsPath var1) throws IgniteException;

    public IgfsInputStream open(IgfsPath var1) throws IgniteException;

    public IgfsInputStream open(IgfsPath var1, int var2) throws IgniteException;

    public IgfsInputStream open(IgfsPath var1, int var2, int var3) throws IgniteException;

    public IgfsOutputStream create(IgfsPath var1, boolean var2) throws IgniteException;

    public IgfsOutputStream create(IgfsPath var1, int var2, boolean var3, int var4, long var5, @Nullable Map<String, String> var7) throws IgniteException;

    public IgfsOutputStream create(IgfsPath var1, int var2, boolean var3, @Nullable IgniteUuid var4, int var5, long var6, @Nullable Map<String, String> var8) throws IgniteException;

    public IgfsOutputStream append(IgfsPath var1, boolean var2) throws IgniteException;

    public IgfsOutputStream append(IgfsPath var1, int var2, boolean var3, @Nullable Map<String, String> var4) throws IgniteException;

    public void setTimes(IgfsPath var1, long var2, long var4) throws IgniteException;

    public Collection<IgfsBlockLocation> affinity(IgfsPath var1, long var2, long var4) throws IgniteException;

    public Collection<IgfsBlockLocation> affinity(IgfsPath var1, long var2, long var4, long var6) throws IgniteException;

    public IgfsMetrics metrics() throws IgniteException;

    public void resetMetrics() throws IgniteException;

    public long size(IgfsPath var1) throws IgniteException;

    @IgniteAsyncSupported
    public void format() throws IgniteException;

    @IgniteAsyncSupported
    public <T, R> R execute(IgfsTask<T, R> var1, @Nullable IgfsRecordResolver var2, Collection<IgfsPath> var3, @Nullable T var4) throws IgniteException;

    @IgniteAsyncSupported
    public <T, R> R execute(IgfsTask<T, R> var1, @Nullable IgfsRecordResolver var2, Collection<IgfsPath> var3, boolean var4, long var5, @Nullable T var7) throws IgniteException;

    @IgniteAsyncSupported
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> var1, @Nullable IgfsRecordResolver var2, Collection<IgfsPath> var3, @Nullable T var4) throws IgniteException;

    @IgniteAsyncSupported
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> var1, @Nullable IgfsRecordResolver var2, Collection<IgfsPath> var3, boolean var4, long var5, @Nullable T var7) throws IgniteException;

    public boolean exists(IgfsPath var1);

    public IgfsFile update(IgfsPath var1, Map<String, String> var2) throws IgniteException;

    public void rename(IgfsPath var1, IgfsPath var2) throws IgniteException;

    public boolean delete(IgfsPath var1, boolean var2) throws IgniteException;

    public void mkdirs(IgfsPath var1) throws IgniteException;

    public void mkdirs(IgfsPath var1, @Nullable Map<String, String> var2) throws IgniteException;

    public Collection<IgfsPath> listPaths(IgfsPath var1) throws IgniteException;

    public Collection<IgfsFile> listFiles(IgfsPath var1) throws IgniteException;

    @Nullable
    public IgfsFile info(IgfsPath var1) throws IgniteException;

    public IgfsMode mode(IgfsPath var1);

    public long usedSpaceSize() throws IgniteException;

    @Override
    public IgniteFileSystem withAsync();
}

