/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.binary;

import java.util.HashMap;
import org.apache.ignite.binary.BinaryAbstractIdentityResolver;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryFieldImpl;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryFieldIdentityResolver
extends BinaryAbstractIdentityResolver {
    private final Object mux = new Object();
    private volatile FieldAccessor accessor;
    private volatile HashMap<Long, FieldAccessor> accessors;
    private String[] fieldNames;

    public BinaryFieldIdentityResolver() {
    }

    public BinaryFieldIdentityResolver(BinaryFieldIdentityResolver other) {
        this.fieldNames = other.fieldNames;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public BinaryFieldIdentityResolver setFieldNames(String ... fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    @Override
    public int hashCode0(BinaryObject obj) {
        if (obj instanceof BinaryObjectExImpl) {
            BinaryObjectExImpl obj0 = (BinaryObjectExImpl)obj;
            if (obj0.hasSchema()) {
                FieldAccessor accessor = this.accessor(obj0, obj0.typeId(), obj0.schemaId());
                assert (accessor != null);
                return accessor.hashCode(obj0);
            }
        } else if (obj instanceof BinaryEnumObjectImpl) {
            throw new BinaryObjectException("Field identity resolver cannot be used with enums: " + obj);
        }
        int hash = 0;
        for (String fieldName : this.fieldNames) {
            Object val = obj.field(fieldName);
            hash = 31 * hash + (val != null ? val.hashCode() : 0);
        }
        return hash;
    }

    @Override
    public boolean equals0(BinaryObject o1, BinaryObject o2) {
        if (o1 instanceof BinaryObjectExImpl && o2 instanceof BinaryObjectExImpl) {
            BinaryObjectExImpl ex1 = (BinaryObjectExImpl)o1;
            BinaryObjectExImpl ex2 = (BinaryObjectExImpl)o2;
            int typeId = ex1.typeId();
            if (typeId != ex2.typeId()) {
                return false;
            }
            if (ex1.hasSchema() && ex2.hasSchema()) {
                int schemaId1 = ex1.schemaId();
                int schemaId2 = ex2.schemaId();
                FieldAccessor accessor1 = this.accessor(ex1, typeId, schemaId1);
                FieldAccessor accessor2 = schemaId1 == schemaId2 ? accessor1 : this.accessor(ex2, typeId, schemaId2);
                BinarySerializedFieldComparator comp1 = ex1.createFieldComparator();
                BinarySerializedFieldComparator comp2 = ex2.createFieldComparator();
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    comp1.findField(accessor1.orders[i]);
                    comp2.findField(accessor2.orders[i]);
                    if (BinarySerializedFieldComparator.equals(comp1, comp2)) continue;
                    return false;
                }
                return true;
            }
            return this.equalsSlow(ex1, ex2);
        }
        if (o1 instanceof BinaryEnumObjectImpl) {
            throw new BinaryObjectException("Field identity resolver cannot be used with enums: " + o1);
        }
        if (o2 instanceof BinaryEnumObjectImpl) {
            throw new BinaryObjectException("Field identity resolver cannot be used with enums: " + o2);
        }
        return o1.type().typeId() == o2.type().typeId() && this.equalsSlow(o1, o2);
    }

    private boolean equalsSlow(BinaryObject o1, BinaryObject o2) {
        for (String fieldName : this.fieldNames) {
            Object val2;
            Object val1 = o1.field(fieldName);
            if (F.eq(val1, val2 = o2.field(fieldName))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldAccessor accessor(BinaryObjectExImpl obj, int typId, int schemaId) {
        FieldAccessor res = this.accessor;
        if (res != null && res.applicableTo(typId, schemaId)) {
            return res;
        }
        long key = ((long)typId << 32) + (long)schemaId;
        HashMap<Long, FieldAccessor> accessors0 = this.accessors;
        if (accessors0 != null && (res = accessors0.get(key)) != null) {
            return res;
        }
        Object object = this.mux;
        synchronized (object) {
            int[] orders = new int[this.fieldNames.length];
            BinaryType type = obj.type();
            for (int i = 0; i < this.fieldNames.length; ++i) {
                BinaryFieldImpl field = (BinaryFieldImpl)type.field(this.fieldNames[i]);
                orders[i] = field.fieldOrder(obj);
            }
            res = new FieldAccessor(typId, schemaId, orders);
            if (this.accessor == null) {
                this.accessor = res;
            } else {
                if (this.accessors == null) {
                    this.accessor = null;
                    accessors0 = new HashMap();
                } else {
                    accessors0 = new HashMap<Long, FieldAccessor>(this.accessors);
                }
                accessors0.put(key, res);
                this.accessors = accessors0;
            }
        }
        return res;
    }

    public String toString() {
        return S.toString(BinaryFieldIdentityResolver.class, this);
    }

    private static class FieldAccessor {
        private final int typeId;
        private final int schemaId;
        private final int[] orders;

        private FieldAccessor(int typeId, int schemaId, int[] orders) {
            this.typeId = typeId;
            this.schemaId = schemaId;
            this.orders = orders;
        }

        private boolean applicableTo(int expTypeId, int expSchemaId) {
            return this.typeId == expTypeId && this.schemaId == expSchemaId;
        }

        private int hashCode(BinaryObjectExImpl obj) {
            int hash = 0;
            for (int order : this.orders) {
                Object val = obj.fieldByOrder(order);
                hash = 31 * hash + (val != null ? val.hashCode() : 0);
            }
            return hash;
        }
    }
}

