/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;

public class QueryEntity
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String keyType;
    private String valType;
    private LinkedHashMap<String, String> fields = new LinkedHashMap();
    private Set<String> keyFields;
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, QueryIndex> idxs = new HashMap<String, QueryIndex>();
    private String tableName;

    public QueryEntity() {
    }

    public QueryEntity(String keyType, String valType) {
        this.keyType = keyType;
        this.valType = valType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getValueType() {
        return this.valType;
    }

    public void setValueType(String valType) {
        this.valType = valType;
    }

    public LinkedHashMap<String, String> getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashMap<String, String> fields) {
        this.fields = fields;
    }

    public Set<String> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(Set<String> keyFields) {
        this.keyFields = keyFields;
    }

    public Collection<QueryIndex> getIndexes() {
        return this.idxs.values();
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public void setIndexes(Collection<QueryIndex> idxs) {
        for (QueryIndex idx : idxs) {
            if (F.isEmpty(idx.getFields())) continue;
            if (idx.getName() == null) {
                idx.setName(QueryEntity.defaultIndexName(idx));
            }
            if (!this.idxs.containsKey(idx.getName())) {
                this.idxs.put(idx.getName(), idx);
                continue;
            }
            throw new IllegalArgumentException("Duplicate index name: " + idx.getName());
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addQueryField(String fullName, String type, String alias) {
        A.notNull(fullName, "fullName");
        A.notNull(type, "type");
        this.fields.put(fullName, type);
        if (alias != null) {
            this.aliases.put(fullName, alias);
        }
    }

    public void ensureIndex(String idxName, QueryIndexType idxType) {
        QueryIndex idx = this.idxs.get(idxName);
        if (idx != null) {
            throw new IllegalArgumentException("An index with the same name and of a different type already exists [idxName=" + idxName + ", existingIdxType=" + (Object)((Object)idx.getIndexType()) + ", newIdxType=" + (Object)((Object)idxType) + ']');
        }
        idx = new QueryIndex();
        idx.setName(idxName);
        idx.setIndexType(idxType);
        this.idxs.put(idxName, idx);
    }

    public static String defaultIndexName(QueryIndex idx) {
        StringBuilder idxName = new StringBuilder();
        for (Map.Entry<String, Boolean> field : idx.getFields().entrySet()) {
            idxName.append(field.getKey());
            idxName.append('_');
            idxName.append(field.getValue() != false ? "asc_" : "desc_");
        }
        for (int i = 0; i < idxName.length(); ++i) {
            char ch = idxName.charAt(i);
            if (Character.isWhitespace(ch)) {
                idxName.setCharAt(i, '_');
                continue;
            }
            idxName.setCharAt(i, Character.toLowerCase(ch));
        }
        idxName.append("idx");
        return idxName.toString();
    }
}

