/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.ignite.cache.QueryIndexType;

public class QueryIndex
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String name;
    private LinkedHashMap<String, Boolean> fields;
    private QueryIndexType type;

    public QueryIndex() {
    }

    public QueryIndex(String field) {
        this(field, QueryIndexType.SORTED, true);
    }

    public QueryIndex(String field, boolean asc) {
        this(field, QueryIndexType.SORTED, asc);
    }

    public QueryIndex(String field, boolean asc, String name) {
        this(field, QueryIndexType.SORTED, asc);
        this.name = name;
    }

    public QueryIndex(String field, QueryIndexType type) {
        this(Arrays.asList(field), type);
    }

    public QueryIndex(String field, QueryIndexType type, boolean asc) {
        this.fields = new LinkedHashMap();
        this.fields.put(field, asc);
        this.type = type;
    }

    public QueryIndex(String field, QueryIndexType type, boolean asc, String name) {
        this.fields = new LinkedHashMap();
        this.fields.put(field, asc);
        this.type = type;
        this.name = name;
    }

    public QueryIndex(Collection<String> fields, QueryIndexType type) {
        this.fields = new LinkedHashMap();
        for (String field : fields) {
            this.fields.put(field, true);
        }
        this.type = type;
    }

    public QueryIndex(LinkedHashMap<String, Boolean> fields, QueryIndexType type) {
        this.fields = fields;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkedHashMap<String, Boolean> getFields() {
        return this.fields;
    }

    public void setFields(LinkedHashMap<String, Boolean> fields) {
        this.fields = fields;
    }

    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    public void setFieldNames(Collection<String> fields, boolean asc) {
        this.fields = new LinkedHashMap();
        for (String field : fields) {
            this.fields.put(field, asc);
        }
    }

    public QueryIndexType getIndexType() {
        return this.type;
    }

    public void setIndexType(QueryIndexType type) {
        this.type = type;
    }
}

