/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.fair;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.UUID;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityCentralizedFunction;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@AffinityCentralizedFunction
public class FairAffinityFunction
implements AffinityFunction {
    public static final int DFLT_PART_CNT = 256;
    private static final long serialVersionUID = 0L;
    private static final Comparator<PartitionSet> ASC_CMP = new PartitionSetComparator();
    private static final Comparator<PartitionSet> DESC_CMP = Collections.reverseOrder(ASC_CMP);
    private int parts;
    private boolean exclNeighbors;
    private transient boolean exclNeighborsWarn;
    @LoggerResource
    private transient IgniteLogger log;
    private IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter;
    private IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter;

    public FairAffinityFunction() {
        this(false);
    }

    public FairAffinityFunction(boolean exclNeighbors) {
        this(exclNeighbors, 256);
    }

    public FairAffinityFunction(int parts) {
        this(false, parts);
    }

    public FairAffinityFunction(boolean exclNeighbors, int parts) {
        this(exclNeighbors, parts, null);
    }

    public FairAffinityFunction(int parts, @Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this(false, parts, backupFilter);
    }

    private FairAffinityFunction(boolean exclNeighbors, int parts, IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        A.ensure(parts > 0, "parts > 0");
        this.exclNeighbors = exclNeighbors;
        this.parts = parts;
        this.backupFilter = backupFilter;
    }

    public int getPartitions() {
        return this.parts;
    }

    public void setPartitions(int parts) {
        A.ensure(parts <= 16384, "parts <= 16384");
        this.parts = parts;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, ClusterNode> getBackupFilter() {
        return this.backupFilter;
    }

    @Deprecated
    public void setBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this.backupFilter = backupFilter;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, List<ClusterNode>> getAffinityBackupFilter() {
        return this.affinityBackupFilter;
    }

    public void setAffinityBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter) {
        this.affinityBackupFilter = affinityBackupFilter;
    }

    public boolean isExcludeNeighbors() {
        return this.exclNeighbors;
    }

    public void setExcludeNeighbors(boolean exclNeighbors) {
        this.exclNeighbors = exclNeighbors;
    }

    @Override
    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext ctx) {
        List<ClusterNode> topSnapshot = ctx.currentTopologySnapshot();
        if (topSnapshot.size() == 1) {
            ClusterNode primary = topSnapshot.get(0);
            return Collections.nCopies(this.parts, Collections.singletonList(primary));
        }
        Map<UUID, Collection<ClusterNode>> neighborhoodMap = this.exclNeighbors ? GridCacheUtils.neighbors(ctx.currentTopologySnapshot()) : null;
        List<List<ClusterNode>> assignment = this.createCopy(ctx, neighborhoodMap);
        int backups = ctx.backups();
        int tiers = backups == Integer.MAX_VALUE ? topSnapshot.size() : Math.min(backups + 1, topSnapshot.size());
        HashMap<Integer, Queue<Integer>> pendingParts = new HashMap<Integer, Queue<Integer>>();
        FullAssignmentMap fullMap = new FullAssignmentMap(tiers, assignment, topSnapshot, neighborhoodMap);
        for (int tier = 0; tier < tiers; ++tier) {
            LinkedList<Integer> pending = (LinkedList<Integer>)pendingParts.get(tier);
            for (int part = 0; part < this.parts; ++part) {
                if (((List)fullMap.assignments.get(part)).size() >= tier + 1) continue;
                if (pending == null) {
                    pending = new LinkedList<Integer>();
                    pendingParts.put(tier, pending);
                }
                if (pending.contains(part)) continue;
                pending.add(part);
            }
            this.assignPending(tier, pendingParts, fullMap, topSnapshot, false);
            boolean balanced = this.balance(tier, pendingParts, fullMap, topSnapshot, false);
            if (balanced || !this.exclNeighbors) continue;
            this.assignPending(tier, pendingParts, fullMap, topSnapshot, true);
            this.balance(tier, pendingParts, fullMap, topSnapshot, true);
            if (this.exclNeighborsWarn) continue;
            LT.warn(this.log, "Affinity function excludeNeighbors property is ignored because topology has no enough nodes to assign backups.");
            this.exclNeighborsWarn = true;
        }
        return fullMap.assignments;
    }

    @Override
    public void reset() {
    }

    @Override
    public int partitions() {
        return this.parts;
    }

    @Override
    public int partition(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key is passed for a partition calculation. Make sure that an affinity key that is used is initialized properly.");
        }
        return U.safeAbs(FairAffinityFunction.hash(key.hashCode())) % this.parts;
    }

    @Override
    public void removeNode(UUID nodeId) {
    }

    private void assignPending(int tier, Map<Integer, Queue<Integer>> pendingMap, FullAssignmentMap fullMap, List<ClusterNode> topSnapshot, boolean allowNeighbors) {
        Queue<Integer> pending = pendingMap.get(tier);
        if (F.isEmpty(pending)) {
            return;
        }
        int idealPartCnt = this.parts / topSnapshot.size();
        Map<UUID, PartitionSet> tierMapping = fullMap.tierMapping(tier);
        PrioritizedPartitionMap underloadedNodes = this.filterNodes(tierMapping, idealPartCnt, false);
        this.assignPendingToUnderloaded(tier, pendingMap, fullMap, underloadedNodes, topSnapshot, false, allowNeighbors);
        if (!pending.isEmpty() && !underloadedNodes.isEmpty()) {
            this.assignPendingToUnderloaded(tier, pendingMap, fullMap, underloadedNodes, topSnapshot, true, allowNeighbors);
        }
        if (!pending.isEmpty()) {
            this.assignPendingToNodes(tier, pendingMap, fullMap, topSnapshot, allowNeighbors);
        }
        if (pending.isEmpty()) {
            pendingMap.remove(tier);
        }
    }

    private void assignPendingToUnderloaded(int tier, Map<Integer, Queue<Integer>> pendingMap, FullAssignmentMap fullMap, PrioritizedPartitionMap underloadedNodes, Collection<ClusterNode> topSnapshot, boolean force, boolean allowNeighbors) {
        Iterator it = pendingMap.get(tier).iterator();
        int ideal = this.parts / topSnapshot.size();
        while (it.hasNext()) {
            int part = (Integer)it.next();
            for (PartitionSet set : underloadedNodes.assignments()) {
                ClusterNode node = set.node();
                assert (node != null);
                if (!fullMap.assign(part, tier, node, pendingMap, force, allowNeighbors)) continue;
                it.remove();
                if (set.size() <= ideal) {
                    underloadedNodes.remove(set.nodeId());
                    break;
                }
                underloadedNodes.update();
                break;
            }
            if (!underloadedNodes.isEmpty()) continue;
            return;
        }
    }

    private void assignPendingToNodes(int tier, Map<Integer, Queue<Integer>> pendingMap, FullAssignmentMap fullMap, List<ClusterNode> topSnapshot, boolean allowNeighbors) {
        Iterator it = pendingMap.get(tier).iterator();
        int idx = 0;
        while (it.hasNext()) {
            ClusterNode node;
            int part = (Integer)it.next();
            int i = idx;
            boolean assigned = false;
            do {
                if (fullMap.assign(part, tier, node = topSnapshot.get(i), pendingMap, false, allowNeighbors)) {
                    it.remove();
                    assigned = true;
                }
                i = (i + 1) % topSnapshot.size();
                if (!assigned) continue;
                idx = i;
            } while (i != idx);
            if (!assigned) {
                do {
                    if (fullMap.assign(part, tier, node = topSnapshot.get(i), pendingMap, true, allowNeighbors)) {
                        it.remove();
                        assigned = true;
                    }
                    i = (i + 1) % topSnapshot.size();
                    if (!assigned) continue;
                    idx = i;
                } while (i != idx);
            }
            if (assigned || this.exclNeighbors && (!this.exclNeighbors || !allowNeighbors)) continue;
            throw new IllegalStateException("Failed to find assignable node for partition.");
        }
    }

    private boolean balance(int tier, Map<Integer, Queue<Integer>> pendingParts, FullAssignmentMap fullMap, Collection<ClusterNode> topSnapshot, boolean allowNeighbors) {
        boolean retry;
        int idealPartCnt = this.parts / topSnapshot.size();
        Map<UUID, PartitionSet> mapping = fullMap.tierMapping(tier);
        PrioritizedPartitionMap underloadedNodes = this.filterNodes(mapping, idealPartCnt, false);
        PrioritizedPartitionMap overloadedNodes = this.filterNodes(mapping, idealPartCnt, true);
        block0: do {
            retry = false;
            for (PartitionSet overloaded : overloadedNodes.assignments()) {
                for (Integer part : overloaded.partitions()) {
                    boolean assigned = false;
                    for (PartitionSet underloaded : underloadedNodes.assignments()) {
                        if (!fullMap.assign(part, tier, underloaded.node(), pendingParts, false, allowNeighbors)) continue;
                        if (overloaded.size() <= idealPartCnt) {
                            overloadedNodes.remove(overloaded.nodeId());
                        } else {
                            overloadedNodes.update();
                        }
                        if (underloaded.size() >= idealPartCnt) {
                            underloadedNodes.remove(underloaded.nodeId());
                        } else {
                            underloadedNodes.update();
                        }
                        assigned = true;
                        retry = true;
                        break;
                    }
                    if (!assigned) {
                        for (PartitionSet underloaded : underloadedNodes.assignments()) {
                            if (!fullMap.assign(part, tier, underloaded.node(), pendingParts, true, allowNeighbors)) continue;
                            if (overloaded.size() <= idealPartCnt) {
                                overloadedNodes.remove(overloaded.nodeId());
                            } else {
                                overloadedNodes.update();
                            }
                            if (underloaded.size() >= idealPartCnt) {
                                underloadedNodes.remove(underloaded.nodeId());
                            } else {
                                underloadedNodes.update();
                            }
                            retry = true;
                            break;
                        }
                    }
                    if (!retry) continue;
                    break;
                }
                if (!retry) continue;
                continue block0;
            }
        } while (retry);
        return underloadedNodes.isEmpty();
    }

    private PrioritizedPartitionMap filterNodes(Map<UUID, PartitionSet> mapping, int idealPartCnt, boolean overloaded) {
        assert (mapping != null);
        PrioritizedPartitionMap res = new PrioritizedPartitionMap(overloaded ? DESC_CMP : ASC_CMP);
        for (PartitionSet set : mapping.values()) {
            if ((!overloaded || set.size() <= idealPartCnt) && (overloaded || set.size() >= idealPartCnt)) continue;
            res.add(set);
        }
        return res;
    }

    private List<List<ClusterNode>> createCopy(AffinityFunctionContext ctx, Map<UUID, Collection<ClusterNode>> neighborhoodMap) {
        DiscoveryEvent discoEvt = ctx.discoveryEvent();
        UUID leftNodeId = discoEvt == null || discoEvt.type() == 10 ? null : discoEvt.eventNode().id();
        ArrayList<List<ClusterNode>> cp = new ArrayList<List<ClusterNode>>(this.parts);
        for (int part = 0; part < this.parts; ++part) {
            List<ClusterNode> partNodes = ctx.previousAssignment(part);
            List<Object> partNodesCp = partNodes == null ? new ArrayList() : this.copyAssigments(neighborhoodMap, partNodes, leftNodeId);
            cp.add(partNodesCp);
        }
        return cp;
    }

    private List<ClusterNode> copyAssigments(Map<UUID, Collection<ClusterNode>> neighborhoodMap, List<ClusterNode> partNodes, UUID leftNodeId) {
        final ArrayList<ClusterNode> partNodesCp = new ArrayList<ClusterNode>(partNodes.size());
        for (ClusterNode node : partNodes) {
            if (node.id().equals(leftNodeId)) continue;
            boolean containsNeighbor = false;
            if (neighborhoodMap != null) {
                containsNeighbor = F.exist((Iterable)neighborhoodMap.get(node.id()), new IgnitePredicate<ClusterNode>(){

                    @Override
                    public boolean apply(ClusterNode node) {
                        return partNodesCp.contains(node);
                    }
                });
            }
            if (containsNeighbor) continue;
            partNodesCp.add(node);
        }
        return partNodesCp;
    }

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    private static class PartitionSet {
        private ClusterNode node;
        private Collection<Integer> parts = new LinkedList<Integer>();

        private PartitionSet(ClusterNode node) {
            this.node = node;
        }

        private ClusterNode node() {
            return this.node;
        }

        private UUID nodeId() {
            return this.node.id();
        }

        private int size() {
            return this.parts.size();
        }

        private boolean add(int part) {
            if (!this.parts.contains(part)) {
                this.parts.add(part);
                return true;
            }
            return false;
        }

        private void remove(Integer part) {
            this.parts.remove(part);
        }

        private Collection<Integer> partitions() {
            return this.parts;
        }

        private boolean contains(int part) {
            return this.parts.contains(part);
        }

        public String toString() {
            return "PartSet [nodeId=" + this.node.id() + ", size=" + this.parts.size() + ", parts=" + this.parts + ']';
        }
    }

    private class FullAssignmentMap {
        private Map<UUID, PartitionSet>[] tierMaps;
        private Map<UUID, PartitionSet> fullMap;
        private List<List<ClusterNode>> assignments;
        private final Map<UUID, Collection<ClusterNode>> neighborhoodMap;

        private FullAssignmentMap(int tiers, List<List<ClusterNode>> assignments, Collection<ClusterNode> topSnapshot, Map<UUID, Collection<ClusterNode>> neighborhoodMap) {
            this.assignments = assignments;
            this.neighborhoodMap = neighborhoodMap;
            this.tierMaps = new Map[tiers];
            for (int tier = 0; tier < tiers; ++tier) {
                this.tierMaps[tier] = this.assignments(tier, topSnapshot);
            }
            this.fullMap = this.assignments(-1, topSnapshot);
        }

        boolean assign(int part, int tier, ClusterNode node, Map<Integer, Queue<Integer>> pendingParts, boolean force, boolean allowNeighbors) {
            UUID nodeId = node.id();
            if (this.isAssignable(part, tier, node, allowNeighbors)) {
                this.tierMaps[tier].get(nodeId).add(part);
                this.fullMap.get(nodeId).add(part);
                List<ClusterNode> assignment = this.assignments.get(part);
                if (assignment.size() <= tier) {
                    assignment.add(node);
                } else {
                    ClusterNode oldNode = assignment.set(tier, node);
                    if (oldNode != null) {
                        UUID oldNodeId = oldNode.id();
                        this.tierMaps[tier].get(oldNodeId).remove(part);
                        this.fullMap.get(oldNodeId).remove(part);
                    }
                }
                return true;
            }
            if (force) {
                int t;
                assert (!this.tierMaps[tier].get(nodeId).contains(part));
                for (t = 0; t < tier; ++t) {
                    if (!this.tierMaps[t].get(nodeId).contains(part)) continue;
                    return false;
                }
                for (t = tier + 1; t < this.tierMaps.length; ++t) {
                    if (!this.tierMaps[t].get(nodeId).contains(part)) continue;
                    ClusterNode oldNode = this.assignments.get(part).get(tier);
                    this.assignments.get(part).set(tier, node);
                    this.assignments.get(part).set(t, null);
                    if (oldNode != null) {
                        this.tierMaps[tier].get(oldNode.id()).remove(part);
                        this.fullMap.get(oldNode.id()).remove(part);
                    }
                    this.tierMaps[tier].get(nodeId).add(part);
                    this.tierMaps[t].get(nodeId).remove(part);
                    Queue<Integer> pending = pendingParts.get(t);
                    if (pending == null) {
                        pending = new LinkedList<Integer>();
                        pendingParts.put(t, pending);
                    }
                    pending.add(part);
                    return true;
                }
                return false;
            }
            return false;
        }

        public Map<UUID, PartitionSet> tierMapping(int tier) {
            return this.tierMaps[tier];
        }

        private boolean isAssignable(int part, int tier, final ClusterNode node, boolean allowNeighbors) {
            if (this.containsPartition(part, node)) {
                return false;
            }
            if (FairAffinityFunction.this.exclNeighbors) {
                return allowNeighbors || !this.neighborsContainPartition(node, part);
            }
            if (FairAffinityFunction.this.affinityBackupFilter != null) {
                List<ClusterNode> newAssignment;
                List<ClusterNode> assigment = this.assignments.get(part);
                assert (assigment.size() > 0);
                if (tier == 0) {
                    for (int t = 1; t < assigment.size(); ++t) {
                        ArrayList<ClusterNode> newAssignment2 = new ArrayList<ClusterNode>(assigment.size() - 1);
                        newAssignment2.add(node);
                        if (t != 1) {
                            newAssignment2.addAll(assigment.subList(1, t));
                        }
                        if (t + 1 < assigment.size()) {
                            newAssignment2.addAll(assigment.subList(t + 1, assigment.size()));
                        }
                        if (FairAffinityFunction.this.affinityBackupFilter.apply(assigment.get(t), newAssignment2)) continue;
                        return false;
                    }
                    return true;
                }
                if (tier < assigment.size()) {
                    newAssignment = new ArrayList<ClusterNode>(assigment.size() - 1);
                    int i = 0;
                    for (ClusterNode assignmentNode : assigment) {
                        if (i != tier) {
                            newAssignment.add(assignmentNode);
                        }
                        ++i;
                    }
                } else {
                    newAssignment = assigment;
                }
                return FairAffinityFunction.this.affinityBackupFilter.apply(node, newAssignment);
            }
            if (FairAffinityFunction.this.backupFilter != null) {
                if (tier == 0) {
                    List<ClusterNode> assigment = this.assignments.get(part);
                    assert (assigment.size() > 0);
                    List<ClusterNode> backups = assigment.subList(1, assigment.size());
                    return !F.exist(backups, new IgnitePredicate<ClusterNode>(){

                        @Override
                        public boolean apply(ClusterNode n) {
                            return !FairAffinityFunction.this.backupFilter.apply(node, n);
                        }
                    });
                }
                return FairAffinityFunction.this.backupFilter.apply(this.assignments.get(part).get(0), node);
            }
            return true;
        }

        private boolean containsPartition(int part, ClusterNode node) {
            return this.fullMap.get(node.id()).contains(part);
        }

        private boolean neighborsContainPartition(ClusterNode node, final int part) {
            return F.exist((Iterable)this.neighborhoodMap.get(node.id()), new IgnitePredicate<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode n) {
                    return ((PartitionSet)FullAssignmentMap.this.fullMap.get(n.id())).contains(part);
                }
            });
        }

        private Map<UUID, PartitionSet> assignments(int tier, Collection<ClusterNode> topSnapshot) {
            LinkedHashMap<UUID, PartitionSet> tmp = new LinkedHashMap<UUID, PartitionSet>();
            for (int part = 0; part < this.assignments.size(); ++part) {
                List<ClusterNode> nodes = this.assignments.get(part);
                assert (nodes instanceof RandomAccess);
                if (nodes.size() <= tier) continue;
                int start = tier < 0 ? 0 : tier;
                int end = tier < 0 ? nodes.size() : tier + 1;
                for (int i = start; i < end; ++i) {
                    ClusterNode n = nodes.get(i);
                    PartitionSet set = (PartitionSet)tmp.get(n.id());
                    if (set == null) {
                        set = new PartitionSet(n);
                        tmp.put(n.id(), set);
                    }
                    set.add(part);
                }
            }
            if (tmp.size() < topSnapshot.size()) {
                for (ClusterNode node : topSnapshot) {
                    if (tmp.containsKey(node.id())) continue;
                    tmp.put(node.id(), new PartitionSet(node));
                }
            }
            return tmp;
        }
    }

    private static class PrioritizedPartitionMap {
        private Comparator<PartitionSet> cmp;
        private Map<UUID, PartitionSet> assignmentMap = new HashMap<UUID, PartitionSet>();
        private List<PartitionSet> assignmentList = new ArrayList<PartitionSet>();

        private PrioritizedPartitionMap(Comparator<PartitionSet> cmp) {
            this.cmp = cmp;
        }

        public void add(PartitionSet set) {
            PartitionSet old = this.assignmentMap.put(set.nodeId(), set);
            if (old == null) {
                this.assignmentList.add(set);
                this.update();
            }
        }

        public void update() {
            Collections.sort(this.assignmentList, this.cmp);
        }

        public List<PartitionSet> assignments() {
            return this.assignmentList;
        }

        public void remove(UUID uuid) {
            PartitionSet rmv = this.assignmentMap.remove(uuid);
            this.assignmentList.remove(rmv);
        }

        public boolean isEmpty() {
            return this.assignmentList.isEmpty();
        }
    }

    private static class PartitionSetComparator
    implements Comparator<PartitionSet>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private PartitionSetComparator() {
        }

        @Override
        public int compare(PartitionSet o1, PartitionSet o2) {
            return Integer.compare(o1.parts.size(), o2.parts.size());
        }
    }
}

