/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.affinity.rendezvous;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.AffinityNodeHashResolver;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class RendezvousAffinityFunction
implements AffinityFunction,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_PARTITION_COUNT = 1024;
    private static final Comparator<IgniteBiTuple<Long, ClusterNode>> COMPARATOR = new HashComparator();
    private ThreadLocal<MessageDigest> digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                assert (false) : "Should have failed in constructor";
                throw new IgniteException("Failed to obtain message digest (digest was available in constructor)", e);
            }
        }
    };
    private int parts;
    private boolean exclNeighbors;
    private transient boolean exclNeighborsWarn;
    private IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter;
    private IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter;
    private AffinityNodeHashResolver hashIdRslvr = null;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private transient IgniteLogger log;

    public RendezvousAffinityFunction() {
        this(false);
    }

    public RendezvousAffinityFunction(boolean exclNeighbors) {
        this(exclNeighbors, 1024);
    }

    public RendezvousAffinityFunction(boolean exclNeighbors, int parts) {
        this(exclNeighbors, parts, null);
    }

    public RendezvousAffinityFunction(int parts, @Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this(false, parts, backupFilter);
    }

    private RendezvousAffinityFunction(boolean exclNeighbors, int parts, IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        A.ensure(parts > 0, "parts > 0");
        this.exclNeighbors = exclNeighbors;
        this.parts = parts;
        this.backupFilter = backupFilter;
        try {
            MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteException("Failed to obtain MD5 message digest instance.", e);
        }
    }

    public int getPartitions() {
        return this.parts;
    }

    public void setPartitions(int parts) {
        A.ensure(parts <= 16384, "parts <= 16384");
        this.parts = parts;
    }

    @Deprecated
    public AffinityNodeHashResolver getHashIdResolver() {
        return this.hashIdRslvr;
    }

    @Deprecated
    public void setHashIdResolver(AffinityNodeHashResolver hashIdRslvr) {
        this.hashIdRslvr = hashIdRslvr;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, ClusterNode> getBackupFilter() {
        return this.backupFilter;
    }

    @Deprecated
    public void setBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, ClusterNode> backupFilter) {
        this.backupFilter = backupFilter;
    }

    @Nullable
    public IgniteBiPredicate<ClusterNode, List<ClusterNode>> getAffinityBackupFilter() {
        return this.affinityBackupFilter;
    }

    public void setAffinityBackupFilter(@Nullable IgniteBiPredicate<ClusterNode, List<ClusterNode>> affinityBackupFilter) {
        this.affinityBackupFilter = affinityBackupFilter;
    }

    public boolean isExcludeNeighbors() {
        return this.exclNeighbors;
    }

    public void setExcludeNeighbors(boolean exclNeighbors) {
        this.exclNeighbors = exclNeighbors;
    }

    public Object resolveNodeHash(ClusterNode node) {
        if (this.hashIdRslvr != null) {
            return this.hashIdRslvr.resolve(node);
        }
        return node.consistentId();
    }

    public List<ClusterNode> assignPartition(MessageDigest d, int part, List<ClusterNode> nodes, Map<ClusterNode, byte[]> nodesHash, int backups, @Nullable Map<UUID, Collection<ClusterNode>> neighborhoodCache) {
        ClusterNode node;
        if (nodes.size() <= 1) {
            return nodes;
        }
        if (d == null) {
            d = this.digest.get();
        }
        ArrayList<IgniteBiTuple<Long, ClusterNode>> lst = new ArrayList<IgniteBiTuple<Long, ClusterNode>>(nodes.size());
        try {
            for (int i = 0; i < nodes.size(); ++i) {
                ClusterNode node2 = nodes.get(i);
                byte[] nodeHashBytes = nodesHash.get(node2);
                if (nodeHashBytes == null) {
                    Object nodeHash = this.resolveNodeHash(node2);
                    byte[] nodeHashBytes0 = U.marshal(this.ignite.configuration().getMarshaller(), nodeHash);
                    nodeHashBytes = new byte[nodeHashBytes0.length + 4];
                    System.arraycopy(nodeHashBytes0, 0, nodeHashBytes, 4, nodeHashBytes0.length);
                    nodesHash.put(node2, nodeHashBytes);
                }
                U.intToBytes(part, nodeHashBytes, 0);
                d.reset();
                byte[] bytes = d.digest(nodeHashBytes);
                long hash = (long)bytes[0] & 0xFFL | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[7] & 0xFFL) << 56;
                lst.add(F.t(hash, node2));
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        Collections.sort(lst, COMPARATOR);
        int primaryAndBackups = backups == Integer.MAX_VALUE ? nodes.size() : Math.min(backups + 1, nodes.size());
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(primaryAndBackups);
        ClusterNode primary = (ClusterNode)((IgniteBiTuple)lst.get(0)).get2();
        res.add(primary);
        if (backups > 0) {
            for (int i = 1; i < lst.size() && res.size() < primaryAndBackups; ++i) {
                IgniteBiTuple next = (IgniteBiTuple)lst.get(i);
                node = (ClusterNode)next.get2();
                if (this.exclNeighbors) {
                    Collection<ClusterNode> allNeighbors = GridCacheUtils.neighborsForNodes(neighborhoodCache, res);
                    if (allNeighbors.contains(node)) continue;
                    res.add(node);
                    continue;
                }
                if (this.affinityBackupFilter != null && this.affinityBackupFilter.apply(node, res)) {
                    res.add((ClusterNode)next.get2());
                    continue;
                }
                if (this.backupFilter != null && this.backupFilter.apply(primary, node)) {
                    res.add((ClusterNode)next.get2());
                    continue;
                }
                if (this.affinityBackupFilter != null || this.backupFilter != null) continue;
                res.add((ClusterNode)next.get2());
            }
        }
        if (res.size() < primaryAndBackups && nodes.size() >= primaryAndBackups && this.exclNeighbors) {
            for (int i = 1; i < lst.size() && res.size() < primaryAndBackups; ++i) {
                IgniteBiTuple next = (IgniteBiTuple)lst.get(i);
                node = (ClusterNode)next.get2();
                if (res.contains(node)) continue;
                res.add((ClusterNode)next.get2());
            }
            if (!this.exclNeighborsWarn) {
                LT.warn(this.log, "Affinity function excludeNeighbors property is ignored because topology has no enough nodes to assign backups.");
                this.exclNeighborsWarn = true;
            }
        }
        assert (res.size() <= primaryAndBackups);
        return res;
    }

    @Override
    public void reset() {
    }

    @Override
    public int partitions() {
        return this.parts;
    }

    @Override
    public int partition(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key is passed for a partition calculation. Make sure that an affinity key that is used is initialized properly.");
        }
        return U.safeAbs(key.hashCode() % this.parts);
    }

    @Override
    public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
        ArrayList<List<ClusterNode>> assignments = new ArrayList<List<ClusterNode>>(this.parts);
        Map<UUID, Collection<ClusterNode>> neighborhoodCache = this.exclNeighbors ? GridCacheUtils.neighbors(affCtx.currentTopologySnapshot()) : null;
        MessageDigest d = this.digest.get();
        List<ClusterNode> nodes = affCtx.currentTopologySnapshot();
        HashMap<ClusterNode, byte[]> nodesHash = U.newHashMap(nodes.size());
        for (int i = 0; i < this.parts; ++i) {
            List<ClusterNode> partAssignment = this.assignPartition(d, i, nodes, nodesHash, affCtx.backups(), neighborhoodCache);
            assignments.add(partAssignment);
        }
        return assignments;
    }

    @Override
    public void removeNode(UUID nodeId) {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.parts);
        out.writeBoolean(this.exclNeighbors);
        out.writeObject(this.hashIdRslvr);
        out.writeObject(this.backupFilter);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.parts = in.readInt();
        this.exclNeighbors = in.readBoolean();
        this.hashIdRslvr = (AffinityNodeHashResolver)in.readObject();
        this.backupFilter = (IgniteBiPredicate)in.readObject();
    }

    private static class HashComparator
    implements Comparator<IgniteBiTuple<Long, ClusterNode>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private HashComparator() {
        }

        @Override
        public int compare(IgniteBiTuple<Long, ClusterNode> o1, IgniteBiTuple<Long, ClusterNode> o2) {
            return o1.get1() < o2.get1() ? -1 : (o1.get1() > o2.get1() ? 1 : o1.get2().id().compareTo(o2.get2().id()));
        }
    }
}

