/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.lru;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jsr166.ConcurrentLinkedDeque8;
import org.jsr166.LongAdder8;

public class LruEvictionPolicy<K, V>
implements EvictionPolicy<K, V>,
LruEvictionPolicyMBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile int max = 100000;
    private volatile int batchSize = 1;
    private volatile long maxMemSize;
    private final LongAdder8 memSize = new LongAdder8();
    private final ConcurrentLinkedDeque8<EvictableEntry<K, V>> queue = new ConcurrentLinkedDeque8();

    public LruEvictionPolicy() {
    }

    public LruEvictionPolicy(int max) {
        A.ensure(max >= 0, "max >= 0");
        this.max = max;
    }

    @Override
    public int getMaxSize() {
        return this.max;
    }

    @Override
    public void setMaxSize(int max) {
        A.ensure(max >= 0, "max >= 0");
        this.max = max;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        A.ensure(batchSize > 0, "batchSize > 0");
        this.batchSize = batchSize;
    }

    @Override
    public int getCurrentSize() {
        return this.queue.size();
    }

    @Override
    public long getMaxMemorySize() {
        return this.maxMemSize;
    }

    @Override
    public void setMaxMemorySize(long maxMemSize) {
        A.ensure(maxMemSize >= 0L, "maxMemSize >= 0");
        this.maxMemSize = maxMemSize;
    }

    @Override
    public long getCurrentMemorySize() {
        return this.memSize.longValue();
    }

    public Collection<EvictableEntry<K, V>> queue() {
        return Collections.unmodifiableCollection(this.queue);
    }

    @Override
    public void onEntryAccessed(boolean rmv, EvictableEntry<K, V> entry) {
        if (!rmv) {
            if (!entry.isCached()) {
                return;
            }
            if (this.touch(entry)) {
                this.shrink();
            }
        } else {
            ConcurrentLinkedDeque8.Node node = (ConcurrentLinkedDeque8.Node)entry.removeMeta();
            if (node != null) {
                this.queue.unlinkx(node);
                this.memSize.add(-entry.size());
            }
        }
    }

    private boolean touch(EvictableEntry<K, V> entry) {
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> newNode;
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> node = (ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>>)entry.meta();
        if (node == null) {
            do {
                if (entry.putMetaIfAbsent(node = this.queue.offerLastx(entry)) != null) {
                    this.queue.unlinkx(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry.isCached()) {
                    this.queue.unlinkx(node);
                    return false;
                }
                this.memSize.add(entry.size());
                return true;
            } while (entry.removeMeta(node));
            return false;
        }
        if (this.queue.unlinkx(node) && !entry.replaceMeta(node, newNode = this.queue.offerLastx(entry))) {
            this.queue.unlinkx(newNode);
        }
        return false;
    }

    private void shrink() {
        int startSize;
        int max;
        long startMemSize;
        long maxMem = this.maxMemSize;
        if (maxMem > 0L && (startMemSize = this.memSize.longValue()) >= maxMem) {
            int size;
            for (long i = maxMem; i < startMemSize && this.memSize.longValue() > maxMem && (size = this.shrink0()) != -1; i += (long)size) {
            }
        }
        if ((max = this.max) > 0 && (startSize = this.queue.sizex()) >= max + (maxMem > 0L ? 1 : this.batchSize)) {
            for (int i = max; i < startSize && this.queue.sizex() > max && this.shrink0() != -1; ++i) {
            }
        }
    }

    private int shrink0() {
        EvictableEntry<K, V> entry = this.queue.poll();
        if (entry == null) {
            return -1;
        }
        int size = 0;
        ConcurrentLinkedDeque8.Node meta = (ConcurrentLinkedDeque8.Node)entry.removeMeta();
        if (meta != null) {
            size = entry.size();
            this.memSize.add(-size);
            if (!entry.evict()) {
                this.touch(entry);
            }
        }
        return size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.max);
        out.writeInt(this.batchSize);
        out.writeLong(this.maxMemSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.max = in.readInt();
        this.batchSize = in.readInt();
        this.maxMemSize = in.readLong();
    }

    public String toString() {
        return S.toString(LruEvictionPolicy.class, this, "size", this.queue.sizex());
    }
}

