/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.random;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.random.RandomEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

@Deprecated
public class RandomEvictionPolicy<K, V>
implements EvictionPolicy<K, V>,
RandomEvictionPolicyMBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile int max = 100000;

    public RandomEvictionPolicy() {
    }

    public RandomEvictionPolicy(int max) {
        A.ensure(max > 0, "max > 0");
        this.max = max;
    }

    @Override
    public int getMaxSize() {
        return this.max;
    }

    @Override
    public void setMaxSize(int max) {
        A.ensure(max > 0, "max > 0");
        this.max = max;
    }

    @Override
    public void onEntryAccessed(boolean rmv, EvictableEntry<K, V> entry) {
        if (!entry.isCached()) {
            return;
        }
        IgniteCache cache = entry.unwrap(IgniteCache.class);
        int size = cache.localSize(CachePeekMode.ONHEAP);
        for (int i = this.max; i < size; ++i) {
            Cache.Entry e = cache.randomEntry();
            if (e == null) continue;
            e.unwrap(EvictableEntry.class).evict();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.max);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.max = in.readInt();
    }

    public String toString() {
        return S.toString(RandomEvictionPolicy.class, this);
    }
}

