/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.sorted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.sorted.SortedEvictionPolicyMBean;
import org.apache.ignite.internal.util.GridConcurrentSkipListSet;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.jetbrains.annotations.Nullable;
import org.jsr166.LongAdder8;

public class SortedEvictionPolicy<K, V>
implements EvictionPolicy<K, V>,
SortedEvictionPolicyMBean,
Externalizable {
    private static final long serialVersionUID = 0L;
    private volatile int max = 100000;
    private volatile int batchSize = 1;
    private volatile long maxMemSize;
    private final LongAdder8 memSize = new LongAdder8();
    private Comparator<Holder<K, V>> comp;
    private final AtomicLong orderCnt = new AtomicLong();
    private final GridConcurrentSkipListSetEx<K, V> set;

    public SortedEvictionPolicy() {
        this(100000, null);
    }

    public SortedEvictionPolicy(int max) {
        this(max, null);
    }

    public SortedEvictionPolicy(int max, @Nullable Comparator<EvictableEntry<K, V>> comp) {
        this(max, 1, comp);
    }

    public SortedEvictionPolicy(int max, int batchSize, @Nullable Comparator<EvictableEntry<K, V>> comp) {
        A.ensure(max >= 0, "max >= 0");
        A.ensure(batchSize > 0, "batchSize > 0");
        this.max = max;
        this.batchSize = batchSize;
        this.comp = (Comparator)((Object)(comp == null ? new DefaultHolderComparator() : new HolderComparator<K, V>(comp)));
        this.set = new GridConcurrentSkipListSetEx<K, V>(this.comp);
    }

    public SortedEvictionPolicy(@Nullable Comparator<EvictableEntry<K, V>> comp) {
        this.comp = (Comparator)((Object)(comp == null ? new DefaultHolderComparator() : new HolderComparator<K, V>(comp)));
        this.set = new GridConcurrentSkipListSetEx<K, V>(this.comp);
    }

    @Override
    public int getMaxSize() {
        return this.max;
    }

    @Override
    public void setMaxSize(int max) {
        A.ensure(max >= 0, "max >= 0");
        this.max = max;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        A.ensure(batchSize > 0, "batchSize > 0");
        this.batchSize = batchSize;
    }

    @Override
    public int getCurrentSize() {
        return this.set.sizex();
    }

    @Override
    public long getMaxMemorySize() {
        return this.maxMemSize;
    }

    @Override
    public void setMaxMemorySize(long maxMemSize) {
        A.ensure(maxMemSize >= 0L, "maxMemSize >= 0");
        this.maxMemSize = maxMemSize;
    }

    @Override
    public long getCurrentMemorySize() {
        return this.memSize.longValue();
    }

    public Collection<EvictableEntry<K, V>> queue() {
        LinkedHashSet<EvictableEntry> cp = new LinkedHashSet<EvictableEntry>();
        for (Holder holder : this.set) {
            cp.add(holder.entry);
        }
        return Collections.unmodifiableCollection(cp);
    }

    @Override
    public void onEntryAccessed(boolean rmv, EvictableEntry<K, V> entry) {
        if (!rmv) {
            if (!entry.isCached()) {
                return;
            }
            if (this.touch(entry)) {
                this.shrink();
            }
        } else {
            Holder holder = (Holder)entry.removeMeta();
            if (holder != null) {
                this.removeHolder(holder);
                this.memSize.add(-entry.size());
            }
        }
    }

    private boolean touch(EvictableEntry<K, V> entry) {
        Holder<K, V> holder = (Holder<K, V>)entry.meta();
        if (holder == null) {
            do {
                if (entry.putMetaIfAbsent(holder = new Holder<K, V>(entry, this.orderCnt.incrementAndGet())) != null) {
                    return false;
                }
                this.set.add(holder);
                if (((Holder)holder).order <= 0L) continue;
                if (!entry.isCached()) {
                    this.removeHolder(holder);
                    return false;
                }
                this.memSize.add(entry.size());
                return true;
            } while (entry.removeMeta(holder));
            return false;
        }
        return false;
    }

    private void shrink() {
        int startSize;
        int max;
        long startMemSize;
        long maxMem = this.maxMemSize;
        if (maxMem > 0L && (startMemSize = this.memSize.longValue()) >= maxMem) {
            int size;
            for (long i = maxMem; i < startMemSize && this.memSize.longValue() > maxMem && (size = this.shrink0()) != -1; i += (long)size) {
            }
        }
        if ((max = this.max) > 0 && (startSize = this.set.sizex()) >= max + (maxMem > 0L ? 1 : this.batchSize)) {
            for (int i = max; i < startSize && this.set.sizex() > max && this.shrink0() != -1; ++i) {
            }
        }
    }

    private int shrink0() {
        Object h = this.set.pollFirst();
        if (h == null) {
            return -1;
        }
        int size = 0;
        EvictableEntry entry = ((Holder)h).entry;
        if (((Holder)h).order > 0L && entry.removeMeta(h)) {
            size = entry.size();
            this.memSize.add(-size);
            if (!entry.evict()) {
                this.touch(entry);
            }
        }
        return size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.max);
        out.writeInt(this.batchSize);
        out.writeLong(this.maxMemSize);
        out.writeObject(this.comp);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.max = in.readInt();
        this.batchSize = in.readInt();
        this.maxMemSize = in.readLong();
        this.comp = (Comparator)in.readObject();
    }

    private void removeHolder(Holder<K, V> holder) {
        long order0 = ((Holder)holder).order;
        if (order0 > 0L) {
            ((Holder)holder).order = -order0;
        }
        this.set.remove(holder);
    }

    private static class GridConcurrentSkipListSetEx<K, V>
    extends GridConcurrentSkipListSet<Holder<K, V>> {
        private static final long serialVersionUID = 0L;
        private final LongAdder8 size = new LongAdder8();

        public GridConcurrentSkipListSetEx(Comparator<? super Holder<K, V>> comp) {
            super(comp);
        }

        public int sizex() {
            return this.size.intValue();
        }

        @Override
        public boolean add(Holder<K, V> e) {
            boolean res = super.add(e);
            assert (res);
            this.size.increment();
            return res;
        }

        @Override
        public boolean remove(Object o) {
            boolean res = super.remove(o);
            if (res) {
                this.size.decrement();
            }
            return res;
        }

        @Override
        @Nullable
        public Holder<K, V> pollFirst() {
            Holder e = (Holder)super.pollFirst();
            if (e != null) {
                this.size.decrement();
            }
            return e;
        }
    }

    private static class DefaultHolderComparator<K, V>
    implements Comparator<Holder<K, V>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private DefaultHolderComparator() {
        }

        @Override
        public int compare(Holder<K, V> h1, Holder<K, V> h2) {
            if (h1 == h2) {
                return 0;
            }
            EvictableEntry e1 = ((Holder)h1).entry;
            EvictableEntry e2 = ((Holder)h2).entry;
            int cmp = ((Comparable)e1.getKey()).compareTo(e2.getKey());
            return cmp == 0 ? Long.compare(Math.abs(((Holder)h1).order), Math.abs(((Holder)h2).order)) : cmp;
        }
    }

    private static class HolderComparator<K, V>
    implements Comparator<Holder<K, V>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Comparator<EvictableEntry<K, V>> comp;

        public HolderComparator(Comparator<EvictableEntry<K, V>> comp) {
            A.notNull(comp, "comp");
            this.comp = comp;
        }

        @Override
        public int compare(Holder<K, V> h1, Holder<K, V> h2) {
            EvictableEntry e2;
            if (h1 == h2) {
                return 0;
            }
            EvictableEntry e1 = ((Holder)h1).entry;
            int cmp = this.comp.compare(e1, e2 = ((Holder)h2).entry);
            return cmp == 0 ? Long.compare(Math.abs(((Holder)h1).order), Math.abs(((Holder)h2).order)) : cmp;
        }
    }

    private static class Holder<K, V> {
        private final EvictableEntry<K, V> entry;
        private volatile long order;

        public Holder(EvictableEntry<K, V> entry, long order) {
            assert (order > 0L);
            this.entry = entry;
            this.order = order;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Holder h = (Holder)obj;
            return Objects.equals(this.entry, h.entry) && Math.abs(this.order) == Math.abs(h.order);
        }
    }
}

