/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.query.Query;

public final class ContinuousQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    private static final long serialVersionUID = 0L;
    public static final int DFLT_PAGE_SIZE = 1;
    public static final long DFLT_TIME_INTERVAL = 0L;
    public static final boolean DFLT_AUTO_UNSUBSCRIBE = true;
    private Query<Cache.Entry<K, V>> initQry;
    private CacheEntryUpdatedListener<K, V> locLsnr;
    private CacheEntryEventSerializableFilter<K, V> rmtFilter;
    private Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory;
    private long timeInterval = 0L;
    private boolean autoUnsubscribe = true;
    private boolean includeExpired;

    public ContinuousQuery() {
        this.setPageSize(1);
    }

    public ContinuousQuery<K, V> setInitialQuery(Query<Cache.Entry<K, V>> initQry) {
        this.initQry = initQry;
        return this;
    }

    public Query<Cache.Entry<K, V>> getInitialQuery() {
        return this.initQry;
    }

    public ContinuousQuery<K, V> setLocalListener(CacheEntryUpdatedListener<K, V> locLsnr) {
        this.locLsnr = locLsnr;
        return this;
    }

    public CacheEntryUpdatedListener<K, V> getLocalListener() {
        return this.locLsnr;
    }

    @Deprecated
    public ContinuousQuery<K, V> setRemoteFilter(CacheEntryEventSerializableFilter<K, V> rmtFilter) {
        this.rmtFilter = rmtFilter;
        return this;
    }

    public CacheEntryEventSerializableFilter<K, V> getRemoteFilter() {
        return this.rmtFilter;
    }

    public ContinuousQuery<K, V> setRemoteFilterFactory(Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory) {
        this.rmtFilterFactory = rmtFilterFactory;
        return this;
    }

    public Factory<? extends CacheEntryEventFilter<K, V>> getRemoteFilterFactory() {
        return this.rmtFilterFactory;
    }

    public ContinuousQuery<K, V> setTimeInterval(long timeInterval) {
        if (timeInterval < 0L) {
            throw new IllegalArgumentException("Time interval can't be negative.");
        }
        this.timeInterval = timeInterval;
        return this;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public ContinuousQuery<K, V> setAutoUnsubscribe(boolean autoUnsubscribe) {
        this.autoUnsubscribe = autoUnsubscribe;
        return this;
    }

    public boolean isAutoUnsubscribe() {
        return this.autoUnsubscribe;
    }

    public void setIncludeExpired(boolean includeExpired) {
        this.includeExpired = includeExpired;
    }

    public boolean isIncludeExpired() {
        return this.includeExpired;
    }

    public ContinuousQuery<K, V> setPageSize(int pageSize) {
        return (ContinuousQuery)super.setPageSize(pageSize);
    }

    public ContinuousQuery<K, V> setLocal(boolean loc) {
        return (ContinuousQuery)super.setLocal(loc);
    }
}

