/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class SqlFieldsQuery
extends Query<List<?>> {
    private static final long serialVersionUID = 0L;
    private String sql;
    @GridToStringInclude
    private Object[] args;
    private boolean collocated;
    private int timeout;
    private boolean enforceJoinOrder;
    private boolean distributedJoins;

    public SqlFieldsQuery(String sql) {
        this.setSql(sql);
    }

    public SqlFieldsQuery(String sql, boolean collocated) {
        this.sql = sql;
        this.collocated = collocated;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlFieldsQuery setSql(String sql) {
        A.notNull(sql, "sql");
        this.sql = sql;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public SqlFieldsQuery setArgs(Object ... args) {
        this.args = args;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SqlFieldsQuery setTimeout(int timeout, TimeUnit timeUnit) {
        this.timeout = GridQueryProcessor.validateTimeout(timeout, timeUnit);
        return this;
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    public SqlFieldsQuery setCollocated(boolean collocated) {
        this.collocated = collocated;
        return this;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public SqlFieldsQuery setEnforceJoinOrder(boolean enforceJoinOrder) {
        this.enforceJoinOrder = enforceJoinOrder;
        return this;
    }

    public SqlFieldsQuery setDistributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
        return this;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    public SqlFieldsQuery setPageSize(int pageSize) {
        return (SqlFieldsQuery)super.setPageSize(pageSize);
    }

    public SqlFieldsQuery setLocal(boolean loc) {
        return (SqlFieldsQuery)super.setLocal(loc);
    }

    @Override
    public String toString() {
        return S.toString(SqlFieldsQuery.class, this);
    }
}

