/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.binary.BinaryIdMapper;
import org.apache.ignite.binary.BinaryNameMapper;
import org.apache.ignite.binary.BinarySerializer;
import org.apache.ignite.binary.BinaryTypeConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinaryConfiguration {
    public static final boolean DFLT_COMPACT_FOOTER = true;
    private BinaryIdMapper idMapper;
    private BinaryNameMapper nameMapper;
    private BinarySerializer serializer;
    private Collection<BinaryTypeConfiguration> typeCfgs;
    private boolean compactFooter = true;

    public void setClassNames(Collection<String> clsNames) {
        if (this.typeCfgs == null) {
            this.typeCfgs = new ArrayList<BinaryTypeConfiguration>(clsNames.size());
        }
        for (String clsName : clsNames) {
            this.typeCfgs.add(new BinaryTypeConfiguration(clsName));
        }
    }

    public BinaryIdMapper getIdMapper() {
        return this.idMapper;
    }

    public void setIdMapper(BinaryIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public BinaryNameMapper getNameMapper() {
        return this.nameMapper;
    }

    public void setNameMapper(BinaryNameMapper nameMapper) {
        this.nameMapper = nameMapper;
    }

    public BinarySerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(BinarySerializer serializer) {
        this.serializer = serializer;
    }

    public Collection<BinaryTypeConfiguration> getTypeConfigurations() {
        return this.typeCfgs;
    }

    public void setTypeConfigurations(Collection<BinaryTypeConfiguration> typeCfgs) {
        this.typeCfgs = typeCfgs;
    }

    public boolean isCompactFooter() {
        return this.compactFooter;
    }

    public void setCompactFooter(boolean compactFooter) {
        this.compactFooter = compactFooter;
    }

    public String toString() {
        return S.toString(BinaryConfiguration.class, this);
    }
}

