/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import org.apache.ignite.cache.CacheAtomicWriteOrderMode;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheInterceptor;
import org.apache.ignite.cache.CacheMemoryMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheTypeMetadata;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.query.annotations.QueryGroupIndex;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QueryTextField;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.cache.store.CacheStoreSessionListener;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexType;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.CachePluginConfiguration;
import org.jetbrains.annotations.Nullable;

public class CacheConfiguration<K, V>
extends MutableConfiguration<K, V> {
    private static final long serialVersionUID = 0L;
    public static final int MAX_PARTITIONS_COUNT = 16384;
    @Deprecated
    public static final int DFLT_REBALANCE_THREAD_POOL_SIZE = 2;
    public static final long DFLT_REBALANCE_TIMEOUT = 10000L;
    public static final long DFLT_REBALANCE_BATCHES_PREFETCH_COUNT = 2L;
    public static final long DFLT_REBALANCE_THROTTLE = 0L;
    public static final int DFLT_BACKUPS = 0;
    public static final CacheMode DFLT_CACHE_MODE = CacheMode.PARTITIONED;
    public static final CacheAtomicityMode DFLT_CACHE_ATOMICITY_MODE = CacheAtomicityMode.ATOMIC;
    public static final long DFLT_LOCK_TIMEOUT = 0L;
    public static final int DFLT_START_SIZE = 1500000;
    public static final int DFLT_CACHE_SIZE = 100000;
    public static final int DFLT_NEAR_START_SIZE = 375000;
    public static final boolean DFLT_INVALIDATE = false;
    public static final CacheRebalanceMode DFLT_REBALANCE_MODE = CacheRebalanceMode.ASYNC;
    public static final int DFLT_REBALANCE_BATCH_SIZE = 524288;
    public static final float DFLT_MAX_EVICTION_OVERFLOW_RATIO = 10.0f;
    public static final boolean DFLT_EVICT_SYNCHRONIZED = false;
    public static final int DFLT_EVICT_KEY_BUFFER_SIZE = 1024;
    public static final long DFLT_EVICT_SYNCHRONIZED_TIMEOUT = 10000L;
    public static final int DFLT_EVICT_SYNCHRONIZED_CONCURRENCY_LEVEL = 4;
    public static final boolean DFLT_EAGER_TTL = true;
    public static final long DFLT_OFFHEAP_MEMORY = -1L;
    public static final boolean DFLT_SWAP_ENABLED = false;
    public static final int DFLT_MAX_CONCURRENT_ASYNC_OPS = 500;
    public static final boolean DFLT_WRITE_BEHIND_ENABLED = false;
    public static final int DFLT_WRITE_BEHIND_FLUSH_SIZE = 10240;
    public static final int DFLT_WRITE_BEHIND_CRITICAL_SIZE = 16384;
    public static final long DFLT_WRITE_BEHIND_FLUSH_FREQUENCY = 5000L;
    public static final int DFLT_WRITE_FROM_BEHIND_FLUSH_THREAD_CNT = 1;
    public static final int DFLT_WRITE_BEHIND_BATCH_SIZE = 512;
    public static final int DFLT_MAX_QUERY_ITERATOR_CNT = 1024;
    public static final boolean DFLT_LOAD_PREV_VAL = false;
    public static final CacheMemoryMode DFLT_MEMORY_MODE = CacheMemoryMode.ONHEAP_TIERED;
    public static final boolean DFLT_READ_FROM_BACKUP = true;
    public static final IgnitePredicate<ClusterNode> ALL_NODES = new IgniteAllNodesPredicate();
    public static final long DFLT_LONG_QRY_WARN_TIMEOUT = 3000L;
    public static final int DFLT_QRY_DETAIL_METRICS_SIZE = 0;
    public static final int DFLT_SQL_ONHEAP_ROW_CACHE_SIZE = 10240;
    public static final Boolean DFLT_STORE_KEEP_BINARY = new Boolean(false);
    public static final int DFLT_CONCURRENT_LOAD_ALL_THRESHOLD = 5;
    public static final int DFLT_QUERY_PARALLELISM = 1;
    private String name;
    private int storeConcurrentLoadAllThreshold = 5;
    @Deprecated
    private int rebalancePoolSize = 2;
    private long rebalanceTimeout = 10000L;
    private EvictionPolicy evictPlc;
    private boolean evictSync = false;
    private int evictKeyBufSize = 1024;
    private int evictSyncConcurrencyLvl = 4;
    private long evictSyncTimeout = 10000L;
    private EvictionFilter<?, ?> evictFilter;
    private float evictMaxOverflowRatio = 10.0f;
    private boolean eagerTtl = true;
    private long dfltLockTimeout = 0L;
    private int startSize = 1500000;
    private NearCacheConfiguration<K, V> nearCfg;
    public static final boolean DFLT_COPY_ON_READ = true;
    private CacheWriteSynchronizationMode writeSync;
    private Factory storeFactory;
    private Boolean storeKeepBinary = DFLT_STORE_KEEP_BINARY;
    private boolean loadPrevVal = false;
    private AffinityFunction aff;
    private CacheMode cacheMode = DFLT_CACHE_MODE;
    private CacheAtomicityMode atomicityMode;
    private CacheAtomicWriteOrderMode atomicWriteOrderMode;
    private int backups = 0;
    private boolean invalidate = false;
    private String tmLookupClsName;
    private CacheRebalanceMode rebalanceMode = DFLT_REBALANCE_MODE;
    private int rebalanceOrder;
    private int rebalanceBatchSize = 524288;
    private long rebalanceBatchesPrefetchCount = 2L;
    private long offHeapMaxMem = -1L;
    private boolean swapEnabled = false;
    private int maxConcurrentAsyncOps = 500;
    private boolean writeBehindEnabled = false;
    private int writeBehindFlushSize = 10240;
    private long writeBehindFlushFreq = 5000L;
    private int writeBehindFlushThreadCnt = 1;
    private int writeBehindBatchSize = 512;
    private int maxQryIterCnt = 1024;
    private CacheMemoryMode memMode = DFLT_MEMORY_MODE;
    private AffinityKeyMapper affMapper;
    private long rebalanceDelay;
    private long rebalanceThrottle = 0L;
    private CacheInterceptor<?, ?> interceptor;
    private Class<?>[] sqlFuncCls;
    private long longQryWarnTimeout = 3000L;
    private int qryDetailMetricsSz = 0;
    private boolean readFromBackup = true;
    private Collection<CacheTypeMetadata> typeMeta;
    private IgnitePredicate<ClusterNode> nodeFilter;
    private String sqlSchema;
    private boolean sqlEscapeAll;
    private int sqlOnheapRowCacheSize = 10240;
    private transient Class<?>[] indexedTypes;
    private boolean snapshotableIdx;
    private boolean cpOnRead = true;
    private CachePluginConfiguration[] pluginCfgs;
    private TopologyValidator topValidator;
    private Factory<? extends CacheStoreSessionListener>[] storeSesLsnrs;
    private Collection<QueryEntity> qryEntities;
    private int qryParallelism = 1;

    public CacheConfiguration() {
    }

    public CacheConfiguration(String name) {
        this.name = name;
    }

    public CacheConfiguration(CompleteConfiguration<K, V> cfg) {
        super(cfg);
        if (!(cfg instanceof CacheConfiguration)) {
            return;
        }
        CacheConfiguration cc = (CacheConfiguration)cfg;
        this.aff = cc.getAffinity();
        this.affMapper = cc.getAffinityMapper();
        this.atomicityMode = cc.getAtomicityMode();
        this.atomicWriteOrderMode = cc.getAtomicWriteOrderMode();
        this.backups = cc.getBackups();
        this.cacheLoaderFactory = cc.getCacheLoaderFactory();
        this.cacheMode = cc.getCacheMode();
        this.cacheWriterFactory = cc.getCacheWriterFactory();
        this.cpOnRead = cc.isCopyOnRead();
        this.dfltLockTimeout = cc.getDefaultLockTimeout();
        this.eagerTtl = cc.isEagerTtl();
        this.evictFilter = cc.getEvictionFilter();
        this.evictKeyBufSize = cc.getEvictSynchronizedKeyBufferSize();
        this.evictMaxOverflowRatio = cc.getEvictMaxOverflowRatio();
        this.evictPlc = cc.getEvictionPolicy();
        this.evictSync = cc.isEvictSynchronized();
        this.evictSyncConcurrencyLvl = cc.getEvictSynchronizedConcurrencyLevel();
        this.evictSyncTimeout = cc.getEvictSynchronizedTimeout();
        this.expiryPolicyFactory = cc.getExpiryPolicyFactory();
        this.indexedTypes = cc.getIndexedTypes();
        this.interceptor = cc.getInterceptor();
        this.invalidate = cc.isInvalidate();
        this.isReadThrough = cc.isReadThrough();
        this.qryParallelism = cc.getQueryParallelism();
        this.isWriteThrough = cc.isWriteThrough();
        this.storeKeepBinary = cc.isStoreKeepBinary() != null ? cc.isStoreKeepBinary() : DFLT_STORE_KEEP_BINARY;
        this.listenerConfigurations = cc.listenerConfigurations;
        this.loadPrevVal = cc.isLoadPreviousValue();
        this.longQryWarnTimeout = cc.getLongQueryWarningTimeout();
        this.offHeapMaxMem = cc.getOffHeapMaxMemory();
        this.maxConcurrentAsyncOps = cc.getMaxConcurrentAsyncOperations();
        this.memMode = cc.getMemoryMode();
        this.name = cc.getName();
        this.nearCfg = cc.getNearConfiguration();
        this.nodeFilter = cc.getNodeFilter();
        this.pluginCfgs = cc.getPluginConfigurations();
        this.qryEntities = cc.getQueryEntities() == Collections.emptyList() ? null : cc.getQueryEntities();
        this.qryDetailMetricsSz = cc.getQueryDetailMetricsSize();
        this.readFromBackup = cc.isReadFromBackup();
        this.rebalanceBatchSize = cc.getRebalanceBatchSize();
        this.rebalanceBatchesPrefetchCount = cc.getRebalanceBatchesPrefetchCount();
        this.rebalanceDelay = cc.getRebalanceDelay();
        this.rebalanceMode = cc.getRebalanceMode();
        this.rebalanceOrder = cc.getRebalanceOrder();
        this.rebalancePoolSize = cc.getRebalanceThreadPoolSize();
        this.rebalanceTimeout = cc.getRebalanceTimeout();
        this.rebalanceThrottle = cc.getRebalanceThrottle();
        this.snapshotableIdx = cc.isSnapshotableIndex();
        this.sqlSchema = cc.getSqlSchema();
        this.sqlEscapeAll = cc.isSqlEscapeAll();
        this.sqlFuncCls = cc.getSqlFunctionClasses();
        this.sqlOnheapRowCacheSize = cc.getSqlOnheapRowCacheSize();
        this.startSize = cc.getStartSize();
        this.storeFactory = cc.getCacheStoreFactory();
        this.storeSesLsnrs = cc.getCacheStoreSessionListenerFactories();
        this.swapEnabled = cc.isSwapEnabled();
        this.tmLookupClsName = cc.getTransactionManagerLookupClassName();
        this.topValidator = cc.getTopologyValidator();
        this.typeMeta = cc.getTypeMetadata();
        this.writeBehindBatchSize = cc.getWriteBehindBatchSize();
        this.writeBehindEnabled = cc.isWriteBehindEnabled();
        this.writeBehindFlushFreq = cc.getWriteBehindFlushFrequency();
        this.writeBehindFlushSize = cc.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = cc.getWriteBehindFlushThreadCount();
        this.writeSync = cc.getWriteSynchronizationMode();
    }

    public String getName() {
        return this.name;
    }

    public CacheConfiguration<K, V> setName(String name) {
        A.ensure(name == null || !name.isEmpty(), "Name cannot be empty.");
        this.name = name;
        return this;
    }

    @Nullable
    public EvictionPolicy<K, V> getEvictionPolicy() {
        return this.evictPlc;
    }

    public CacheConfiguration<K, V> setEvictionPolicy(@Nullable EvictionPolicy evictPlc) {
        this.evictPlc = evictPlc;
        return this;
    }

    public NearCacheConfiguration<K, V> getNearConfiguration() {
        return this.nearCfg;
    }

    public CacheConfiguration<K, V> setNearConfiguration(NearCacheConfiguration<K, V> nearCfg) {
        this.nearCfg = nearCfg;
        return this;
    }

    public CacheWriteSynchronizationMode getWriteSynchronizationMode() {
        return this.writeSync;
    }

    public CacheConfiguration<K, V> setWriteSynchronizationMode(CacheWriteSynchronizationMode writeSync) {
        this.writeSync = writeSync;
        return this;
    }

    public IgnitePredicate<ClusterNode> getNodeFilter() {
        return this.nodeFilter;
    }

    public CacheConfiguration<K, V> setNodeFilter(IgnitePredicate<ClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    public boolean isEvictSynchronized() {
        return this.evictSync;
    }

    public CacheConfiguration<K, V> setEvictSynchronized(boolean evictSync) {
        this.evictSync = evictSync;
        return this;
    }

    public int getEvictSynchronizedKeyBufferSize() {
        return this.evictKeyBufSize;
    }

    public CacheConfiguration<K, V> setEvictSynchronizedKeyBufferSize(int evictKeyBufSize) {
        this.evictKeyBufSize = evictKeyBufSize;
        return this;
    }

    public int getEvictSynchronizedConcurrencyLevel() {
        return this.evictSyncConcurrencyLvl;
    }

    public CacheConfiguration<K, V> setEvictSynchronizedConcurrencyLevel(int evictSyncConcurrencyLvl) {
        this.evictSyncConcurrencyLvl = evictSyncConcurrencyLvl;
        return this;
    }

    public long getEvictSynchronizedTimeout() {
        return this.evictSyncTimeout;
    }

    public CacheConfiguration<K, V> setEvictSynchronizedTimeout(long evictSyncTimeout) {
        this.evictSyncTimeout = evictSyncTimeout;
        return this;
    }

    public float getEvictMaxOverflowRatio() {
        return this.evictMaxOverflowRatio;
    }

    public CacheConfiguration<K, V> setEvictMaxOverflowRatio(float evictMaxOverflowRatio) {
        this.evictMaxOverflowRatio = evictMaxOverflowRatio;
        return this;
    }

    public EvictionFilter<K, V> getEvictionFilter() {
        return this.evictFilter;
    }

    public CacheConfiguration<K, V> setEvictionFilter(EvictionFilter<K, V> evictFilter) {
        this.evictFilter = evictFilter;
        return this;
    }

    public boolean isEagerTtl() {
        return this.eagerTtl;
    }

    public CacheConfiguration<K, V> setEagerTtl(boolean eagerTtl) {
        this.eagerTtl = eagerTtl;
        return this;
    }

    public int getStartSize() {
        return this.startSize;
    }

    public CacheConfiguration<K, V> setStartSize(int startSize) {
        this.startSize = startSize;
        return this;
    }

    public boolean isLoadPreviousValue() {
        return this.loadPrevVal;
    }

    public CacheConfiguration<K, V> setLoadPreviousValue(boolean loadPrevVal) {
        this.loadPrevVal = loadPrevVal;
        return this;
    }

    public Factory<CacheStore<? super K, ? super V>> getCacheStoreFactory() {
        return this.storeFactory;
    }

    public CacheConfiguration<K, V> setCacheStoreFactory(Factory<? extends CacheStore<? super K, ? super V>> storeFactory) {
        this.storeFactory = storeFactory;
        return this;
    }

    public Boolean isStoreKeepBinary() {
        return this.storeKeepBinary;
    }

    public void setStoreKeepBinary(boolean storeKeepBinary) {
        this.storeKeepBinary = storeKeepBinary;
    }

    public int getStoreConcurrentLoadAllThreshold() {
        return this.storeConcurrentLoadAllThreshold;
    }

    public CacheConfiguration<K, V> setStoreConcurrentLoadAllThreshold(int storeConcurrentLoadAllThreshold) {
        this.storeConcurrentLoadAllThreshold = storeConcurrentLoadAllThreshold;
        return this;
    }

    public AffinityFunction getAffinity() {
        return this.aff;
    }

    public CacheConfiguration<K, V> setAffinity(AffinityFunction aff) {
        this.aff = aff;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public CacheConfiguration<K, V> setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheAtomicityMode getAtomicityMode() {
        return this.atomicityMode;
    }

    public CacheConfiguration<K, V> setAtomicityMode(CacheAtomicityMode atomicityMode) {
        this.atomicityMode = atomicityMode;
        return this;
    }

    public CacheAtomicWriteOrderMode getAtomicWriteOrderMode() {
        return this.atomicWriteOrderMode;
    }

    public CacheConfiguration<K, V> setAtomicWriteOrderMode(CacheAtomicWriteOrderMode atomicWriteOrderMode) {
        this.atomicWriteOrderMode = atomicWriteOrderMode;
        return this;
    }

    public int getBackups() {
        return this.backups;
    }

    public CacheConfiguration<K, V> setBackups(int backups) {
        this.backups = backups;
        return this;
    }

    public long getDefaultLockTimeout() {
        return this.dfltLockTimeout;
    }

    public CacheConfiguration<K, V> setDefaultLockTimeout(long dfltLockTimeout) {
        this.dfltLockTimeout = dfltLockTimeout;
        return this;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public CacheConfiguration<K, V> setInvalidate(boolean invalidate) {
        this.invalidate = invalidate;
        return this;
    }

    @Deprecated
    public String getTransactionManagerLookupClassName() {
        return this.tmLookupClsName;
    }

    @Deprecated
    public CacheConfiguration<K, V> setTransactionManagerLookupClassName(String tmLookupClsName) {
        this.tmLookupClsName = tmLookupClsName;
        return this;
    }

    public CacheConfiguration<K, V> setRebalanceMode(CacheRebalanceMode rebalanceMode) {
        this.rebalanceMode = rebalanceMode;
        return this;
    }

    public CacheRebalanceMode getRebalanceMode() {
        return this.rebalanceMode;
    }

    public int getRebalanceOrder() {
        return this.rebalanceOrder;
    }

    public CacheConfiguration<K, V> setRebalanceOrder(int rebalanceOrder) {
        this.rebalanceOrder = rebalanceOrder;
        return this;
    }

    public int getRebalanceBatchSize() {
        return this.rebalanceBatchSize;
    }

    public CacheConfiguration<K, V> setRebalanceBatchSize(int rebalanceBatchSize) {
        this.rebalanceBatchSize = rebalanceBatchSize;
        return this;
    }

    public long getRebalanceBatchesPrefetchCount() {
        return this.rebalanceBatchesPrefetchCount;
    }

    public CacheConfiguration<K, V> setRebalanceBatchesPrefetchCount(long rebalanceBatchesCnt) {
        this.rebalanceBatchesPrefetchCount = rebalanceBatchesCnt;
        return this;
    }

    public boolean isSwapEnabled() {
        return this.swapEnabled;
    }

    public CacheConfiguration<K, V> setSwapEnabled(boolean swapEnabled) {
        this.swapEnabled = swapEnabled;
        return this;
    }

    public int getMaxConcurrentAsyncOperations() {
        return this.maxConcurrentAsyncOps;
    }

    public CacheConfiguration<K, V> setMaxConcurrentAsyncOperations(int maxConcurrentAsyncOps) {
        this.maxConcurrentAsyncOps = maxConcurrentAsyncOps;
        return this;
    }

    public boolean isWriteBehindEnabled() {
        return this.writeBehindEnabled;
    }

    public CacheConfiguration<K, V> setWriteBehindEnabled(boolean writeBehindEnabled) {
        this.writeBehindEnabled = writeBehindEnabled;
        return this;
    }

    public int getWriteBehindFlushSize() {
        return this.writeBehindFlushSize;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushSize(int writeBehindFlushSize) {
        this.writeBehindFlushSize = writeBehindFlushSize;
        return this;
    }

    public long getWriteBehindFlushFrequency() {
        return this.writeBehindFlushFreq;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushFrequency(long writeBehindFlushFreq) {
        this.writeBehindFlushFreq = writeBehindFlushFreq;
        return this;
    }

    public int getWriteBehindFlushThreadCount() {
        return this.writeBehindFlushThreadCnt;
    }

    public CacheConfiguration<K, V> setWriteBehindFlushThreadCount(int writeBehindFlushThreadCnt) {
        this.writeBehindFlushThreadCnt = writeBehindFlushThreadCnt;
        return this;
    }

    public int getWriteBehindBatchSize() {
        return this.writeBehindBatchSize;
    }

    public CacheConfiguration<K, V> setWriteBehindBatchSize(int writeBehindBatchSize) {
        this.writeBehindBatchSize = writeBehindBatchSize;
        return this;
    }

    @Deprecated
    public int getRebalanceThreadPoolSize() {
        return this.rebalancePoolSize;
    }

    @Deprecated
    public CacheConfiguration<K, V> setRebalanceThreadPoolSize(int rebalancePoolSize) {
        this.rebalancePoolSize = rebalancePoolSize;
        return this;
    }

    public long getRebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public CacheConfiguration<K, V> setRebalanceTimeout(long rebalanceTimeout) {
        this.rebalanceTimeout = rebalanceTimeout;
        return this;
    }

    public long getRebalanceDelay() {
        return this.rebalanceDelay;
    }

    public CacheConfiguration<K, V> setRebalanceDelay(long rebalanceDelay) {
        this.rebalanceDelay = rebalanceDelay;
        return this;
    }

    public long getRebalanceThrottle() {
        return this.rebalanceThrottle;
    }

    public CacheConfiguration<K, V> setRebalanceThrottle(long rebalanceThrottle) {
        this.rebalanceThrottle = rebalanceThrottle;
        return this;
    }

    public AffinityKeyMapper getAffinityMapper() {
        return this.affMapper;
    }

    public CacheConfiguration<K, V> setAffinityMapper(AffinityKeyMapper affMapper) {
        this.affMapper = affMapper;
        return this;
    }

    public long getOffHeapMaxMemory() {
        return this.offHeapMaxMem;
    }

    public CacheConfiguration<K, V> setOffHeapMaxMemory(long offHeapMaxMem) {
        this.offHeapMaxMem = offHeapMaxMem;
        return this;
    }

    public int getMaxQueryIteratorsCount() {
        return this.maxQryIterCnt;
    }

    public CacheConfiguration<K, V> setMaxQueryIteratorsCount(int maxQryIterCnt) {
        this.maxQryIterCnt = maxQryIterCnt;
        return this;
    }

    public CacheMemoryMode getMemoryMode() {
        return this.memMode;
    }

    public CacheConfiguration<K, V> setMemoryMode(CacheMemoryMode memMode) {
        this.memMode = memMode;
        return this;
    }

    @Nullable
    public CacheInterceptor<K, V> getInterceptor() {
        return this.interceptor;
    }

    public CacheConfiguration<K, V> setInterceptor(CacheInterceptor<K, V> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Collection<CacheTypeMetadata> getTypeMetadata() {
        return this.typeMeta;
    }

    public CacheConfiguration<K, V> setTypeMetadata(Collection<CacheTypeMetadata> typeMeta) {
        this.typeMeta = new ArrayList<CacheTypeMetadata>(typeMeta);
        return this;
    }

    public boolean isReadFromBackup() {
        return this.readFromBackup;
    }

    public CacheConfiguration<K, V> setReadFromBackup(boolean readFromBackup) {
        this.readFromBackup = readFromBackup;
        return this;
    }

    public boolean isCopyOnRead() {
        return this.cpOnRead;
    }

    public CacheConfiguration<K, V> setCopyOnRead(boolean cpOnRead) {
        this.cpOnRead = cpOnRead;
        return this;
    }

    public CacheConfiguration<K, V> setSqlFunctionClasses(Class<?> ... cls) {
        this.sqlFuncCls = cls;
        return this;
    }

    @Nullable
    public Class<?>[] getSqlFunctionClasses() {
        return this.sqlFuncCls;
    }

    public long getLongQueryWarningTimeout() {
        return this.longQryWarnTimeout;
    }

    public CacheConfiguration<K, V> setLongQueryWarningTimeout(long longQryWarnTimeout) {
        this.longQryWarnTimeout = longQryWarnTimeout;
        return this;
    }

    public int getQueryDetailMetricsSize() {
        return this.qryDetailMetricsSz;
    }

    public CacheConfiguration<K, V> setQueryDetailMetricsSize(int qryDetailMetricsSz) {
        this.qryDetailMetricsSz = qryDetailMetricsSz;
        return this;
    }

    @Nullable
    public String getSqlSchema() {
        return this.sqlSchema;
    }

    public CacheConfiguration<K, V> setSqlSchema(String sqlSchema) {
        A.ensure(sqlSchema != null, "Schema could not be null.");
        A.ensure(!sqlSchema.isEmpty(), "Schema could not be empty.");
        this.sqlSchema = sqlSchema;
        return this;
    }

    public boolean isSqlEscapeAll() {
        return this.sqlEscapeAll;
    }

    public CacheConfiguration<K, V> setSqlEscapeAll(boolean sqlEscapeAll) {
        this.sqlEscapeAll = sqlEscapeAll;
        return this;
    }

    public Class<?>[] getIndexedTypes() {
        return this.indexedTypes;
    }

    public CacheConfiguration<K, V> setIndexedTypes(Class<?> ... indexedTypes) {
        int i;
        if (F.isEmpty(indexedTypes)) {
            return this;
        }
        int len = indexedTypes.length;
        if (len == 0) {
            return this;
        }
        A.ensure((len & 1) == 0, "Number of indexed types is expected to be even. Refer to method javadoc for details.");
        if (this.indexedTypes != null) {
            throw new CacheException("Indexed types can be set only once.");
        }
        Class[] newIndexedTypes = new Class[len];
        for (i = 0; i < len; ++i) {
            if (indexedTypes[i] == null) {
                throw new NullPointerException("Indexed types array contains null at index: " + i);
            }
            newIndexedTypes[i] = U.box(indexedTypes[i]);
        }
        if (this.qryEntities == null) {
            this.qryEntities = new ArrayList<QueryEntity>();
        }
        for (i = 0; i < len; i += 2) {
            Class keyCls = newIndexedTypes[i];
            Class valCls = newIndexedTypes[i + 1];
            TypeDescriptor desc = CacheConfiguration.processKeyAndValueClasses(keyCls, valCls);
            QueryEntity converted = CacheConfiguration.convert(desc);
            boolean dup = false;
            for (QueryEntity entity : this.qryEntities) {
                if (!F.eq(entity.getValueType(), converted.getValueType())) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            this.qryEntities.add(converted);
        }
        return this;
    }

    public int getSqlOnheapRowCacheSize() {
        return this.sqlOnheapRowCacheSize;
    }

    public CacheConfiguration<K, V> setSqlOnheapRowCacheSize(int size) {
        this.sqlOnheapRowCacheSize = size;
        return this;
    }

    public boolean isSnapshotableIndex() {
        return this.snapshotableIdx;
    }

    public CacheConfiguration<K, V> setSnapshotableIndex(boolean snapshotableIdx) {
        this.snapshotableIdx = snapshotableIdx;
        return this;
    }

    public CachePluginConfiguration[] getPluginConfigurations() {
        return this.pluginCfgs != null ? this.pluginCfgs : new CachePluginConfiguration[]{};
    }

    public CacheConfiguration<K, V> setPluginConfigurations(CachePluginConfiguration ... pluginCfgs) {
        this.pluginCfgs = pluginCfgs;
        return this;
    }

    public Collection<QueryEntity> getQueryEntities() {
        return this.qryEntities != null ? this.qryEntities : Collections.emptyList();
    }

    public CacheConfiguration<K, V> setQueryEntities(Collection<QueryEntity> qryEntities) {
        if (this.qryEntities == null) {
            this.qryEntities = new ArrayList<QueryEntity>(qryEntities);
        }
        for (QueryEntity entity : qryEntities) {
            boolean found = false;
            for (QueryEntity existing : this.qryEntities) {
                if (!F.eq(entity.getValueType(), existing.getValueType())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.qryEntities.add(entity);
        }
        return this;
    }

    public int getQueryParallelism() {
        return this.qryParallelism;
    }

    public CacheConfiguration<K, V> setQueryParallelism(int qryParallelism) {
        this.qryParallelism = qryParallelism;
        return this;
    }

    public TopologyValidator getTopologyValidator() {
        return this.topValidator;
    }

    public CacheConfiguration<K, V> setTopologyValidator(TopologyValidator topValidator) {
        this.topValidator = topValidator;
        return this;
    }

    public Factory<? extends CacheStoreSessionListener>[] getCacheStoreSessionListenerFactories() {
        return this.storeSesLsnrs;
    }

    public CacheConfiguration<K, V> setCacheStoreSessionListenerFactories(Factory<? extends CacheStoreSessionListener> ... storeSesLsnrs) {
        this.storeSesLsnrs = storeSesLsnrs;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return new HashSet<CacheEntryListenerConfiguration<K, V>>(this.listenerConfigurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfiguration<K, V> addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryLsnrCfg) {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return super.addCacheEntryListenerConfiguration(cacheEntryLsnrCfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfiguration<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryLsnrCfg) {
        CacheConfiguration cacheConfiguration = this;
        synchronized (cacheConfiguration) {
            return super.removeCacheEntryListenerConfiguration(cacheEntryLsnrCfg);
        }
    }

    protected Object writeReplace() {
        CacheConfiguration<K, V> cfg = new CacheConfiguration<K, V>(this);
        cfg.listenerConfigurations = new HashSet();
        return cfg;
    }

    private static QueryEntity convert(TypeDescriptor desc) {
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(desc.keyClass().getName());
        entity.setValueType(desc.valueClass().getName());
        for (ClassProperty prop : desc.props.values()) {
            entity.addQueryField(prop.fullName(), U.box(prop.type()).getName(), prop.alias());
        }
        entity.setKeyFields(desc.keyProperties);
        QueryIndex txtIdx = null;
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        for (Map.Entry<String, GridQueryIndexDescriptor> idxEntry : desc.indexes().entrySet()) {
            GridQueryIndexDescriptor idx = idxEntry.getValue();
            if (idx.type() == GridQueryIndexType.FULLTEXT) {
                assert (txtIdx == null);
                txtIdx = new QueryIndex();
                txtIdx.setIndexType(QueryIndexType.FULLTEXT);
                txtIdx.setFieldNames(idx.fields(), true);
                txtIdx.setName(idxEntry.getKey());
                continue;
            }
            ArrayList<String> grp = new ArrayList<String>();
            for (String fieldName : idx.fields()) {
                grp.add(idx.descending(fieldName) ? fieldName + " desc" : fieldName);
            }
            QueryIndex sortedIdx = new QueryIndex();
            sortedIdx.setIndexType(idx.type() == GridQueryIndexType.SORTED ? QueryIndexType.SORTED : QueryIndexType.GEOSPATIAL);
            LinkedHashMap<String, Boolean> fields = new LinkedHashMap<String, Boolean>();
            for (String f : idx.fields()) {
                fields.put(f, !idx.descending(f));
            }
            sortedIdx.setFields(fields);
            sortedIdx.setName(idxEntry.getKey());
            idxs.add(sortedIdx);
        }
        if (desc.valueTextIndex()) {
            if (txtIdx == null) {
                txtIdx = new QueryIndex();
                txtIdx.setIndexType(QueryIndexType.FULLTEXT);
                txtIdx.setFieldNames(Arrays.asList("_val"), true);
            } else {
                txtIdx.getFields().put("_val", true);
            }
        }
        if (txtIdx != null) {
            idxs.add(txtIdx);
        }
        if (!F.isEmpty(idxs)) {
            entity.setIndexes(idxs);
        }
        return entity;
    }

    private static Class<?> mask(Class<?> cls) {
        assert (cls != null);
        return GridQueryProcessor.isSqlType(cls) ? cls : Object.class;
    }

    static TypeDescriptor processKeyAndValueClasses(Class<?> keyCls, Class<?> valCls) {
        TypeDescriptor d = new TypeDescriptor();
        d.keyClass(keyCls);
        d.valueClass(valCls);
        CacheConfiguration.processAnnotationsInClass(true, d.keyCls, d, null);
        CacheConfiguration.processAnnotationsInClass(false, d.valCls, d, null);
        return d;
    }

    private static void processAnnotationsInClass(boolean key, Class<?> cls, TypeDescriptor type, @Nullable ClassProperty parent) {
        if (U.isJdk(cls) || GridQueryProcessor.isGeometryClass(cls)) {
            if (parent == null && !key && GridQueryProcessor.isSqlType(cls)) {
                String idxName = "_val_idx";
                type.addIndex(idxName, GridQueryProcessor.isGeometryClass(cls) ? GridQueryIndexType.GEO_SPATIAL : GridQueryIndexType.SORTED);
                type.addFieldToIndex(idxName, "_val", 0, false);
            }
            return;
        }
        if (parent != null && parent.knowsClass(cls)) {
            throw new CacheException("Recursive reference found in type: " + cls.getName());
        }
        if (parent == null) {
            QueryGroupIndex.List grpIdxList;
            QueryGroupIndex grpIdx;
            QueryTextField txtAnnCls = cls.getAnnotation(QueryTextField.class);
            if (txtAnnCls != null) {
                type.valueTextIndex(true);
            }
            if ((grpIdx = cls.getAnnotation(QueryGroupIndex.class)) != null) {
                type.addIndex(grpIdx.name(), GridQueryIndexType.SORTED);
            }
            if ((grpIdxList = cls.getAnnotation(QueryGroupIndex.List.class)) != null && !F.isEmpty(grpIdxList.value())) {
                for (QueryGroupIndex idx : grpIdxList.value()) {
                    type.addIndex(idx.name(), GridQueryIndexType.SORTED);
                }
            }
        }
        for (Class<?> c = cls; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            ClassProperty prop;
            QueryTextField txtAnn;
            for (Field field : c.getDeclaredFields()) {
                QuerySqlField sqlAnn = field.getAnnotation(QuerySqlField.class);
                txtAnn = field.getAnnotation(QueryTextField.class);
                if (sqlAnn == null && txtAnn == null) continue;
                prop = new ClassProperty(field);
                prop.parent(parent);
                CacheConfiguration.processAnnotation(key, sqlAnn, txtAnn, field.getType(), prop, type);
                type.addProperty(prop, key, true);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (((Method)accessibleObject).isBridge()) continue;
                QuerySqlField sqlAnn = ((Method)accessibleObject).getAnnotation(QuerySqlField.class);
                txtAnn = ((Method)accessibleObject).getAnnotation(QueryTextField.class);
                if (sqlAnn == null && txtAnn == null) continue;
                if (((Method)accessibleObject).getParameterTypes().length != 0) {
                    throw new CacheException("Getter with QuerySqlField annotation cannot have parameters: " + accessibleObject);
                }
                prop = new ClassProperty((Member)((Object)accessibleObject));
                prop.parent(parent);
                CacheConfiguration.processAnnotation(key, sqlAnn, txtAnn, ((Method)accessibleObject).getReturnType(), prop, type);
                type.addProperty(prop, key, true);
            }
        }
    }

    private static void processAnnotation(boolean key, QuerySqlField sqlAnn, QueryTextField txtAnn, Class<?> cls, ClassProperty prop, TypeDescriptor desc) {
        if (sqlAnn != null) {
            CacheConfiguration.processAnnotationsInClass(key, cls, desc, prop);
            if (!sqlAnn.name().isEmpty()) {
                prop.alias(sqlAnn.name());
            }
            if (sqlAnn.index()) {
                String idxName = prop.alias() + "_idx";
                desc.addIndex(idxName, GridQueryProcessor.isGeometryClass(prop.type()) ? GridQueryIndexType.GEO_SPATIAL : GridQueryIndexType.SORTED);
                desc.addFieldToIndex(idxName, prop.fullName(), 0, sqlAnn.descending());
            }
            if (!F.isEmpty(sqlAnn.groups())) {
                for (String group : sqlAnn.groups()) {
                    desc.addFieldToIndex(group, prop.fullName(), 0, false);
                }
            }
            if (!F.isEmpty(sqlAnn.orderedGroups())) {
                for (QuerySqlField.Group idx : sqlAnn.orderedGroups()) {
                    desc.addFieldToIndex(idx.name(), prop.fullName(), idx.order(), idx.descending());
                }
            }
        }
        if (txtAnn != null) {
            desc.addFieldToTextIndex(prop.fullName());
        }
    }

    public String toString() {
        return S.toString(CacheConfiguration.class, this);
    }

    private static class ClassProperty {
        private final Member member;
        private ClassProperty parent;
        private String name;
        private String alias;

        ClassProperty(Member member) {
            this.member = member;
            this.name = member.getName();
            if (member instanceof Method) {
                if (member.getName().startsWith("get") && member.getName().length() > 3) {
                    this.name = member.getName().substring(3);
                }
                if (member.getName().startsWith("is") && member.getName().length() > 2) {
                    this.name = member.getName().substring(2);
                }
            }
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }

        public void alias(String alias) {
            this.alias = alias;
        }

        String alias() {
            return F.isEmpty(this.alias) ? this.name : this.alias;
        }

        public Class<?> type() {
            return this.member instanceof Field ? ((Field)this.member).getType() : ((Method)this.member).getReturnType();
        }

        public void parent(ClassProperty parent) {
            this.parent = parent;
        }

        public String toString() {
            return S.toString(ClassProperty.class, this);
        }

        public boolean knowsClass(Class<?> cls) {
            return this.member.getDeclaringClass() == cls || this.parent != null && this.parent.knowsClass(cls);
        }

        public String fullName() {
            assert (this.name != null);
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.fullName() + '.' + this.name;
        }
    }

    private static class IndexDescriptor
    implements GridQueryIndexDescriptor {
        private final Collection<T2<String, Integer>> fields = new TreeSet<T2<String, Integer>>(new Comparator<T2<String, Integer>>(){

            @Override
            public int compare(T2<String, Integer> o1, T2<String, Integer> o2) {
                if (((Integer)o1.get2()).equals(o2.get2())) {
                    return ((String)o1.get1()).compareTo((String)o2.get1());
                }
                return (Integer)o1.get2() < (Integer)o2.get2() ? -1 : 1;
            }
        });
        private Collection<String> descendings;
        private final GridQueryIndexType type;

        private IndexDescriptor(GridQueryIndexType type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public Collection<String> fields() {
            ArrayList<String> res = new ArrayList<String>(this.fields.size());
            for (T2<String, Integer> t : this.fields) {
                res.add((String)t.get1());
            }
            return res;
        }

        @Override
        public boolean descending(String field) {
            return this.descendings != null && this.descendings.contains(field);
        }

        public void addField(String field, int orderNum, boolean descending) {
            this.fields.add(new T2<String, Integer>(field, orderNum));
            if (descending) {
                if (this.descendings == null) {
                    this.descendings = new HashSet<String>();
                }
                this.descendings.add(field);
            }
        }

        @Override
        public GridQueryIndexType type() {
            return this.type;
        }

        public String toString() {
            return S.toString(IndexDescriptor.class, this);
        }
    }

    private static class TypeDescriptor {
        @GridToStringInclude
        private final Map<String, Class<?>> fields = new LinkedHashMap();
        @GridToStringExclude
        private final Map<String, ClassProperty> props = new LinkedHashMap<String, ClassProperty>();
        @GridToStringInclude
        private final Set<String> keyProperties = new HashSet<String>();
        @GridToStringInclude
        private final Map<String, IndexDescriptor> indexes = new HashMap<String, IndexDescriptor>();
        private IndexDescriptor fullTextIdx;
        private Class<?> keyCls;
        private Class<?> valCls;
        private boolean valTextIdx;

        private TypeDescriptor() {
        }

        public Map<String, GridQueryIndexDescriptor> indexes() {
            return Collections.unmodifiableMap(this.indexes);
        }

        public IndexDescriptor addIndex(String idxName, GridQueryIndexType type) {
            IndexDescriptor idx = new IndexDescriptor(type);
            if (this.indexes.put(idxName, idx) != null) {
                throw new CacheException("Index with name '" + idxName + "' already exists.");
            }
            return idx;
        }

        public void addFieldToIndex(String idxName, String field, int orderNum, boolean descending) {
            IndexDescriptor desc = this.indexes.get(idxName);
            if (desc == null) {
                desc = this.addIndex(idxName, GridQueryIndexType.SORTED);
            }
            desc.addField(field, orderNum, descending);
        }

        public void addFieldToTextIndex(String field) {
            if (this.fullTextIdx == null) {
                this.fullTextIdx = new IndexDescriptor(GridQueryIndexType.FULLTEXT);
                this.indexes.put(null, this.fullTextIdx);
            }
            this.fullTextIdx.addField(field, 0, false);
        }

        public Class<?> valueClass() {
            return this.valCls;
        }

        void valueClass(Class<?> valCls) {
            this.valCls = valCls;
        }

        public Class<?> keyClass() {
            return this.keyCls;
        }

        void keyClass(Class<?> keyCls) {
            this.keyCls = keyCls;
        }

        void addProperty(ClassProperty prop, boolean key, boolean failOnDuplicate) {
            String name = prop.fullName();
            if (this.props.put(name, prop) != null && failOnDuplicate) {
                throw new CacheException("Property with name '" + name + "' already exists.");
            }
            this.fields.put(name, prop.type());
            if (key) {
                this.keyProperties.add(name);
            }
        }

        public boolean valueTextIndex() {
            return this.valTextIdx;
        }

        public void valueTextIndex(boolean valTextIdx) {
            this.valTextIdx = valTextIdx;
        }

        public String toString() {
            return S.toString(TypeDescriptor.class, this);
        }
    }

    public static class IgniteAllNodesPredicate
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;

        @Override
        public boolean apply(ClusterNode clusterNode) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(this.getClass());
        }
    }
}

