/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.configuration.ConnectorMessageInterceptor;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.jetbrains.annotations.Nullable;

public class ConnectorConfiguration {
    public static final int DFLT_TCP_PORT = 11211;
    public static final boolean DFLT_TCP_NODELAY = true;
    public static final boolean DFLT_TCP_DIRECT_BUF = false;
    public static final int DFLT_IDLE_TIMEOUT = 7000;
    public static final int DFLT_PORT_RANGE = 100;
    public static final int DFLT_REST_CORE_THREAD_CNT = IgniteConfiguration.DFLT_PUBLIC_THREAD_CNT;
    public static final int DFLT_REST_MAX_THREAD_CNT = IgniteConfiguration.DFLT_PUBLIC_THREAD_CNT;
    public static final long DFLT_KEEP_ALIVE_TIME = 0L;
    public static final int DFLT_THREADPOOL_QUEUE_CAP = Integer.MAX_VALUE;
    public static final int DFLT_SOCK_BUF_SIZE = 32768;
    private static final long DFLT_IDLE_QRY_CUR_TIMEOUT = 600000L;
    private static final long DFLT_IDLE_QRY_CUR_CHECK_FRQ = 60000L;
    private String jettyPath;
    private String secretKey;
    private String host;
    private int port = 11211;
    private boolean noDelay = true;
    private boolean directBuf = false;
    private int sndBufSize = 32768;
    private int rcvBufSize = 32768;
    private long idleQryCurTimeout = 600000L;
    private long idleQryCurCheckFreq = 60000L;
    private int sndQueueLimit;
    private int selectorCnt = Math.min(4, Runtime.getRuntime().availableProcessors());
    private long idleTimeout = 7000L;
    private boolean sslEnabled;
    private boolean sslClientAuth;
    private GridSslContextFactory sslCtxFactory;
    private Factory<SSLContext> sslFactory;
    private int portRange = 100;
    private int threadPoolSize = DFLT_REST_CORE_THREAD_CNT;
    private ConnectorMessageInterceptor msgInterceptor;

    public ConnectorConfiguration() {
    }

    public ConnectorConfiguration(ConnectorConfiguration cfg) {
        assert (cfg != null);
        this.msgInterceptor = cfg.getMessageInterceptor();
        this.threadPoolSize = cfg.getThreadPoolSize();
        this.idleTimeout = cfg.getIdleTimeout();
        this.jettyPath = cfg.getJettyPath();
        this.portRange = cfg.getPortRange();
        this.secretKey = cfg.getSecretKey();
        this.directBuf = cfg.isDirectBuffer();
        this.host = cfg.getHost();
        this.noDelay = cfg.isNoDelay();
        this.port = cfg.getPort();
        this.rcvBufSize = cfg.getReceiveBufferSize();
        this.selectorCnt = cfg.getSelectorCount();
        this.sndBufSize = cfg.getSendBufferSize();
        this.sndQueueLimit = cfg.getSendQueueLimit();
        this.sslClientAuth = cfg.isSslClientAuth();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.sslEnabled = cfg.isSslEnabled();
        this.sslFactory = cfg.getSslFactory();
        this.idleQryCurTimeout = cfg.getIdleQueryCursorTimeout();
        this.idleQryCurCheckFreq = cfg.getIdleQueryCursorCheckFrequency();
    }

    public void setJettyPath(String jettyPath) {
        this.jettyPath = jettyPath;
    }

    public String getJettyPath() {
        return this.jettyPath;
    }

    public void setSecretKey(@Nullable String secretKey) {
        this.secretKey = secretKey;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean isDirectBuffer() {
        return this.directBuf;
    }

    public void setDirectBuffer(boolean directBuf) {
        this.directBuf = directBuf;
    }

    public int getSendBufferSize() {
        return this.sndBufSize;
    }

    public void setSendBufferSize(int sndBufSize) {
        this.sndBufSize = sndBufSize;
    }

    public int getReceiveBufferSize() {
        return this.rcvBufSize;
    }

    public void setReceiveBufferSize(int rcvBufSize) {
        this.rcvBufSize = rcvBufSize;
    }

    public int getSendQueueLimit() {
        return this.sndQueueLimit;
    }

    public void setSendQueueLimit(int sndQueueLimit) {
        this.sndQueueLimit = sndQueueLimit;
    }

    public int getSelectorCount() {
        return this.selectorCnt;
    }

    public void setSelectorCount(int selectorCnt) {
        this.selectorCnt = selectorCnt;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isSslClientAuth() {
        return this.sslClientAuth;
    }

    public void setSslClientAuth(boolean sslClientAuth) {
        this.sslClientAuth = sslClientAuth;
    }

    @Deprecated
    public GridSslContextFactory getSslContextFactory() {
        return this.sslCtxFactory;
    }

    @Deprecated
    public void setSslContextFactory(GridSslContextFactory sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
    }

    public Factory<SSLContext> getSslFactory() {
        return this.sslFactory;
    }

    public void setSslFactory(Factory<SSLContext> sslFactory) {
        this.sslFactory = sslFactory;
    }

    public int getPortRange() {
        return this.portRange;
    }

    public void setPortRange(int portRange) {
        this.portRange = portRange;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    @Nullable
    public ConnectorMessageInterceptor getMessageInterceptor() {
        return this.msgInterceptor;
    }

    public void setMessageInterceptor(ConnectorMessageInterceptor interceptor) {
        this.msgInterceptor = interceptor;
    }

    public void setIdleQueryCursorTimeout(long idleQryCurTimeout) {
        this.idleQryCurTimeout = idleQryCurTimeout;
    }

    public long getIdleQueryCursorTimeout() {
        return this.idleQryCurTimeout;
    }

    public void setIdleQueryCursorCheckFrequency(long idleQryCurCheckFreq) {
        this.idleQryCurCheckFreq = idleQryCurCheckFreq;
    }

    public long getIdleQueryCursorCheckFrequency() {
        return this.idleQryCurCheckFreq;
    }
}

