/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class FileSystemConfiguration {
    public static final String DFLT_USER_NAME = System.getProperty("user.name", "anonymous");
    public static final long DFLT_FRAGMENTIZER_THROTTLING_BLOCK_LENGTH = 0x1000000L;
    public static final long DFLT_FRAGMENTIZER_THROTTLING_DELAY = 200L;
    public static final int DFLT_FRAGMENTIZER_CONCURRENT_FILES = 0;
    public static final float DFLT_FRAGMENTIZER_LOCAL_WRITES_RATIO = 0.8f;
    public static final boolean DFLT_FRAGMENTIZER_ENABLED = true;
    public static final int DFLT_IGFS_LOG_BATCH_SIZE = 100;
    public static final String DFLT_IGFS_LOG_DIR = "work/igfs/log";
    public static final int DFLT_PER_NODE_BATCH_SIZE = 512;
    public static final int DFLT_PER_NODE_PARALLEL_BATCH_CNT = 16;
    public static final IgfsMode DFLT_MODE = IgfsMode.DUAL_ASYNC;
    public static final int DFLT_BLOCK_SIZE = 65536;
    public static final int DFLT_BUF_SIZE = 65536;
    public static final long DFLT_TRASH_PURGE_TIMEOUT = 1000L;
    public static final int DFLT_MGMT_PORT = 11400;
    public static final boolean DFLT_IPC_ENDPOINT_ENABLED = true;
    public static final boolean DFLT_INIT_DFLT_PATH_MODES = false;
    public static final boolean DFLT_COLOCATE_META = true;
    public static final boolean DFLT_RELAXED_CONSISTENCY = true;
    public static final boolean DFLT_UPDATE_FILE_LEN_ON_FLUSH = false;
    private String name;
    private String metaCacheName;
    private String dataCacheName;
    private int blockSize = 65536;
    private int prefetchBlocks;
    private int seqReadsBeforePrefetch;
    private int bufSize = 65536;
    private int perNodeBatchSize = 512;
    private int perNodeParallelBatchCnt = 16;
    private IgfsIpcEndpointConfiguration ipcEndpointCfg;
    private boolean ipcEndpointEnabled = true;
    private int mgmtPort = 11400;
    private IgfsSecondaryFileSystem secondaryFs;
    private IgfsMode dfltMode = DFLT_MODE;
    private long fragmentizerThrottlingBlockLen = 0x1000000L;
    private long fragmentizerThrottlingDelay = 200L;
    private int fragmentizerConcurrentFiles = 0;
    private float fragmentizerLocWritesRatio = 0.8f;
    private boolean fragmentizerEnabled = true;
    private Map<String, IgfsMode> pathModes;
    private long maxSpace;
    private long trashPurgeTimeout = 1000L;
    private ExecutorService dualModePutExec;
    private boolean dualModePutExecShutdown;
    private long dualModeMaxPendingPutsSize;
    private long maxTaskRangeLen;
    private boolean initDfltPathModes = false;
    private boolean colocateMeta = true;
    private boolean relaxedConsistency = true;
    private boolean updateFileLenOnFlush = false;

    public FileSystemConfiguration() {
    }

    public FileSystemConfiguration(FileSystemConfiguration cfg) {
        assert (cfg != null);
        this.blockSize = cfg.getBlockSize();
        this.bufSize = cfg.getStreamBufferSize();
        this.colocateMeta = cfg.isColocateMetadata();
        this.dataCacheName = cfg.getDataCacheName();
        this.dfltMode = cfg.getDefaultMode();
        this.dualModeMaxPendingPutsSize = cfg.getDualModeMaxPendingPutsSize();
        this.dualModePutExec = cfg.getDualModePutExecutorService();
        this.dualModePutExecShutdown = cfg.getDualModePutExecutorServiceShutdown();
        this.fragmentizerConcurrentFiles = cfg.getFragmentizerConcurrentFiles();
        this.fragmentizerLocWritesRatio = cfg.getFragmentizerLocalWritesRatio();
        this.fragmentizerEnabled = cfg.isFragmentizerEnabled();
        this.fragmentizerThrottlingBlockLen = cfg.getFragmentizerThrottlingBlockLength();
        this.fragmentizerThrottlingDelay = cfg.getFragmentizerThrottlingDelay();
        this.secondaryFs = cfg.getSecondaryFileSystem();
        this.initDfltPathModes = cfg.isInitializeDefaultPathModes();
        this.ipcEndpointCfg = cfg.getIpcEndpointConfiguration();
        this.ipcEndpointEnabled = cfg.isIpcEndpointEnabled();
        this.maxSpace = cfg.getMaxSpaceSize();
        this.maxTaskRangeLen = cfg.getMaximumTaskRangeLength();
        this.metaCacheName = cfg.getMetaCacheName();
        this.mgmtPort = cfg.getManagementPort();
        this.name = cfg.getName();
        this.pathModes = cfg.getPathModes();
        this.perNodeBatchSize = cfg.getPerNodeBatchSize();
        this.perNodeParallelBatchCnt = cfg.getPerNodeParallelBatchCount();
        this.prefetchBlocks = cfg.getPrefetchBlocks();
        this.relaxedConsistency = cfg.isRelaxedConsistency();
        this.seqReadsBeforePrefetch = cfg.getSequentialReadsBeforePrefetch();
        this.trashPurgeTimeout = cfg.getTrashPurgeTimeout();
        this.updateFileLenOnFlush = cfg.isUpdateFileLengthOnFlush();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getMetaCacheName() {
        return this.metaCacheName;
    }

    public void setMetaCacheName(String metaCacheName) {
        this.metaCacheName = metaCacheName;
    }

    @Nullable
    public String getDataCacheName() {
        return this.dataCacheName;
    }

    public void setDataCacheName(String dataCacheName) {
        this.dataCacheName = dataCacheName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        A.ensure(blockSize >= 0, "blockSize >= 0");
        this.blockSize = blockSize == 0 ? 65536 : blockSize;
    }

    public int getPrefetchBlocks() {
        return this.prefetchBlocks;
    }

    public void setPrefetchBlocks(int prefetchBlocks) {
        A.ensure(prefetchBlocks >= 0, "prefetchBlocks >= 0");
        this.prefetchBlocks = prefetchBlocks;
    }

    public int getSequentialReadsBeforePrefetch() {
        return this.seqReadsBeforePrefetch;
    }

    public void setSequentialReadsBeforePrefetch(int seqReadsBeforePrefetch) {
        A.ensure(seqReadsBeforePrefetch >= 0, "seqReadsBeforePrefetch >= 0");
        this.seqReadsBeforePrefetch = seqReadsBeforePrefetch;
    }

    public int getStreamBufferSize() {
        return this.bufSize;
    }

    public void setStreamBufferSize(int bufSize) {
        A.ensure(bufSize >= 0, "bufSize >= 0");
        this.bufSize = bufSize == 0 ? 65536 : bufSize;
    }

    public int getPerNodeBatchSize() {
        return this.perNodeBatchSize;
    }

    public void setPerNodeBatchSize(int perNodeBatchSize) {
        this.perNodeBatchSize = perNodeBatchSize;
    }

    public int getPerNodeParallelBatchCount() {
        return this.perNodeParallelBatchCnt;
    }

    public void setPerNodeParallelBatchCount(int perNodeParallelBatchCnt) {
        this.perNodeParallelBatchCnt = perNodeParallelBatchCnt;
    }

    @Nullable
    public IgfsIpcEndpointConfiguration getIpcEndpointConfiguration() {
        return this.ipcEndpointCfg;
    }

    public void setIpcEndpointConfiguration(@Nullable IgfsIpcEndpointConfiguration ipcEndpointCfg) {
        this.ipcEndpointCfg = ipcEndpointCfg;
    }

    public boolean isIpcEndpointEnabled() {
        return this.ipcEndpointEnabled;
    }

    public void setIpcEndpointEnabled(boolean ipcEndpointEnabled) {
        this.ipcEndpointEnabled = ipcEndpointEnabled;
    }

    public int getManagementPort() {
        return this.mgmtPort;
    }

    public void setManagementPort(int mgmtPort) {
        this.mgmtPort = mgmtPort;
    }

    public IgfsMode getDefaultMode() {
        return this.dfltMode;
    }

    public void setDefaultMode(IgfsMode dfltMode) {
        this.dfltMode = dfltMode;
    }

    public IgfsSecondaryFileSystem getSecondaryFileSystem() {
        return this.secondaryFs;
    }

    public void setSecondaryFileSystem(IgfsSecondaryFileSystem fileSystem) {
        this.secondaryFs = fileSystem;
    }

    @Nullable
    public Map<String, IgfsMode> getPathModes() {
        return this.pathModes;
    }

    public void setPathModes(Map<String, IgfsMode> pathModes) {
        this.pathModes = pathModes;
    }

    public long getFragmentizerThrottlingBlockLength() {
        return this.fragmentizerThrottlingBlockLen;
    }

    public void setFragmentizerThrottlingBlockLength(long fragmentizerThrottlingBlockLen) {
        this.fragmentizerThrottlingBlockLen = fragmentizerThrottlingBlockLen;
    }

    public long getFragmentizerThrottlingDelay() {
        return this.fragmentizerThrottlingDelay;
    }

    public void setFragmentizerThrottlingDelay(long fragmentizerThrottlingDelay) {
        this.fragmentizerThrottlingDelay = fragmentizerThrottlingDelay;
    }

    public int getFragmentizerConcurrentFiles() {
        return this.fragmentizerConcurrentFiles;
    }

    public void setFragmentizerConcurrentFiles(int fragmentizerConcurrentFiles) {
        this.fragmentizerConcurrentFiles = fragmentizerConcurrentFiles;
    }

    @Deprecated
    public float getFragmentizerLocalWritesRatio() {
        return this.fragmentizerLocWritesRatio;
    }

    @Deprecated
    public void setFragmentizerLocalWritesRatio(float fragmentizerLocWritesRatio) {
        this.fragmentizerLocWritesRatio = fragmentizerLocWritesRatio;
    }

    public boolean isFragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    public void setFragmentizerEnabled(boolean fragmentizerEnabled) {
        this.fragmentizerEnabled = fragmentizerEnabled;
    }

    public long getMaxSpaceSize() {
        return this.maxSpace;
    }

    public void setMaxSpaceSize(long maxSpace) {
        this.maxSpace = maxSpace;
    }

    @Deprecated
    public long getTrashPurgeTimeout() {
        return this.trashPurgeTimeout;
    }

    @Deprecated
    public void setTrashPurgeTimeout(long trashPurgeTimeout) {
        this.trashPurgeTimeout = trashPurgeTimeout;
    }

    @Deprecated
    @Nullable
    public ExecutorService getDualModePutExecutorService() {
        return this.dualModePutExec;
    }

    @Deprecated
    public void setDualModePutExecutorService(ExecutorService dualModePutExec) {
        this.dualModePutExec = dualModePutExec;
    }

    @Deprecated
    public boolean getDualModePutExecutorServiceShutdown() {
        return this.dualModePutExecShutdown;
    }

    @Deprecated
    public void setDualModePutExecutorServiceShutdown(boolean dualModePutExecShutdown) {
        this.dualModePutExecShutdown = dualModePutExecShutdown;
    }

    @Deprecated
    public long getDualModeMaxPendingPutsSize() {
        return this.dualModeMaxPendingPutsSize;
    }

    @Deprecated
    public void setDualModeMaxPendingPutsSize(long dualModeMaxPendingPutsSize) {
        this.dualModeMaxPendingPutsSize = dualModeMaxPendingPutsSize;
    }

    public long getMaximumTaskRangeLength() {
        return this.maxTaskRangeLen;
    }

    public void setMaximumTaskRangeLength(long maxTaskRangeLen) {
        this.maxTaskRangeLen = maxTaskRangeLen;
    }

    public boolean isInitializeDefaultPathModes() {
        return this.initDfltPathModes;
    }

    public void setInitializeDefaultPathModes(boolean initDfltPathModes) {
        this.initDfltPathModes = initDfltPathModes;
    }

    public boolean isColocateMetadata() {
        return this.colocateMeta;
    }

    public void setColocateMetadata(boolean colocateMeta) {
        this.colocateMeta = colocateMeta;
    }

    public boolean isRelaxedConsistency() {
        return this.relaxedConsistency;
    }

    public void setRelaxedConsistency(boolean relaxedConsistency) {
        this.relaxedConsistency = relaxedConsistency;
    }

    public boolean isUpdateFileLengthOnFlush() {
        return this.updateFileLenOnFlush;
    }

    public void setUpdateFileLengthOnFlush(boolean updateFileLenOnFlush) {
        this.updateFileLenOnFlush = updateFileLenOnFlush;
    }

    public String toString() {
        return S.toString(FileSystemConfiguration.class, this);
    }
}

