/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import org.apache.ignite.internal.processors.hadoop.HadoopMapReducePlanner;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class HadoopConfiguration {
    public static final long DFLT_FINISHED_JOB_INFO_TTL = 30000L;
    public static final boolean DFLT_EXTERNAL_EXECUTION = false;
    public static final int DFLT_MAX_PARALLEL_TASKS = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DFLT_MAX_TASK_QUEUE_SIZE = 8192;
    private HadoopMapReducePlanner planner;
    private boolean extExecution = false;
    private long finishedJobInfoTtl = 30000L;
    private int maxParallelTasks = DFLT_MAX_PARALLEL_TASKS;
    private int maxTaskQueueSize = 8192;
    private String[] libNames;

    public HadoopConfiguration() {
    }

    public HadoopConfiguration(HadoopConfiguration cfg) {
        this.finishedJobInfoTtl = cfg.getFinishedJobInfoTtl();
        this.planner = cfg.getMapReducePlanner();
        this.maxParallelTasks = cfg.getMaxParallelTasks();
        this.maxTaskQueueSize = cfg.getMaxTaskQueueSize();
        this.libNames = cfg.getNativeLibraryNames();
    }

    public int getMaxParallelTasks() {
        return this.maxParallelTasks;
    }

    public void setMaxParallelTasks(int maxParallelTasks) {
        this.maxParallelTasks = maxParallelTasks;
    }

    public int getMaxTaskQueueSize() {
        return this.maxTaskQueueSize;
    }

    public void setMaxTaskQueueSize(int maxTaskQueueSize) {
        this.maxTaskQueueSize = maxTaskQueueSize;
    }

    public long getFinishedJobInfoTtl() {
        return this.finishedJobInfoTtl;
    }

    public void setFinishedJobInfoTtl(long finishedJobInfoTtl) {
        this.finishedJobInfoTtl = finishedJobInfoTtl;
    }

    public HadoopMapReducePlanner getMapReducePlanner() {
        return this.planner;
    }

    public void setMapReducePlanner(HadoopMapReducePlanner planner) {
        this.planner = planner;
    }

    @Nullable
    public String[] getNativeLibraryNames() {
        return this.libNames;
    }

    public void setNativeLibraryNames(String ... libNames) {
        this.libNames = libNames;
    }

    public String toString() {
        return S.toString(HadoopConfiguration.class, this, super.toString());
    }
}

