/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.configuration.Factory;
import org.apache.ignite.internal.util.typedef.F;

public class IgniteReflectionFactory<T>
implements Factory<T> {
    private static final long serialVersionUID = 0L;
    private volatile boolean singleton;
    private volatile Class<? extends T> cls;
    private volatile Map<String, Serializable> props;
    private transient T instance;

    public IgniteReflectionFactory() {
    }

    public IgniteReflectionFactory(Class<? extends T> cls, boolean singleton) {
        this.cls = cls;
        this.singleton = singleton;
    }

    public IgniteReflectionFactory(Class<? extends T> cls) {
        this(cls, false);
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Class<? extends T> getComponentClass() {
        return this.cls;
    }

    public void setComponentClass(Class<T> cls) {
        this.cls = cls;
    }

    public Map<String, Serializable> getProperties() {
        return this.props;
    }

    public void setProperties(Map<String, Serializable> props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() {
        IgniteReflectionFactory igniteReflectionFactory = this;
        synchronized (igniteReflectionFactory) {
            if (this.singleton) {
                if (this.instance == null) {
                    this.instance = this.createInstance();
                }
                return this.instance;
            }
            return this.createInstance();
        }
    }

    private T createInstance() {
        if (this.cls == null) {
            throw new IllegalStateException("Failed to create object (object type is not set).");
        }
        try {
            T obj = this.cls.newInstance();
            this.injectProperties(obj);
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CacheException("Failed to instantiate factory object: " + this.cls.getName(), e);
        }
    }

    private void injectProperties(T obj) {
        if (!F.isEmpty(this.props)) {
            for (Map.Entry<String, Serializable> entry : this.props.entrySet()) {
                String fieldName = entry.getKey().trim();
                if (fieldName.isEmpty()) continue;
                Serializable val = entry.getValue();
                this.setWithMethod(obj, fieldName, val);
            }
        }
    }

    private boolean setWithMethod(T obj, String fieldName, Serializable val) {
        StringBuilder sb = new StringBuilder("set");
        sb.append(fieldName);
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        for (Class<?> paramCls = val.getClass(); paramCls != null; paramCls = paramCls.getSuperclass()) {
            try {
                Method mtd = obj.getClass().getMethod(sb.toString(), paramCls);
                mtd.invoke(obj, val);
                return true;
            }
            catch (InvocationTargetException e) {
                throw new CacheException(e.getCause());
            }
            catch (IllegalAccessException | NoSuchMethodException ignore) {
                continue;
            }
        }
        for (Class<?> itf : val.getClass().getInterfaces()) {
            try {
                Method mtd = obj.getClass().getMethod(sb.toString(), itf);
                mtd.invoke(obj, val);
                return true;
            }
            catch (InvocationTargetException e) {
                throw new CacheException(e.getCause());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            }
        }
        return false;
    }
}

